/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrassv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about how long a component on a core device can validate its configuration updates before it
 * times out. Components can use the <a href=
 * "https://docs.aws.amazon.com/greengrass/v2/developerguide/interprocess-communication.html#ipc-operation-subscribetovalidateconfigurationupdates"
 * >SubscribeToValidateConfigurationUpdates</a> IPC operation to receive notifications when a deployment specifies a
 * configuration update. Then, components can respond with the <a href=
 * "https://docs.aws.amazon.com/greengrass/v2/developerguide/interprocess-communication.html#ipc-operation-sendconfigurationvalidityreport"
 * >SendConfigurationValidityReport</a> IPC operation. For more information, see <a
 * href="https://docs.aws.amazon.com/greengrass/v2/developerguide/create-deployments.html">Create deployments</a> in the
 * <i>AWS IoT Greengrass V2 Developer Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeploymentConfigurationValidationPolicy implements SdkPojo, Serializable,
        ToCopyableBuilder<DeploymentConfigurationValidationPolicy.Builder, DeploymentConfigurationValidationPolicy> {
    private static final SdkField<Integer> TIMEOUT_IN_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("timeoutInSeconds").getter(getter(DeploymentConfigurationValidationPolicy::timeoutInSeconds))
            .setter(setter(Builder::timeoutInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutInSeconds").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMEOUT_IN_SECONDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer timeoutInSeconds;

    private DeploymentConfigurationValidationPolicy(BuilderImpl builder) {
        this.timeoutInSeconds = builder.timeoutInSeconds;
    }

    /**
     * <p>
     * The amount of time in seconds that a component can validate its configuration updates. If the validation time
     * exceeds this timeout, then the deployment proceeds for the device.
     * </p>
     * <p>
     * Default: <code>30</code>
     * </p>
     * 
     * @return The amount of time in seconds that a component can validate its configuration updates. If the validation
     *         time exceeds this timeout, then the deployment proceeds for the device.</p>
     *         <p>
     *         Default: <code>30</code>
     */
    public final Integer timeoutInSeconds() {
        return timeoutInSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timeoutInSeconds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentConfigurationValidationPolicy)) {
            return false;
        }
        DeploymentConfigurationValidationPolicy other = (DeploymentConfigurationValidationPolicy) obj;
        return Objects.equals(timeoutInSeconds(), other.timeoutInSeconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeploymentConfigurationValidationPolicy").add("TimeoutInSeconds", timeoutInSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "timeoutInSeconds":
            return Optional.ofNullable(clazz.cast(timeoutInSeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeploymentConfigurationValidationPolicy, T> g) {
        return obj -> g.apply((DeploymentConfigurationValidationPolicy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeploymentConfigurationValidationPolicy> {
        /**
         * <p>
         * The amount of time in seconds that a component can validate its configuration updates. If the validation time
         * exceeds this timeout, then the deployment proceeds for the device.
         * </p>
         * <p>
         * Default: <code>30</code>
         * </p>
         * 
         * @param timeoutInSeconds
         *        The amount of time in seconds that a component can validate its configuration updates. If the
         *        validation time exceeds this timeout, then the deployment proceeds for the device.</p>
         *        <p>
         *        Default: <code>30</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeoutInSeconds(Integer timeoutInSeconds);
    }

    static final class BuilderImpl implements Builder {
        private Integer timeoutInSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(DeploymentConfigurationValidationPolicy model) {
            timeoutInSeconds(model.timeoutInSeconds);
        }

        public final Integer getTimeoutInSeconds() {
            return timeoutInSeconds;
        }

        @Override
        public final Builder timeoutInSeconds(Integer timeoutInSeconds) {
            this.timeoutInSeconds = timeoutInSeconds;
            return this;
        }

        public final void setTimeoutInSeconds(Integer timeoutInSeconds) {
            this.timeoutInSeconds = timeoutInSeconds;
        }

        @Override
        public DeploymentConfigurationValidationPolicy build() {
            return new DeploymentConfigurationValidationPolicy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
