/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrassv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about an AWS IoT job configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeploymentIoTJobConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<DeploymentIoTJobConfiguration.Builder, DeploymentIoTJobConfiguration> {
    private static final SdkField<IoTJobExecutionsRolloutConfig> JOB_EXECUTIONS_ROLLOUT_CONFIG_FIELD = SdkField
            .<IoTJobExecutionsRolloutConfig> builder(MarshallingType.SDK_POJO)
            .memberName("jobExecutionsRolloutConfig")
            .getter(getter(DeploymentIoTJobConfiguration::jobExecutionsRolloutConfig))
            .setter(setter(Builder::jobExecutionsRolloutConfig))
            .constructor(IoTJobExecutionsRolloutConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobExecutionsRolloutConfig").build())
            .build();

    private static final SdkField<IoTJobAbortConfig> ABORT_CONFIG_FIELD = SdkField
            .<IoTJobAbortConfig> builder(MarshallingType.SDK_POJO).memberName("abortConfig")
            .getter(getter(DeploymentIoTJobConfiguration::abortConfig)).setter(setter(Builder::abortConfig))
            .constructor(IoTJobAbortConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("abortConfig").build()).build();

    private static final SdkField<IoTJobTimeoutConfig> TIMEOUT_CONFIG_FIELD = SdkField
            .<IoTJobTimeoutConfig> builder(MarshallingType.SDK_POJO).memberName("timeoutConfig")
            .getter(getter(DeploymentIoTJobConfiguration::timeoutConfig)).setter(setter(Builder::timeoutConfig))
            .constructor(IoTJobTimeoutConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            JOB_EXECUTIONS_ROLLOUT_CONFIG_FIELD, ABORT_CONFIG_FIELD, TIMEOUT_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final IoTJobExecutionsRolloutConfig jobExecutionsRolloutConfig;

    private final IoTJobAbortConfig abortConfig;

    private final IoTJobTimeoutConfig timeoutConfig;

    private DeploymentIoTJobConfiguration(BuilderImpl builder) {
        this.jobExecutionsRolloutConfig = builder.jobExecutionsRolloutConfig;
        this.abortConfig = builder.abortConfig;
        this.timeoutConfig = builder.timeoutConfig;
    }

    /**
     * <p>
     * The rollout configuration for the job. This configuration defines the rate at which the job rolls out to the
     * fleet of target devices.
     * </p>
     * 
     * @return The rollout configuration for the job. This configuration defines the rate at which the job rolls out to
     *         the fleet of target devices.
     */
    public final IoTJobExecutionsRolloutConfig jobExecutionsRolloutConfig() {
        return jobExecutionsRolloutConfig;
    }

    /**
     * <p>
     * The stop configuration for the job. This configuration defines when and how to stop a job rollout.
     * </p>
     * 
     * @return The stop configuration for the job. This configuration defines when and how to stop a job rollout.
     */
    public final IoTJobAbortConfig abortConfig() {
        return abortConfig;
    }

    /**
     * <p>
     * The timeout configuration for the job. This configuration defines the amount of time each device has to complete
     * the job.
     * </p>
     * 
     * @return The timeout configuration for the job. This configuration defines the amount of time each device has to
     *         complete the job.
     */
    public final IoTJobTimeoutConfig timeoutConfig() {
        return timeoutConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobExecutionsRolloutConfig());
        hashCode = 31 * hashCode + Objects.hashCode(abortConfig());
        hashCode = 31 * hashCode + Objects.hashCode(timeoutConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentIoTJobConfiguration)) {
            return false;
        }
        DeploymentIoTJobConfiguration other = (DeploymentIoTJobConfiguration) obj;
        return Objects.equals(jobExecutionsRolloutConfig(), other.jobExecutionsRolloutConfig())
                && Objects.equals(abortConfig(), other.abortConfig()) && Objects.equals(timeoutConfig(), other.timeoutConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeploymentIoTJobConfiguration").add("JobExecutionsRolloutConfig", jobExecutionsRolloutConfig())
                .add("AbortConfig", abortConfig()).add("TimeoutConfig", timeoutConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobExecutionsRolloutConfig":
            return Optional.ofNullable(clazz.cast(jobExecutionsRolloutConfig()));
        case "abortConfig":
            return Optional.ofNullable(clazz.cast(abortConfig()));
        case "timeoutConfig":
            return Optional.ofNullable(clazz.cast(timeoutConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeploymentIoTJobConfiguration, T> g) {
        return obj -> g.apply((DeploymentIoTJobConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeploymentIoTJobConfiguration> {
        /**
         * <p>
         * The rollout configuration for the job. This configuration defines the rate at which the job rolls out to the
         * fleet of target devices.
         * </p>
         * 
         * @param jobExecutionsRolloutConfig
         *        The rollout configuration for the job. This configuration defines the rate at which the job rolls out
         *        to the fleet of target devices.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobExecutionsRolloutConfig(IoTJobExecutionsRolloutConfig jobExecutionsRolloutConfig);

        /**
         * <p>
         * The rollout configuration for the job. This configuration defines the rate at which the job rolls out to the
         * fleet of target devices.
         * </p>
         * This is a convenience that creates an instance of the {@link IoTJobExecutionsRolloutConfig.Builder} avoiding
         * the need to create one manually via {@link IoTJobExecutionsRolloutConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link IoTJobExecutionsRolloutConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #jobExecutionsRolloutConfig(IoTJobExecutionsRolloutConfig)}.
         * 
         * @param jobExecutionsRolloutConfig
         *        a consumer that will call methods on {@link IoTJobExecutionsRolloutConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobExecutionsRolloutConfig(IoTJobExecutionsRolloutConfig)
         */
        default Builder jobExecutionsRolloutConfig(Consumer<IoTJobExecutionsRolloutConfig.Builder> jobExecutionsRolloutConfig) {
            return jobExecutionsRolloutConfig(IoTJobExecutionsRolloutConfig.builder().applyMutation(jobExecutionsRolloutConfig)
                    .build());
        }

        /**
         * <p>
         * The stop configuration for the job. This configuration defines when and how to stop a job rollout.
         * </p>
         * 
         * @param abortConfig
         *        The stop configuration for the job. This configuration defines when and how to stop a job rollout.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder abortConfig(IoTJobAbortConfig abortConfig);

        /**
         * <p>
         * The stop configuration for the job. This configuration defines when and how to stop a job rollout.
         * </p>
         * This is a convenience that creates an instance of the {@link IoTJobAbortConfig.Builder} avoiding the need to
         * create one manually via {@link IoTJobAbortConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link IoTJobAbortConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #abortConfig(IoTJobAbortConfig)}.
         * 
         * @param abortConfig
         *        a consumer that will call methods on {@link IoTJobAbortConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #abortConfig(IoTJobAbortConfig)
         */
        default Builder abortConfig(Consumer<IoTJobAbortConfig.Builder> abortConfig) {
            return abortConfig(IoTJobAbortConfig.builder().applyMutation(abortConfig).build());
        }

        /**
         * <p>
         * The timeout configuration for the job. This configuration defines the amount of time each device has to
         * complete the job.
         * </p>
         * 
         * @param timeoutConfig
         *        The timeout configuration for the job. This configuration defines the amount of time each device has
         *        to complete the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeoutConfig(IoTJobTimeoutConfig timeoutConfig);

        /**
         * <p>
         * The timeout configuration for the job. This configuration defines the amount of time each device has to
         * complete the job.
         * </p>
         * This is a convenience that creates an instance of the {@link IoTJobTimeoutConfig.Builder} avoiding the need
         * to create one manually via {@link IoTJobTimeoutConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link IoTJobTimeoutConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #timeoutConfig(IoTJobTimeoutConfig)}.
         * 
         * @param timeoutConfig
         *        a consumer that will call methods on {@link IoTJobTimeoutConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeoutConfig(IoTJobTimeoutConfig)
         */
        default Builder timeoutConfig(Consumer<IoTJobTimeoutConfig.Builder> timeoutConfig) {
            return timeoutConfig(IoTJobTimeoutConfig.builder().applyMutation(timeoutConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private IoTJobExecutionsRolloutConfig jobExecutionsRolloutConfig;

        private IoTJobAbortConfig abortConfig;

        private IoTJobTimeoutConfig timeoutConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(DeploymentIoTJobConfiguration model) {
            jobExecutionsRolloutConfig(model.jobExecutionsRolloutConfig);
            abortConfig(model.abortConfig);
            timeoutConfig(model.timeoutConfig);
        }

        public final IoTJobExecutionsRolloutConfig.Builder getJobExecutionsRolloutConfig() {
            return jobExecutionsRolloutConfig != null ? jobExecutionsRolloutConfig.toBuilder() : null;
        }

        @Override
        public final Builder jobExecutionsRolloutConfig(IoTJobExecutionsRolloutConfig jobExecutionsRolloutConfig) {
            this.jobExecutionsRolloutConfig = jobExecutionsRolloutConfig;
            return this;
        }

        public final void setJobExecutionsRolloutConfig(IoTJobExecutionsRolloutConfig.BuilderImpl jobExecutionsRolloutConfig) {
            this.jobExecutionsRolloutConfig = jobExecutionsRolloutConfig != null ? jobExecutionsRolloutConfig.build() : null;
        }

        public final IoTJobAbortConfig.Builder getAbortConfig() {
            return abortConfig != null ? abortConfig.toBuilder() : null;
        }

        @Override
        public final Builder abortConfig(IoTJobAbortConfig abortConfig) {
            this.abortConfig = abortConfig;
            return this;
        }

        public final void setAbortConfig(IoTJobAbortConfig.BuilderImpl abortConfig) {
            this.abortConfig = abortConfig != null ? abortConfig.build() : null;
        }

        public final IoTJobTimeoutConfig.Builder getTimeoutConfig() {
            return timeoutConfig != null ? timeoutConfig.toBuilder() : null;
        }

        @Override
        public final Builder timeoutConfig(IoTJobTimeoutConfig timeoutConfig) {
            this.timeoutConfig = timeoutConfig;
            return this;
        }

        public final void setTimeoutConfig(IoTJobTimeoutConfig.BuilderImpl timeoutConfig) {
            this.timeoutConfig = timeoutConfig != null ? timeoutConfig.build() : null;
        }

        @Override
        public DeploymentIoTJobConfiguration build() {
            return new DeploymentIoTJobConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
