/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrassv2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDeploymentResponse extends GreengrassV2Response implements
        ToCopyableBuilder<GetDeploymentResponse.Builder, GetDeploymentResponse> {
    private static final SdkField<String> TARGET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetArn").getter(getter(GetDeploymentResponse::targetArn)).setter(setter(Builder::targetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetArn").build()).build();

    private static final SdkField<String> REVISION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("revisionId").getter(getter(GetDeploymentResponse::revisionId)).setter(setter(Builder::revisionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revisionId").build()).build();

    private static final SdkField<String> DEPLOYMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deploymentId").getter(getter(GetDeploymentResponse::deploymentId)).setter(setter(Builder::deploymentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentId").build()).build();

    private static final SdkField<String> DEPLOYMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deploymentName").getter(getter(GetDeploymentResponse::deploymentName))
            .setter(setter(Builder::deploymentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentName").build()).build();

    private static final SdkField<String> DEPLOYMENT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deploymentStatus").getter(getter(GetDeploymentResponse::deploymentStatusAsString))
            .setter(setter(Builder::deploymentStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentStatus").build()).build();

    private static final SdkField<String> IOT_JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("iotJobId").getter(getter(GetDeploymentResponse::iotJobId)).setter(setter(Builder::iotJobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iotJobId").build()).build();

    private static final SdkField<String> IOT_JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("iotJobArn").getter(getter(GetDeploymentResponse::iotJobArn)).setter(setter(Builder::iotJobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iotJobArn").build()).build();

    private static final SdkField<Map<String, ComponentDeploymentSpecification>> COMPONENTS_FIELD = SdkField
            .<Map<String, ComponentDeploymentSpecification>> builder(MarshallingType.MAP)
            .memberName("components")
            .getter(getter(GetDeploymentResponse::components))
            .setter(setter(Builder::components))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("components").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<ComponentDeploymentSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(ComponentDeploymentSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<DeploymentPolicies> DEPLOYMENT_POLICIES_FIELD = SdkField
            .<DeploymentPolicies> builder(MarshallingType.SDK_POJO).memberName("deploymentPolicies")
            .getter(getter(GetDeploymentResponse::deploymentPolicies)).setter(setter(Builder::deploymentPolicies))
            .constructor(DeploymentPolicies::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentPolicies").build())
            .build();

    private static final SdkField<DeploymentIoTJobConfiguration> IOT_JOB_CONFIGURATION_FIELD = SdkField
            .<DeploymentIoTJobConfiguration> builder(MarshallingType.SDK_POJO).memberName("iotJobConfiguration")
            .getter(getter(GetDeploymentResponse::iotJobConfiguration)).setter(setter(Builder::iotJobConfiguration))
            .constructor(DeploymentIoTJobConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iotJobConfiguration").build())
            .build();

    private static final SdkField<Instant> CREATION_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTimestamp").getter(getter(GetDeploymentResponse::creationTimestamp))
            .setter(setter(Builder::creationTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTimestamp").build()).build();

    private static final SdkField<Boolean> IS_LATEST_FOR_TARGET_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isLatestForTarget").getter(getter(GetDeploymentResponse::isLatestForTarget))
            .setter(setter(Builder::isLatestForTarget))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isLatestForTarget").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(GetDeploymentResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_ARN_FIELD,
            REVISION_ID_FIELD, DEPLOYMENT_ID_FIELD, DEPLOYMENT_NAME_FIELD, DEPLOYMENT_STATUS_FIELD, IOT_JOB_ID_FIELD,
            IOT_JOB_ARN_FIELD, COMPONENTS_FIELD, DEPLOYMENT_POLICIES_FIELD, IOT_JOB_CONFIGURATION_FIELD,
            CREATION_TIMESTAMP_FIELD, IS_LATEST_FOR_TARGET_FIELD, TAGS_FIELD));

    private final String targetArn;

    private final String revisionId;

    private final String deploymentId;

    private final String deploymentName;

    private final String deploymentStatus;

    private final String iotJobId;

    private final String iotJobArn;

    private final Map<String, ComponentDeploymentSpecification> components;

    private final DeploymentPolicies deploymentPolicies;

    private final DeploymentIoTJobConfiguration iotJobConfiguration;

    private final Instant creationTimestamp;

    private final Boolean isLatestForTarget;

    private final Map<String, String> tags;

    private GetDeploymentResponse(BuilderImpl builder) {
        super(builder);
        this.targetArn = builder.targetArn;
        this.revisionId = builder.revisionId;
        this.deploymentId = builder.deploymentId;
        this.deploymentName = builder.deploymentName;
        this.deploymentStatus = builder.deploymentStatus;
        this.iotJobId = builder.iotJobId;
        this.iotJobArn = builder.iotJobArn;
        this.components = builder.components;
        this.deploymentPolicies = builder.deploymentPolicies;
        this.iotJobConfiguration = builder.iotJobConfiguration;
        this.creationTimestamp = builder.creationTimestamp;
        this.isLatestForTarget = builder.isLatestForTarget;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the target
     * AWS IoT thing or thing group.
     * </p>
     * 
     * @return The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the
     *         target AWS IoT thing or thing group.
     */
    public final String targetArn() {
        return targetArn;
    }

    /**
     * <p>
     * The revision number of the deployment.
     * </p>
     * 
     * @return The revision number of the deployment.
     */
    public final String revisionId() {
        return revisionId;
    }

    /**
     * <p>
     * The ID of the deployment.
     * </p>
     * 
     * @return The ID of the deployment.
     */
    public final String deploymentId() {
        return deploymentId;
    }

    /**
     * <p>
     * The name of the deployment.
     * </p>
     * <p>
     * You can create deployments without names. If you create a deployment without a name, the AWS IoT Greengrass V2
     * console shows the deployment name as <code>&lt;targetType&gt;:&lt;targetName&gt;</code>, where
     * <code>targetType</code> and <code>targetName</code> are the type and name of the deployment target.
     * </p>
     * 
     * @return The name of the deployment.</p>
     *         <p>
     *         You can create deployments without names. If you create a deployment without a name, the AWS IoT
     *         Greengrass V2 console shows the deployment name as <code>&lt;targetType&gt;:&lt;targetName&gt;</code>,
     *         where <code>targetType</code> and <code>targetName</code> are the type and name of the deployment target.
     */
    public final String deploymentName() {
        return deploymentName;
    }

    /**
     * <p>
     * The status of the deployment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deploymentStatus}
     * will return {@link DeploymentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #deploymentStatusAsString}.
     * </p>
     * 
     * @return The status of the deployment.
     * @see DeploymentStatus
     */
    public final DeploymentStatus deploymentStatus() {
        return DeploymentStatus.fromValue(deploymentStatus);
    }

    /**
     * <p>
     * The status of the deployment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deploymentStatus}
     * will return {@link DeploymentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #deploymentStatusAsString}.
     * </p>
     * 
     * @return The status of the deployment.
     * @see DeploymentStatus
     */
    public final String deploymentStatusAsString() {
        return deploymentStatus;
    }

    /**
     * <p>
     * The ID of the AWS IoT job that applies the deployment to target devices.
     * </p>
     * 
     * @return The ID of the AWS IoT job that applies the deployment to target devices.
     */
    public final String iotJobId() {
        return iotJobId;
    }

    /**
     * <p>
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the AWS IoT
     * job that applies the deployment to target devices.
     * </p>
     * 
     * @return The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the
     *         AWS IoT job that applies the deployment to target devices.
     */
    public final String iotJobArn() {
        return iotJobArn;
    }

    /**
     * Returns true if the Components property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasComponents() {
        return components != null && !(components instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The components to deploy. This is a dictionary, where each key is the name of a component, and each key's value
     * is the version and configuration to deploy for that component.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasComponents()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The components to deploy. This is a dictionary, where each key is the name of a component, and each key's
     *         value is the version and configuration to deploy for that component.
     */
    public final Map<String, ComponentDeploymentSpecification> components() {
        return components;
    }

    /**
     * <p>
     * The deployment policies for the deployment. These policies define how the deployment updates components and
     * handles failure.
     * </p>
     * 
     * @return The deployment policies for the deployment. These policies define how the deployment updates components
     *         and handles failure.
     */
    public final DeploymentPolicies deploymentPolicies() {
        return deploymentPolicies;
    }

    /**
     * <p>
     * The job configuration for the deployment configuration. The job configuration specifies the rollout, timeout, and
     * stop configurations for the deployment configuration.
     * </p>
     * 
     * @return The job configuration for the deployment configuration. The job configuration specifies the rollout,
     *         timeout, and stop configurations for the deployment configuration.
     */
    public final DeploymentIoTJobConfiguration iotJobConfiguration() {
        return iotJobConfiguration;
    }

    /**
     * <p>
     * The time at which the deployment was created, expressed in ISO 8601 format.
     * </p>
     * 
     * @return The time at which the deployment was created, expressed in ISO 8601 format.
     */
    public final Instant creationTimestamp() {
        return creationTimestamp;
    }

    /**
     * <p>
     * Whether or not the deployment is the latest revision for its target.
     * </p>
     * 
     * @return Whether or not the deployment is the latest revision for its target.
     */
    public final Boolean isLatestForTarget() {
        return isLatestForTarget;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of key-value pairs that contain metadata for the resource. For more information, see <a
     * href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your resources</a> in the
     * <i>AWS IoT Greengrass V2 Developer Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of key-value pairs that contain metadata for the resource. For more information, see <a
     *         href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your resources</a>
     *         in the <i>AWS IoT Greengrass V2 Developer Guide</i>.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(targetArn());
        hashCode = 31 * hashCode + Objects.hashCode(revisionId());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentName());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(iotJobId());
        hashCode = 31 * hashCode + Objects.hashCode(iotJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasComponents() ? components() : null);
        hashCode = 31 * hashCode + Objects.hashCode(deploymentPolicies());
        hashCode = 31 * hashCode + Objects.hashCode(iotJobConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(creationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(isLatestForTarget());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDeploymentResponse)) {
            return false;
        }
        GetDeploymentResponse other = (GetDeploymentResponse) obj;
        return Objects.equals(targetArn(), other.targetArn()) && Objects.equals(revisionId(), other.revisionId())
                && Objects.equals(deploymentId(), other.deploymentId())
                && Objects.equals(deploymentName(), other.deploymentName())
                && Objects.equals(deploymentStatusAsString(), other.deploymentStatusAsString())
                && Objects.equals(iotJobId(), other.iotJobId()) && Objects.equals(iotJobArn(), other.iotJobArn())
                && hasComponents() == other.hasComponents() && Objects.equals(components(), other.components())
                && Objects.equals(deploymentPolicies(), other.deploymentPolicies())
                && Objects.equals(iotJobConfiguration(), other.iotJobConfiguration())
                && Objects.equals(creationTimestamp(), other.creationTimestamp())
                && Objects.equals(isLatestForTarget(), other.isLatestForTarget()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDeploymentResponse").add("TargetArn", targetArn()).add("RevisionId", revisionId())
                .add("DeploymentId", deploymentId()).add("DeploymentName", deploymentName())
                .add("DeploymentStatus", deploymentStatusAsString()).add("IotJobId", iotJobId()).add("IotJobArn", iotJobArn())
                .add("Components", hasComponents() ? components() : null).add("DeploymentPolicies", deploymentPolicies())
                .add("IotJobConfiguration", iotJobConfiguration()).add("CreationTimestamp", creationTimestamp())
                .add("IsLatestForTarget", isLatestForTarget()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "targetArn":
            return Optional.ofNullable(clazz.cast(targetArn()));
        case "revisionId":
            return Optional.ofNullable(clazz.cast(revisionId()));
        case "deploymentId":
            return Optional.ofNullable(clazz.cast(deploymentId()));
        case "deploymentName":
            return Optional.ofNullable(clazz.cast(deploymentName()));
        case "deploymentStatus":
            return Optional.ofNullable(clazz.cast(deploymentStatusAsString()));
        case "iotJobId":
            return Optional.ofNullable(clazz.cast(iotJobId()));
        case "iotJobArn":
            return Optional.ofNullable(clazz.cast(iotJobArn()));
        case "components":
            return Optional.ofNullable(clazz.cast(components()));
        case "deploymentPolicies":
            return Optional.ofNullable(clazz.cast(deploymentPolicies()));
        case "iotJobConfiguration":
            return Optional.ofNullable(clazz.cast(iotJobConfiguration()));
        case "creationTimestamp":
            return Optional.ofNullable(clazz.cast(creationTimestamp()));
        case "isLatestForTarget":
            return Optional.ofNullable(clazz.cast(isLatestForTarget()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDeploymentResponse, T> g) {
        return obj -> g.apply((GetDeploymentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GreengrassV2Response.Builder, SdkPojo, CopyableBuilder<Builder, GetDeploymentResponse> {
        /**
         * <p>
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the
         * target AWS IoT thing or thing group.
         * </p>
         * 
         * @param targetArn
         *        The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of
         *        the target AWS IoT thing or thing group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetArn(String targetArn);

        /**
         * <p>
         * The revision number of the deployment.
         * </p>
         * 
         * @param revisionId
         *        The revision number of the deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisionId(String revisionId);

        /**
         * <p>
         * The ID of the deployment.
         * </p>
         * 
         * @param deploymentId
         *        The ID of the deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentId(String deploymentId);

        /**
         * <p>
         * The name of the deployment.
         * </p>
         * <p>
         * You can create deployments without names. If you create a deployment without a name, the AWS IoT Greengrass
         * V2 console shows the deployment name as <code>&lt;targetType&gt;:&lt;targetName&gt;</code>, where
         * <code>targetType</code> and <code>targetName</code> are the type and name of the deployment target.
         * </p>
         * 
         * @param deploymentName
         *        The name of the deployment.</p>
         *        <p>
         *        You can create deployments without names. If you create a deployment without a name, the AWS IoT
         *        Greengrass V2 console shows the deployment name as <code>&lt;targetType&gt;:&lt;targetName&gt;</code>,
         *        where <code>targetType</code> and <code>targetName</code> are the type and name of the deployment
         *        target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentName(String deploymentName);

        /**
         * <p>
         * The status of the deployment.
         * </p>
         * 
         * @param deploymentStatus
         *        The status of the deployment.
         * @see DeploymentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentStatus
         */
        Builder deploymentStatus(String deploymentStatus);

        /**
         * <p>
         * The status of the deployment.
         * </p>
         * 
         * @param deploymentStatus
         *        The status of the deployment.
         * @see DeploymentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentStatus
         */
        Builder deploymentStatus(DeploymentStatus deploymentStatus);

        /**
         * <p>
         * The ID of the AWS IoT job that applies the deployment to target devices.
         * </p>
         * 
         * @param iotJobId
         *        The ID of the AWS IoT job that applies the deployment to target devices.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iotJobId(String iotJobId);

        /**
         * <p>
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the AWS
         * IoT job that applies the deployment to target devices.
         * </p>
         * 
         * @param iotJobArn
         *        The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of
         *        the AWS IoT job that applies the deployment to target devices.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iotJobArn(String iotJobArn);

        /**
         * <p>
         * The components to deploy. This is a dictionary, where each key is the name of a component, and each key's
         * value is the version and configuration to deploy for that component.
         * </p>
         * 
         * @param components
         *        The components to deploy. This is a dictionary, where each key is the name of a component, and each
         *        key's value is the version and configuration to deploy for that component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder components(Map<String, ComponentDeploymentSpecification> components);

        /**
         * <p>
         * The deployment policies for the deployment. These policies define how the deployment updates components and
         * handles failure.
         * </p>
         * 
         * @param deploymentPolicies
         *        The deployment policies for the deployment. These policies define how the deployment updates
         *        components and handles failure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentPolicies(DeploymentPolicies deploymentPolicies);

        /**
         * <p>
         * The deployment policies for the deployment. These policies define how the deployment updates components and
         * handles failure.
         * </p>
         * This is a convenience that creates an instance of the {@link DeploymentPolicies.Builder} avoiding the need to
         * create one manually via {@link DeploymentPolicies#builder()}.
         *
         * When the {@link Consumer} completes, {@link DeploymentPolicies.Builder#build()} is called immediately and its
         * result is passed to {@link #deploymentPolicies(DeploymentPolicies)}.
         * 
         * @param deploymentPolicies
         *        a consumer that will call methods on {@link DeploymentPolicies.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deploymentPolicies(DeploymentPolicies)
         */
        default Builder deploymentPolicies(Consumer<DeploymentPolicies.Builder> deploymentPolicies) {
            return deploymentPolicies(DeploymentPolicies.builder().applyMutation(deploymentPolicies).build());
        }

        /**
         * <p>
         * The job configuration for the deployment configuration. The job configuration specifies the rollout, timeout,
         * and stop configurations for the deployment configuration.
         * </p>
         * 
         * @param iotJobConfiguration
         *        The job configuration for the deployment configuration. The job configuration specifies the rollout,
         *        timeout, and stop configurations for the deployment configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iotJobConfiguration(DeploymentIoTJobConfiguration iotJobConfiguration);

        /**
         * <p>
         * The job configuration for the deployment configuration. The job configuration specifies the rollout, timeout,
         * and stop configurations for the deployment configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link DeploymentIoTJobConfiguration.Builder} avoiding
         * the need to create one manually via {@link DeploymentIoTJobConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link DeploymentIoTJobConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #iotJobConfiguration(DeploymentIoTJobConfiguration)}.
         * 
         * @param iotJobConfiguration
         *        a consumer that will call methods on {@link DeploymentIoTJobConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #iotJobConfiguration(DeploymentIoTJobConfiguration)
         */
        default Builder iotJobConfiguration(Consumer<DeploymentIoTJobConfiguration.Builder> iotJobConfiguration) {
            return iotJobConfiguration(DeploymentIoTJobConfiguration.builder().applyMutation(iotJobConfiguration).build());
        }

        /**
         * <p>
         * The time at which the deployment was created, expressed in ISO 8601 format.
         * </p>
         * 
         * @param creationTimestamp
         *        The time at which the deployment was created, expressed in ISO 8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimestamp(Instant creationTimestamp);

        /**
         * <p>
         * Whether or not the deployment is the latest revision for its target.
         * </p>
         * 
         * @param isLatestForTarget
         *        Whether or not the deployment is the latest revision for its target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isLatestForTarget(Boolean isLatestForTarget);

        /**
         * <p>
         * A list of key-value pairs that contain metadata for the resource. For more information, see <a
         * href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your resources</a> in
         * the <i>AWS IoT Greengrass V2 Developer Guide</i>.
         * </p>
         * 
         * @param tags
         *        A list of key-value pairs that contain metadata for the resource. For more information, see <a
         *        href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your
         *        resources</a> in the <i>AWS IoT Greengrass V2 Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends GreengrassV2Response.BuilderImpl implements Builder {
        private String targetArn;

        private String revisionId;

        private String deploymentId;

        private String deploymentName;

        private String deploymentStatus;

        private String iotJobId;

        private String iotJobArn;

        private Map<String, ComponentDeploymentSpecification> components = DefaultSdkAutoConstructMap.getInstance();

        private DeploymentPolicies deploymentPolicies;

        private DeploymentIoTJobConfiguration iotJobConfiguration;

        private Instant creationTimestamp;

        private Boolean isLatestForTarget;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetDeploymentResponse model) {
            super(model);
            targetArn(model.targetArn);
            revisionId(model.revisionId);
            deploymentId(model.deploymentId);
            deploymentName(model.deploymentName);
            deploymentStatus(model.deploymentStatus);
            iotJobId(model.iotJobId);
            iotJobArn(model.iotJobArn);
            components(model.components);
            deploymentPolicies(model.deploymentPolicies);
            iotJobConfiguration(model.iotJobConfiguration);
            creationTimestamp(model.creationTimestamp);
            isLatestForTarget(model.isLatestForTarget);
            tags(model.tags);
        }

        public final String getTargetArn() {
            return targetArn;
        }

        @Override
        public final Builder targetArn(String targetArn) {
            this.targetArn = targetArn;
            return this;
        }

        public final void setTargetArn(String targetArn) {
            this.targetArn = targetArn;
        }

        public final String getRevisionId() {
            return revisionId;
        }

        @Override
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        public final String getDeploymentId() {
            return deploymentId;
        }

        @Override
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        public final String getDeploymentName() {
            return deploymentName;
        }

        @Override
        public final Builder deploymentName(String deploymentName) {
            this.deploymentName = deploymentName;
            return this;
        }

        public final void setDeploymentName(String deploymentName) {
            this.deploymentName = deploymentName;
        }

        public final String getDeploymentStatus() {
            return deploymentStatus;
        }

        @Override
        public final Builder deploymentStatus(String deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
            return this;
        }

        @Override
        public final Builder deploymentStatus(DeploymentStatus deploymentStatus) {
            this.deploymentStatus(deploymentStatus == null ? null : deploymentStatus.toString());
            return this;
        }

        public final void setDeploymentStatus(String deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
        }

        public final String getIotJobId() {
            return iotJobId;
        }

        @Override
        public final Builder iotJobId(String iotJobId) {
            this.iotJobId = iotJobId;
            return this;
        }

        public final void setIotJobId(String iotJobId) {
            this.iotJobId = iotJobId;
        }

        public final String getIotJobArn() {
            return iotJobArn;
        }

        @Override
        public final Builder iotJobArn(String iotJobArn) {
            this.iotJobArn = iotJobArn;
            return this;
        }

        public final void setIotJobArn(String iotJobArn) {
            this.iotJobArn = iotJobArn;
        }

        public final Map<String, ComponentDeploymentSpecification.Builder> getComponents() {
            Map<String, ComponentDeploymentSpecification.Builder> result = ComponentDeploymentSpecificationsCopier
                    .copyToBuilder(this.components);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder components(Map<String, ComponentDeploymentSpecification> components) {
            this.components = ComponentDeploymentSpecificationsCopier.copy(components);
            return this;
        }

        public final void setComponents(Map<String, ComponentDeploymentSpecification.BuilderImpl> components) {
            this.components = ComponentDeploymentSpecificationsCopier.copyFromBuilder(components);
        }

        public final DeploymentPolicies.Builder getDeploymentPolicies() {
            return deploymentPolicies != null ? deploymentPolicies.toBuilder() : null;
        }

        @Override
        public final Builder deploymentPolicies(DeploymentPolicies deploymentPolicies) {
            this.deploymentPolicies = deploymentPolicies;
            return this;
        }

        public final void setDeploymentPolicies(DeploymentPolicies.BuilderImpl deploymentPolicies) {
            this.deploymentPolicies = deploymentPolicies != null ? deploymentPolicies.build() : null;
        }

        public final DeploymentIoTJobConfiguration.Builder getIotJobConfiguration() {
            return iotJobConfiguration != null ? iotJobConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder iotJobConfiguration(DeploymentIoTJobConfiguration iotJobConfiguration) {
            this.iotJobConfiguration = iotJobConfiguration;
            return this;
        }

        public final void setIotJobConfiguration(DeploymentIoTJobConfiguration.BuilderImpl iotJobConfiguration) {
            this.iotJobConfiguration = iotJobConfiguration != null ? iotJobConfiguration.build() : null;
        }

        public final Instant getCreationTimestamp() {
            return creationTimestamp;
        }

        @Override
        public final Builder creationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public final void setCreationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
        }

        public final Boolean getIsLatestForTarget() {
            return isLatestForTarget;
        }

        @Override
        public final Builder isLatestForTarget(Boolean isLatestForTarget) {
            this.isLatestForTarget = isLatestForTarget;
            return this;
        }

        public final void setIsLatestForTarget(Boolean isLatestForTarget) {
            this.isLatestForTarget = isLatestForTarget;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public GetDeploymentResponse build() {
            return new GetDeploymentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
