/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrassv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains criteria that define when and how to cancel a job.
 * </p>
 * <p>
 * The deployment stops if the following conditions are true:
 * </p>
 * <ol>
 * <li>
 * <p>
 * The number of things that receive the deployment exceeds the <code>minNumberOfExecutedThings</code>.
 * </p>
 * </li>
 * <li>
 * <p>
 * The percentage of failures with type <code>failureType</code> exceeds the <code>thresholdPercentage</code>.
 * </p>
 * </li>
 * </ol>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IoTJobAbortCriteria implements SdkPojo, Serializable,
        ToCopyableBuilder<IoTJobAbortCriteria.Builder, IoTJobAbortCriteria> {
    private static final SdkField<String> FAILURE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureType").getter(getter(IoTJobAbortCriteria::failureTypeAsString))
            .setter(setter(Builder::failureType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureType").build()).build();

    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("action")
            .getter(getter(IoTJobAbortCriteria::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()).build();

    private static final SdkField<Double> THRESHOLD_PERCENTAGE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("thresholdPercentage").getter(getter(IoTJobAbortCriteria::thresholdPercentage))
            .setter(setter(Builder::thresholdPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thresholdPercentage").build())
            .build();

    private static final SdkField<Integer> MIN_NUMBER_OF_EXECUTED_THINGS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("minNumberOfExecutedThings")
            .getter(getter(IoTJobAbortCriteria::minNumberOfExecutedThings)).setter(setter(Builder::minNumberOfExecutedThings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minNumberOfExecutedThings").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILURE_TYPE_FIELD,
            ACTION_FIELD, THRESHOLD_PERCENTAGE_FIELD, MIN_NUMBER_OF_EXECUTED_THINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String failureType;

    private final String action;

    private final Double thresholdPercentage;

    private final Integer minNumberOfExecutedThings;

    private IoTJobAbortCriteria(BuilderImpl builder) {
        this.failureType = builder.failureType;
        this.action = builder.action;
        this.thresholdPercentage = builder.thresholdPercentage;
        this.minNumberOfExecutedThings = builder.minNumberOfExecutedThings;
    }

    /**
     * <p>
     * The type of job deployment failure that can cancel a job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failureType} will
     * return {@link IoTJobExecutionFailureType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #failureTypeAsString}.
     * </p>
     * 
     * @return The type of job deployment failure that can cancel a job.
     * @see IoTJobExecutionFailureType
     */
    public final IoTJobExecutionFailureType failureType() {
        return IoTJobExecutionFailureType.fromValue(failureType);
    }

    /**
     * <p>
     * The type of job deployment failure that can cancel a job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failureType} will
     * return {@link IoTJobExecutionFailureType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #failureTypeAsString}.
     * </p>
     * 
     * @return The type of job deployment failure that can cancel a job.
     * @see IoTJobExecutionFailureType
     */
    public final String failureTypeAsString() {
        return failureType;
    }

    /**
     * <p>
     * The action to perform when the criteria are met.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link IoTJobAbortAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return The action to perform when the criteria are met.
     * @see IoTJobAbortAction
     */
    public final IoTJobAbortAction action() {
        return IoTJobAbortAction.fromValue(action);
    }

    /**
     * <p>
     * The action to perform when the criteria are met.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link IoTJobAbortAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return The action to perform when the criteria are met.
     * @see IoTJobAbortAction
     */
    public final String actionAsString() {
        return action;
    }

    /**
     * <p>
     * The minimum percentage of <code>failureType</code> failures that occur before the job can cancel.
     * </p>
     * <p>
     * This parameter supports up to two digits after the decimal (for example, you can specify <code>10.9</code> or
     * <code>10.99</code>, but not <code>10.999</code>).
     * </p>
     * 
     * @return The minimum percentage of <code>failureType</code> failures that occur before the job can cancel.</p>
     *         <p>
     *         This parameter supports up to two digits after the decimal (for example, you can specify
     *         <code>10.9</code> or <code>10.99</code>, but not <code>10.999</code>).
     */
    public final Double thresholdPercentage() {
        return thresholdPercentage;
    }

    /**
     * <p>
     * The minimum number of things that receive the configuration before the job can cancel.
     * </p>
     * 
     * @return The minimum number of things that receive the configuration before the job can cancel.
     */
    public final Integer minNumberOfExecutedThings() {
        return minNumberOfExecutedThings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(failureTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(thresholdPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(minNumberOfExecutedThings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IoTJobAbortCriteria)) {
            return false;
        }
        IoTJobAbortCriteria other = (IoTJobAbortCriteria) obj;
        return Objects.equals(failureTypeAsString(), other.failureTypeAsString())
                && Objects.equals(actionAsString(), other.actionAsString())
                && Objects.equals(thresholdPercentage(), other.thresholdPercentage())
                && Objects.equals(minNumberOfExecutedThings(), other.minNumberOfExecutedThings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IoTJobAbortCriteria").add("FailureType", failureTypeAsString()).add("Action", actionAsString())
                .add("ThresholdPercentage", thresholdPercentage()).add("MinNumberOfExecutedThings", minNumberOfExecutedThings())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "failureType":
            return Optional.ofNullable(clazz.cast(failureTypeAsString()));
        case "action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        case "thresholdPercentage":
            return Optional.ofNullable(clazz.cast(thresholdPercentage()));
        case "minNumberOfExecutedThings":
            return Optional.ofNullable(clazz.cast(minNumberOfExecutedThings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IoTJobAbortCriteria, T> g) {
        return obj -> g.apply((IoTJobAbortCriteria) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IoTJobAbortCriteria> {
        /**
         * <p>
         * The type of job deployment failure that can cancel a job.
         * </p>
         * 
         * @param failureType
         *        The type of job deployment failure that can cancel a job.
         * @see IoTJobExecutionFailureType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IoTJobExecutionFailureType
         */
        Builder failureType(String failureType);

        /**
         * <p>
         * The type of job deployment failure that can cancel a job.
         * </p>
         * 
         * @param failureType
         *        The type of job deployment failure that can cancel a job.
         * @see IoTJobExecutionFailureType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IoTJobExecutionFailureType
         */
        Builder failureType(IoTJobExecutionFailureType failureType);

        /**
         * <p>
         * The action to perform when the criteria are met.
         * </p>
         * 
         * @param action
         *        The action to perform when the criteria are met.
         * @see IoTJobAbortAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IoTJobAbortAction
         */
        Builder action(String action);

        /**
         * <p>
         * The action to perform when the criteria are met.
         * </p>
         * 
         * @param action
         *        The action to perform when the criteria are met.
         * @see IoTJobAbortAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IoTJobAbortAction
         */
        Builder action(IoTJobAbortAction action);

        /**
         * <p>
         * The minimum percentage of <code>failureType</code> failures that occur before the job can cancel.
         * </p>
         * <p>
         * This parameter supports up to two digits after the decimal (for example, you can specify <code>10.9</code> or
         * <code>10.99</code>, but not <code>10.999</code>).
         * </p>
         * 
         * @param thresholdPercentage
         *        The minimum percentage of <code>failureType</code> failures that occur before the job can cancel.</p>
         *        <p>
         *        This parameter supports up to two digits after the decimal (for example, you can specify
         *        <code>10.9</code> or <code>10.99</code>, but not <code>10.999</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thresholdPercentage(Double thresholdPercentage);

        /**
         * <p>
         * The minimum number of things that receive the configuration before the job can cancel.
         * </p>
         * 
         * @param minNumberOfExecutedThings
         *        The minimum number of things that receive the configuration before the job can cancel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minNumberOfExecutedThings(Integer minNumberOfExecutedThings);
    }

    static final class BuilderImpl implements Builder {
        private String failureType;

        private String action;

        private Double thresholdPercentage;

        private Integer minNumberOfExecutedThings;

        private BuilderImpl() {
        }

        private BuilderImpl(IoTJobAbortCriteria model) {
            failureType(model.failureType);
            action(model.action);
            thresholdPercentage(model.thresholdPercentage);
            minNumberOfExecutedThings(model.minNumberOfExecutedThings);
        }

        public final String getFailureType() {
            return failureType;
        }

        @Override
        public final Builder failureType(String failureType) {
            this.failureType = failureType;
            return this;
        }

        @Override
        public final Builder failureType(IoTJobExecutionFailureType failureType) {
            this.failureType(failureType == null ? null : failureType.toString());
            return this;
        }

        public final void setFailureType(String failureType) {
            this.failureType = failureType;
        }

        public final String getAction() {
            return action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(IoTJobAbortAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final Double getThresholdPercentage() {
            return thresholdPercentage;
        }

        @Override
        public final Builder thresholdPercentage(Double thresholdPercentage) {
            this.thresholdPercentage = thresholdPercentage;
            return this;
        }

        public final void setThresholdPercentage(Double thresholdPercentage) {
            this.thresholdPercentage = thresholdPercentage;
        }

        public final Integer getMinNumberOfExecutedThings() {
            return minNumberOfExecutedThings;
        }

        @Override
        public final Builder minNumberOfExecutedThings(Integer minNumberOfExecutedThings) {
            this.minNumberOfExecutedThings = minNumberOfExecutedThings;
            return this;
        }

        public final void setMinNumberOfExecutedThings(Integer minNumberOfExecutedThings) {
            this.minNumberOfExecutedThings = minNumberOfExecutedThings;
        }

        @Override
        public IoTJobAbortCriteria build() {
            return new IoTJobAbortCriteria(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
