/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrassv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the timeout configuration for a job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IoTJobTimeoutConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<IoTJobTimeoutConfig.Builder, IoTJobTimeoutConfig> {
    private static final SdkField<Long> IN_PROGRESS_TIMEOUT_IN_MINUTES_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("inProgressTimeoutInMinutes")
            .getter(getter(IoTJobTimeoutConfig::inProgressTimeoutInMinutes))
            .setter(setter(Builder::inProgressTimeoutInMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inProgressTimeoutInMinutes").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(IN_PROGRESS_TIMEOUT_IN_MINUTES_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long inProgressTimeoutInMinutes;

    private IoTJobTimeoutConfig(BuilderImpl builder) {
        this.inProgressTimeoutInMinutes = builder.inProgressTimeoutInMinutes;
    }

    /**
     * <p>
     * The amount of time, in minutes, that devices have to complete the job. The timer starts when the job status is
     * set to <code>IN_PROGRESS</code>. If the job status doesn't change to a terminal state before the time expires,
     * then the job status is set to <code>TIMED_OUT</code>.
     * </p>
     * <p>
     * The timeout interval must be between 1 minute and 7 days (10080 minutes).
     * </p>
     * 
     * @return The amount of time, in minutes, that devices have to complete the job. The timer starts when the job
     *         status is set to <code>IN_PROGRESS</code>. If the job status doesn't change to a terminal state before
     *         the time expires, then the job status is set to <code>TIMED_OUT</code>.</p>
     *         <p>
     *         The timeout interval must be between 1 minute and 7 days (10080 minutes).
     */
    public final Long inProgressTimeoutInMinutes() {
        return inProgressTimeoutInMinutes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(inProgressTimeoutInMinutes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IoTJobTimeoutConfig)) {
            return false;
        }
        IoTJobTimeoutConfig other = (IoTJobTimeoutConfig) obj;
        return Objects.equals(inProgressTimeoutInMinutes(), other.inProgressTimeoutInMinutes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IoTJobTimeoutConfig").add("InProgressTimeoutInMinutes", inProgressTimeoutInMinutes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "inProgressTimeoutInMinutes":
            return Optional.ofNullable(clazz.cast(inProgressTimeoutInMinutes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IoTJobTimeoutConfig, T> g) {
        return obj -> g.apply((IoTJobTimeoutConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IoTJobTimeoutConfig> {
        /**
         * <p>
         * The amount of time, in minutes, that devices have to complete the job. The timer starts when the job status
         * is set to <code>IN_PROGRESS</code>. If the job status doesn't change to a terminal state before the time
         * expires, then the job status is set to <code>TIMED_OUT</code>.
         * </p>
         * <p>
         * The timeout interval must be between 1 minute and 7 days (10080 minutes).
         * </p>
         * 
         * @param inProgressTimeoutInMinutes
         *        The amount of time, in minutes, that devices have to complete the job. The timer starts when the job
         *        status is set to <code>IN_PROGRESS</code>. If the job status doesn't change to a terminal state before
         *        the time expires, then the job status is set to <code>TIMED_OUT</code>.</p>
         *        <p>
         *        The timeout interval must be between 1 minute and 7 days (10080 minutes).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inProgressTimeoutInMinutes(Long inProgressTimeoutInMinutes);
    }

    static final class BuilderImpl implements Builder {
        private Long inProgressTimeoutInMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(IoTJobTimeoutConfig model) {
            inProgressTimeoutInMinutes(model.inProgressTimeoutInMinutes);
        }

        public final Long getInProgressTimeoutInMinutes() {
            return inProgressTimeoutInMinutes;
        }

        @Override
        public final Builder inProgressTimeoutInMinutes(Long inProgressTimeoutInMinutes) {
            this.inProgressTimeoutInMinutes = inProgressTimeoutInMinutes;
            return this;
        }

        public final void setInProgressTimeoutInMinutes(Long inProgressTimeoutInMinutes) {
            this.inProgressTimeoutInMinutes = inProgressTimeoutInMinutes;
        }

        @Override
        public IoTJobTimeoutConfig build() {
            return new IoTJobTimeoutConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
