/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrassv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListComponentVersionsResponse extends GreengrassV2Response implements
        ToCopyableBuilder<ListComponentVersionsResponse.Builder, ListComponentVersionsResponse> {
    private static final SdkField<List<ComponentVersionListItem>> COMPONENT_VERSIONS_FIELD = SdkField
            .<List<ComponentVersionListItem>> builder(MarshallingType.LIST)
            .memberName("componentVersions")
            .getter(getter(ListComponentVersionsResponse::componentVersions))
            .setter(setter(Builder::componentVersions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentVersions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ComponentVersionListItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(ComponentVersionListItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListComponentVersionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPONENT_VERSIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ComponentVersionListItem> componentVersions;

    private final String nextToken;

    private ListComponentVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.componentVersions = builder.componentVersions;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the ComponentVersions property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasComponentVersions() {
        return componentVersions != null && !(componentVersions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of versions that exist for the component.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasComponentVersions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of versions that exist for the component.
     */
    public final List<ComponentVersionListItem> componentVersions() {
        return componentVersions;
    }

    /**
     * <p>
     * The token for the next set of results, or null if there are no additional results.
     * </p>
     * 
     * @return The token for the next set of results, or null if there are no additional results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasComponentVersions() ? componentVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListComponentVersionsResponse)) {
            return false;
        }
        ListComponentVersionsResponse other = (ListComponentVersionsResponse) obj;
        return hasComponentVersions() == other.hasComponentVersions()
                && Objects.equals(componentVersions(), other.componentVersions())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListComponentVersionsResponse")
                .add("ComponentVersions", hasComponentVersions() ? componentVersions() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "componentVersions":
            return Optional.ofNullable(clazz.cast(componentVersions()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListComponentVersionsResponse, T> g) {
        return obj -> g.apply((ListComponentVersionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GreengrassV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, ListComponentVersionsResponse> {
        /**
         * <p>
         * A list of versions that exist for the component.
         * </p>
         * 
         * @param componentVersions
         *        A list of versions that exist for the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentVersions(Collection<ComponentVersionListItem> componentVersions);

        /**
         * <p>
         * A list of versions that exist for the component.
         * </p>
         * 
         * @param componentVersions
         *        A list of versions that exist for the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentVersions(ComponentVersionListItem... componentVersions);

        /**
         * <p>
         * A list of versions that exist for the component.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ComponentVersionListItem>.Builder} avoiding
         * the need to create one manually via {@link List<ComponentVersionListItem>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ComponentVersionListItem>.Builder#build()} is called
         * immediately and its result is passed to {@link #componentVersions(List<ComponentVersionListItem>)}.
         * 
         * @param componentVersions
         *        a consumer that will call methods on {@link List<ComponentVersionListItem>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #componentVersions(List<ComponentVersionListItem>)
         */
        Builder componentVersions(Consumer<ComponentVersionListItem.Builder>... componentVersions);

        /**
         * <p>
         * The token for the next set of results, or null if there are no additional results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results, or null if there are no additional results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends GreengrassV2Response.BuilderImpl implements Builder {
        private List<ComponentVersionListItem> componentVersions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListComponentVersionsResponse model) {
            super(model);
            componentVersions(model.componentVersions);
            nextToken(model.nextToken);
        }

        public final List<ComponentVersionListItem.Builder> getComponentVersions() {
            List<ComponentVersionListItem.Builder> result = ComponentVersionListCopier.copyToBuilder(this.componentVersions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder componentVersions(Collection<ComponentVersionListItem> componentVersions) {
            this.componentVersions = ComponentVersionListCopier.copy(componentVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder componentVersions(ComponentVersionListItem... componentVersions) {
            componentVersions(Arrays.asList(componentVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder componentVersions(Consumer<ComponentVersionListItem.Builder>... componentVersions) {
            componentVersions(Stream.of(componentVersions).map(c -> ComponentVersionListItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setComponentVersions(Collection<ComponentVersionListItem.BuilderImpl> componentVersions) {
            this.componentVersions = ComponentVersionListCopier.copyFromBuilder(componentVersions);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListComponentVersionsResponse build() {
            return new ListComponentVersionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
