/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrassv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListInstalledComponentsResponse extends GreengrassV2Response implements
        ToCopyableBuilder<ListInstalledComponentsResponse.Builder, ListInstalledComponentsResponse> {
    private static final SdkField<List<InstalledComponent>> INSTALLED_COMPONENTS_FIELD = SdkField
            .<List<InstalledComponent>> builder(MarshallingType.LIST)
            .memberName("installedComponents")
            .getter(getter(ListInstalledComponentsResponse::installedComponents))
            .setter(setter(Builder::installedComponents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("installedComponents").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InstalledComponent> builder(MarshallingType.SDK_POJO)
                                            .constructor(InstalledComponent::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListInstalledComponentsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTALLED_COMPONENTS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<InstalledComponent> installedComponents;

    private final String nextToken;

    private ListInstalledComponentsResponse(BuilderImpl builder) {
        super(builder);
        this.installedComponents = builder.installedComponents;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the InstalledComponents property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasInstalledComponents() {
        return installedComponents != null && !(installedComponents instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list that summarizes each component on the core device.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInstalledComponents()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list that summarizes each component on the core device.
     */
    public final List<InstalledComponent> installedComponents() {
        return installedComponents;
    }

    /**
     * <p>
     * The token for the next set of results, or null if there are no additional results.
     * </p>
     * 
     * @return The token for the next set of results, or null if there are no additional results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasInstalledComponents() ? installedComponents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInstalledComponentsResponse)) {
            return false;
        }
        ListInstalledComponentsResponse other = (ListInstalledComponentsResponse) obj;
        return hasInstalledComponents() == other.hasInstalledComponents()
                && Objects.equals(installedComponents(), other.installedComponents())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListInstalledComponentsResponse")
                .add("InstalledComponents", hasInstalledComponents() ? installedComponents() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "installedComponents":
            return Optional.ofNullable(clazz.cast(installedComponents()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListInstalledComponentsResponse, T> g) {
        return obj -> g.apply((ListInstalledComponentsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GreengrassV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, ListInstalledComponentsResponse> {
        /**
         * <p>
         * A list that summarizes each component on the core device.
         * </p>
         * 
         * @param installedComponents
         *        A list that summarizes each component on the core device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder installedComponents(Collection<InstalledComponent> installedComponents);

        /**
         * <p>
         * A list that summarizes each component on the core device.
         * </p>
         * 
         * @param installedComponents
         *        A list that summarizes each component on the core device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder installedComponents(InstalledComponent... installedComponents);

        /**
         * <p>
         * A list that summarizes each component on the core device.
         * </p>
         * This is a convenience that creates an instance of the {@link List<InstalledComponent>.Builder} avoiding the
         * need to create one manually via {@link List<InstalledComponent>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InstalledComponent>.Builder#build()} is called immediately
         * and its result is passed to {@link #installedComponents(List<InstalledComponent>)}.
         * 
         * @param installedComponents
         *        a consumer that will call methods on {@link List<InstalledComponent>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #installedComponents(List<InstalledComponent>)
         */
        Builder installedComponents(Consumer<InstalledComponent.Builder>... installedComponents);

        /**
         * <p>
         * The token for the next set of results, or null if there are no additional results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results, or null if there are no additional results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends GreengrassV2Response.BuilderImpl implements Builder {
        private List<InstalledComponent> installedComponents = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInstalledComponentsResponse model) {
            super(model);
            installedComponents(model.installedComponents);
            nextToken(model.nextToken);
        }

        public final List<InstalledComponent.Builder> getInstalledComponents() {
            List<InstalledComponent.Builder> result = InstalledComponentListCopier.copyToBuilder(this.installedComponents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder installedComponents(Collection<InstalledComponent> installedComponents) {
            this.installedComponents = InstalledComponentListCopier.copy(installedComponents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder installedComponents(InstalledComponent... installedComponents) {
            installedComponents(Arrays.asList(installedComponents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder installedComponents(Consumer<InstalledComponent.Builder>... installedComponents) {
            installedComponents(Stream.of(installedComponents).map(c -> InstalledComponent.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setInstalledComponents(Collection<InstalledComponent.BuilderImpl> installedComponents) {
            this.installedComponents = InstalledComponentListCopier.copyFromBuilder(installedComponents);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListInstalledComponentsResponse build() {
            return new ListInstalledComponentsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
