/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrassv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResolveComponentCandidatesRequest extends GreengrassV2Request implements
        ToCopyableBuilder<ResolveComponentCandidatesRequest.Builder, ResolveComponentCandidatesRequest> {
    private static final SdkField<ComponentPlatform> PLATFORM_FIELD = SdkField
            .<ComponentPlatform> builder(MarshallingType.SDK_POJO).memberName("platform")
            .getter(getter(ResolveComponentCandidatesRequest::platform)).setter(setter(Builder::platform))
            .constructor(ComponentPlatform::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platform").build()).build();

    private static final SdkField<List<ComponentCandidate>> COMPONENT_CANDIDATES_FIELD = SdkField
            .<List<ComponentCandidate>> builder(MarshallingType.LIST)
            .memberName("componentCandidates")
            .getter(getter(ResolveComponentCandidatesRequest::componentCandidates))
            .setter(setter(Builder::componentCandidates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentCandidates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ComponentCandidate> builder(MarshallingType.SDK_POJO)
                                            .constructor(ComponentCandidate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLATFORM_FIELD,
            COMPONENT_CANDIDATES_FIELD));

    private final ComponentPlatform platform;

    private final List<ComponentCandidate> componentCandidates;

    private ResolveComponentCandidatesRequest(BuilderImpl builder) {
        super(builder);
        this.platform = builder.platform;
        this.componentCandidates = builder.componentCandidates;
    }

    /**
     * <p>
     * The platform to use to resolve compatible components.
     * </p>
     * 
     * @return The platform to use to resolve compatible components.
     */
    public final ComponentPlatform platform() {
        return platform;
    }

    /**
     * Returns true if the ComponentCandidates property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasComponentCandidates() {
        return componentCandidates != null && !(componentCandidates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of components to resolve.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasComponentCandidates()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of components to resolve.
     */
    public final List<ComponentCandidate> componentCandidates() {
        return componentCandidates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(platform());
        hashCode = 31 * hashCode + Objects.hashCode(hasComponentCandidates() ? componentCandidates() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResolveComponentCandidatesRequest)) {
            return false;
        }
        ResolveComponentCandidatesRequest other = (ResolveComponentCandidatesRequest) obj;
        return Objects.equals(platform(), other.platform()) && hasComponentCandidates() == other.hasComponentCandidates()
                && Objects.equals(componentCandidates(), other.componentCandidates());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResolveComponentCandidatesRequest").add("Platform", platform())
                .add("ComponentCandidates", hasComponentCandidates() ? componentCandidates() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "platform":
            return Optional.ofNullable(clazz.cast(platform()));
        case "componentCandidates":
            return Optional.ofNullable(clazz.cast(componentCandidates()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResolveComponentCandidatesRequest, T> g) {
        return obj -> g.apply((ResolveComponentCandidatesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GreengrassV2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, ResolveComponentCandidatesRequest> {
        /**
         * <p>
         * The platform to use to resolve compatible components.
         * </p>
         * 
         * @param platform
         *        The platform to use to resolve compatible components.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platform(ComponentPlatform platform);

        /**
         * <p>
         * The platform to use to resolve compatible components.
         * </p>
         * This is a convenience that creates an instance of the {@link ComponentPlatform.Builder} avoiding the need to
         * create one manually via {@link ComponentPlatform#builder()}.
         *
         * When the {@link Consumer} completes, {@link ComponentPlatform.Builder#build()} is called immediately and its
         * result is passed to {@link #platform(ComponentPlatform)}.
         * 
         * @param platform
         *        a consumer that will call methods on {@link ComponentPlatform.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #platform(ComponentPlatform)
         */
        default Builder platform(Consumer<ComponentPlatform.Builder> platform) {
            return platform(ComponentPlatform.builder().applyMutation(platform).build());
        }

        /**
         * <p>
         * The list of components to resolve.
         * </p>
         * 
         * @param componentCandidates
         *        The list of components to resolve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentCandidates(Collection<ComponentCandidate> componentCandidates);

        /**
         * <p>
         * The list of components to resolve.
         * </p>
         * 
         * @param componentCandidates
         *        The list of components to resolve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentCandidates(ComponentCandidate... componentCandidates);

        /**
         * <p>
         * The list of components to resolve.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ComponentCandidate>.Builder} avoiding the
         * need to create one manually via {@link List<ComponentCandidate>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ComponentCandidate>.Builder#build()} is called immediately
         * and its result is passed to {@link #componentCandidates(List<ComponentCandidate>)}.
         * 
         * @param componentCandidates
         *        a consumer that will call methods on {@link List<ComponentCandidate>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #componentCandidates(List<ComponentCandidate>)
         */
        Builder componentCandidates(Consumer<ComponentCandidate.Builder>... componentCandidates);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GreengrassV2Request.BuilderImpl implements Builder {
        private ComponentPlatform platform;

        private List<ComponentCandidate> componentCandidates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ResolveComponentCandidatesRequest model) {
            super(model);
            platform(model.platform);
            componentCandidates(model.componentCandidates);
        }

        public final ComponentPlatform.Builder getPlatform() {
            return platform != null ? platform.toBuilder() : null;
        }

        @Override
        public final Builder platform(ComponentPlatform platform) {
            this.platform = platform;
            return this;
        }

        public final void setPlatform(ComponentPlatform.BuilderImpl platform) {
            this.platform = platform != null ? platform.build() : null;
        }

        public final List<ComponentCandidate.Builder> getComponentCandidates() {
            List<ComponentCandidate.Builder> result = ComponentCandidateListCopier.copyToBuilder(this.componentCandidates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder componentCandidates(Collection<ComponentCandidate> componentCandidates) {
            this.componentCandidates = ComponentCandidateListCopier.copy(componentCandidates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder componentCandidates(ComponentCandidate... componentCandidates) {
            componentCandidates(Arrays.asList(componentCandidates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder componentCandidates(Consumer<ComponentCandidate.Builder>... componentCandidates) {
            componentCandidates(Stream.of(componentCandidates).map(c -> ComponentCandidate.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setComponentCandidates(Collection<ComponentCandidate.BuilderImpl> componentCandidates) {
            this.componentCandidates = ComponentCandidateListCopier.copyFromBuilder(componentCandidates);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ResolveComponentCandidatesRequest build() {
            return new ResolveComponentCandidatesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
