/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrassv2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about policies that define how a deployment updates components and handles failure.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeploymentPolicies implements SdkPojo, Serializable,
        ToCopyableBuilder<DeploymentPolicies.Builder, DeploymentPolicies> {
    private static final SdkField<String> FAILURE_HANDLING_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureHandlingPolicy").getter(getter(DeploymentPolicies::failureHandlingPolicyAsString))
            .setter(setter(Builder::failureHandlingPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureHandlingPolicy").build())
            .build();

    private static final SdkField<DeploymentComponentUpdatePolicy> COMPONENT_UPDATE_POLICY_FIELD = SdkField
            .<DeploymentComponentUpdatePolicy> builder(MarshallingType.SDK_POJO).memberName("componentUpdatePolicy")
            .getter(getter(DeploymentPolicies::componentUpdatePolicy)).setter(setter(Builder::componentUpdatePolicy))
            .constructor(DeploymentComponentUpdatePolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentUpdatePolicy").build())
            .build();

    private static final SdkField<DeploymentConfigurationValidationPolicy> CONFIGURATION_VALIDATION_POLICY_FIELD = SdkField
            .<DeploymentConfigurationValidationPolicy> builder(MarshallingType.SDK_POJO)
            .memberName("configurationValidationPolicy")
            .getter(getter(DeploymentPolicies::configurationValidationPolicy))
            .setter(setter(Builder::configurationValidationPolicy))
            .constructor(DeploymentConfigurationValidationPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationValidationPolicy")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILURE_HANDLING_POLICY_FIELD,
            COMPONENT_UPDATE_POLICY_FIELD, CONFIGURATION_VALIDATION_POLICY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String failureHandlingPolicy;

    private final DeploymentComponentUpdatePolicy componentUpdatePolicy;

    private final DeploymentConfigurationValidationPolicy configurationValidationPolicy;

    private DeploymentPolicies(BuilderImpl builder) {
        this.failureHandlingPolicy = builder.failureHandlingPolicy;
        this.componentUpdatePolicy = builder.componentUpdatePolicy;
        this.configurationValidationPolicy = builder.configurationValidationPolicy;
    }

    /**
     * <p>
     * The failure handling policy for the configuration deployment. This policy defines what to do if the deployment
     * fails.
     * </p>
     * <p>
     * Default: <code>ROLLBACK</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #failureHandlingPolicy} will return {@link DeploymentFailureHandlingPolicy#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #failureHandlingPolicyAsString}.
     * </p>
     * 
     * @return The failure handling policy for the configuration deployment. This policy defines what to do if the
     *         deployment fails.</p>
     *         <p>
     *         Default: <code>ROLLBACK</code>
     * @see DeploymentFailureHandlingPolicy
     */
    public final DeploymentFailureHandlingPolicy failureHandlingPolicy() {
        return DeploymentFailureHandlingPolicy.fromValue(failureHandlingPolicy);
    }

    /**
     * <p>
     * The failure handling policy for the configuration deployment. This policy defines what to do if the deployment
     * fails.
     * </p>
     * <p>
     * Default: <code>ROLLBACK</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #failureHandlingPolicy} will return {@link DeploymentFailureHandlingPolicy#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #failureHandlingPolicyAsString}.
     * </p>
     * 
     * @return The failure handling policy for the configuration deployment. This policy defines what to do if the
     *         deployment fails.</p>
     *         <p>
     *         Default: <code>ROLLBACK</code>
     * @see DeploymentFailureHandlingPolicy
     */
    public final String failureHandlingPolicyAsString() {
        return failureHandlingPolicy;
    }

    /**
     * <p>
     * The component update policy for the configuration deployment. This policy defines when it's safe to deploy the
     * configuration to devices.
     * </p>
     * 
     * @return The component update policy for the configuration deployment. This policy defines when it's safe to
     *         deploy the configuration to devices.
     */
    public final DeploymentComponentUpdatePolicy componentUpdatePolicy() {
        return componentUpdatePolicy;
    }

    /**
     * <p>
     * The configuration validation policy for the configuration deployment. This policy defines how long each component
     * has to validate its configure updates.
     * </p>
     * 
     * @return The configuration validation policy for the configuration deployment. This policy defines how long each
     *         component has to validate its configure updates.
     */
    public final DeploymentConfigurationValidationPolicy configurationValidationPolicy() {
        return configurationValidationPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(failureHandlingPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(componentUpdatePolicy());
        hashCode = 31 * hashCode + Objects.hashCode(configurationValidationPolicy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentPolicies)) {
            return false;
        }
        DeploymentPolicies other = (DeploymentPolicies) obj;
        return Objects.equals(failureHandlingPolicyAsString(), other.failureHandlingPolicyAsString())
                && Objects.equals(componentUpdatePolicy(), other.componentUpdatePolicy())
                && Objects.equals(configurationValidationPolicy(), other.configurationValidationPolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeploymentPolicies").add("FailureHandlingPolicy", failureHandlingPolicyAsString())
                .add("ComponentUpdatePolicy", componentUpdatePolicy())
                .add("ConfigurationValidationPolicy", configurationValidationPolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "failureHandlingPolicy":
            return Optional.ofNullable(clazz.cast(failureHandlingPolicyAsString()));
        case "componentUpdatePolicy":
            return Optional.ofNullable(clazz.cast(componentUpdatePolicy()));
        case "configurationValidationPolicy":
            return Optional.ofNullable(clazz.cast(configurationValidationPolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeploymentPolicies, T> g) {
        return obj -> g.apply((DeploymentPolicies) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeploymentPolicies> {
        /**
         * <p>
         * The failure handling policy for the configuration deployment. This policy defines what to do if the
         * deployment fails.
         * </p>
         * <p>
         * Default: <code>ROLLBACK</code>
         * </p>
         * 
         * @param failureHandlingPolicy
         *        The failure handling policy for the configuration deployment. This policy defines what to do if the
         *        deployment fails.</p>
         *        <p>
         *        Default: <code>ROLLBACK</code>
         * @see DeploymentFailureHandlingPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentFailureHandlingPolicy
         */
        Builder failureHandlingPolicy(String failureHandlingPolicy);

        /**
         * <p>
         * The failure handling policy for the configuration deployment. This policy defines what to do if the
         * deployment fails.
         * </p>
         * <p>
         * Default: <code>ROLLBACK</code>
         * </p>
         * 
         * @param failureHandlingPolicy
         *        The failure handling policy for the configuration deployment. This policy defines what to do if the
         *        deployment fails.</p>
         *        <p>
         *        Default: <code>ROLLBACK</code>
         * @see DeploymentFailureHandlingPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentFailureHandlingPolicy
         */
        Builder failureHandlingPolicy(DeploymentFailureHandlingPolicy failureHandlingPolicy);

        /**
         * <p>
         * The component update policy for the configuration deployment. This policy defines when it's safe to deploy
         * the configuration to devices.
         * </p>
         * 
         * @param componentUpdatePolicy
         *        The component update policy for the configuration deployment. This policy defines when it's safe to
         *        deploy the configuration to devices.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentUpdatePolicy(DeploymentComponentUpdatePolicy componentUpdatePolicy);

        /**
         * <p>
         * The component update policy for the configuration deployment. This policy defines when it's safe to deploy
         * the configuration to devices.
         * </p>
         * This is a convenience that creates an instance of the {@link DeploymentComponentUpdatePolicy.Builder}
         * avoiding the need to create one manually via {@link DeploymentComponentUpdatePolicy#builder()}.
         *
         * When the {@link Consumer} completes, {@link DeploymentComponentUpdatePolicy.Builder#build()} is called
         * immediately and its result is passed to {@link #componentUpdatePolicy(DeploymentComponentUpdatePolicy)}.
         * 
         * @param componentUpdatePolicy
         *        a consumer that will call methods on {@link DeploymentComponentUpdatePolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #componentUpdatePolicy(DeploymentComponentUpdatePolicy)
         */
        default Builder componentUpdatePolicy(Consumer<DeploymentComponentUpdatePolicy.Builder> componentUpdatePolicy) {
            return componentUpdatePolicy(DeploymentComponentUpdatePolicy.builder().applyMutation(componentUpdatePolicy).build());
        }

        /**
         * <p>
         * The configuration validation policy for the configuration deployment. This policy defines how long each
         * component has to validate its configure updates.
         * </p>
         * 
         * @param configurationValidationPolicy
         *        The configuration validation policy for the configuration deployment. This policy defines how long
         *        each component has to validate its configure updates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationValidationPolicy(DeploymentConfigurationValidationPolicy configurationValidationPolicy);

        /**
         * <p>
         * The configuration validation policy for the configuration deployment. This policy defines how long each
         * component has to validate its configure updates.
         * </p>
         * This is a convenience that creates an instance of the {@link DeploymentConfigurationValidationPolicy.Builder}
         * avoiding the need to create one manually via {@link DeploymentConfigurationValidationPolicy#builder()}.
         *
         * When the {@link Consumer} completes, {@link DeploymentConfigurationValidationPolicy.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #configurationValidationPolicy(DeploymentConfigurationValidationPolicy)}.
         * 
         * @param configurationValidationPolicy
         *        a consumer that will call methods on {@link DeploymentConfigurationValidationPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configurationValidationPolicy(DeploymentConfigurationValidationPolicy)
         */
        default Builder configurationValidationPolicy(
                Consumer<DeploymentConfigurationValidationPolicy.Builder> configurationValidationPolicy) {
            return configurationValidationPolicy(DeploymentConfigurationValidationPolicy.builder()
                    .applyMutation(configurationValidationPolicy).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String failureHandlingPolicy;

        private DeploymentComponentUpdatePolicy componentUpdatePolicy;

        private DeploymentConfigurationValidationPolicy configurationValidationPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(DeploymentPolicies model) {
            failureHandlingPolicy(model.failureHandlingPolicy);
            componentUpdatePolicy(model.componentUpdatePolicy);
            configurationValidationPolicy(model.configurationValidationPolicy);
        }

        public final String getFailureHandlingPolicy() {
            return failureHandlingPolicy;
        }

        public final void setFailureHandlingPolicy(String failureHandlingPolicy) {
            this.failureHandlingPolicy = failureHandlingPolicy;
        }

        @Override
        @Transient
        public final Builder failureHandlingPolicy(String failureHandlingPolicy) {
            this.failureHandlingPolicy = failureHandlingPolicy;
            return this;
        }

        @Override
        @Transient
        public final Builder failureHandlingPolicy(DeploymentFailureHandlingPolicy failureHandlingPolicy) {
            this.failureHandlingPolicy(failureHandlingPolicy == null ? null : failureHandlingPolicy.toString());
            return this;
        }

        public final DeploymentComponentUpdatePolicy.Builder getComponentUpdatePolicy() {
            return componentUpdatePolicy != null ? componentUpdatePolicy.toBuilder() : null;
        }

        public final void setComponentUpdatePolicy(DeploymentComponentUpdatePolicy.BuilderImpl componentUpdatePolicy) {
            this.componentUpdatePolicy = componentUpdatePolicy != null ? componentUpdatePolicy.build() : null;
        }

        @Override
        @Transient
        public final Builder componentUpdatePolicy(DeploymentComponentUpdatePolicy componentUpdatePolicy) {
            this.componentUpdatePolicy = componentUpdatePolicy;
            return this;
        }

        public final DeploymentConfigurationValidationPolicy.Builder getConfigurationValidationPolicy() {
            return configurationValidationPolicy != null ? configurationValidationPolicy.toBuilder() : null;
        }

        public final void setConfigurationValidationPolicy(
                DeploymentConfigurationValidationPolicy.BuilderImpl configurationValidationPolicy) {
            this.configurationValidationPolicy = configurationValidationPolicy != null ? configurationValidationPolicy.build()
                    : null;
        }

        @Override
        @Transient
        public final Builder configurationValidationPolicy(DeploymentConfigurationValidationPolicy configurationValidationPolicy) {
            this.configurationValidationPolicy = configurationValidationPolicy;
            return this;
        }

        @Override
        public DeploymentPolicies build() {
            return new DeploymentPolicies(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
