/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrassv2.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCoreDeviceResponse extends GreengrassV2Response implements
        ToCopyableBuilder<GetCoreDeviceResponse.Builder, GetCoreDeviceResponse> {
    private static final SdkField<String> CORE_DEVICE_THING_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("coreDeviceThingName").getter(getter(GetCoreDeviceResponse::coreDeviceThingName))
            .setter(setter(Builder::coreDeviceThingName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("coreDeviceThingName").build())
            .build();

    private static final SdkField<String> CORE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("coreVersion").getter(getter(GetCoreDeviceResponse::coreVersion)).setter(setter(Builder::coreVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("coreVersion").build()).build();

    private static final SdkField<String> PLATFORM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("platform").getter(getter(GetCoreDeviceResponse::platform)).setter(setter(Builder::platform))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platform").build()).build();

    private static final SdkField<String> ARCHITECTURE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("architecture").getter(getter(GetCoreDeviceResponse::architecture)).setter(setter(Builder::architecture))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("architecture").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetCoreDeviceResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> LAST_STATUS_UPDATE_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT).memberName("lastStatusUpdateTimestamp")
            .getter(getter(GetCoreDeviceResponse::lastStatusUpdateTimestamp)).setter(setter(Builder::lastStatusUpdateTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastStatusUpdateTimestamp").build())
            .build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(GetCoreDeviceResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(CORE_DEVICE_THING_NAME_FIELD, CORE_VERSION_FIELD, PLATFORM_FIELD, ARCHITECTURE_FIELD,
                    STATUS_FIELD, LAST_STATUS_UPDATE_TIMESTAMP_FIELD, TAGS_FIELD));

    private final String coreDeviceThingName;

    private final String coreVersion;

    private final String platform;

    private final String architecture;

    private final String status;

    private final Instant lastStatusUpdateTimestamp;

    private final Map<String, String> tags;

    private GetCoreDeviceResponse(BuilderImpl builder) {
        super(builder);
        this.coreDeviceThingName = builder.coreDeviceThingName;
        this.coreVersion = builder.coreVersion;
        this.platform = builder.platform;
        this.architecture = builder.architecture;
        this.status = builder.status;
        this.lastStatusUpdateTimestamp = builder.lastStatusUpdateTimestamp;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the core device. This is also the name of the IoT thing.
     * </p>
     * 
     * @return The name of the core device. This is also the name of the IoT thing.
     */
    public final String coreDeviceThingName() {
        return coreDeviceThingName;
    }

    /**
     * <p>
     * The version of the IoT Greengrass Core software that the core device runs. This version is equivalent to the
     * version of the Greengrass nucleus component that runs on the core device. For more information, see the <a
     * href="https://docs.aws.amazon.com/greengrass/v2/developerguide/greengrass-nucleus-component.html">Greengrass
     * nucleus component</a> in the <i>IoT Greengrass V2 Developer Guide</i>.
     * </p>
     * 
     * @return The version of the IoT Greengrass Core software that the core device runs. This version is equivalent to
     *         the version of the Greengrass nucleus component that runs on the core device. For more information, see
     *         the <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/greengrass-nucleus-component.html">
     *         Greengrass nucleus component</a> in the <i>IoT Greengrass V2 Developer Guide</i>.
     */
    public final String coreVersion() {
        return coreVersion;
    }

    /**
     * <p>
     * The operating system platform that the core device runs.
     * </p>
     * 
     * @return The operating system platform that the core device runs.
     */
    public final String platform() {
        return platform;
    }

    /**
     * <p>
     * The computer architecture of the core device.
     * </p>
     * 
     * @return The computer architecture of the core device.
     */
    public final String architecture() {
        return architecture;
    }

    /**
     * <p>
     * The status of the core device. The core device status can be:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>HEALTHY</code> – The IoT Greengrass Core software and all components run on the core device without issue.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UNHEALTHY</code> – The IoT Greengrass Core software or a component is in a failed state on the core device.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CoreDeviceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the core device. The core device status can be:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>HEALTHY</code> – The IoT Greengrass Core software and all components run on the core device without
     *         issue.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UNHEALTHY</code> – The IoT Greengrass Core software or a component is in a failed state on the core
     *         device.
     *         </p>
     *         </li>
     * @see CoreDeviceStatus
     */
    public final CoreDeviceStatus status() {
        return CoreDeviceStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the core device. The core device status can be:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>HEALTHY</code> – The IoT Greengrass Core software and all components run on the core device without issue.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UNHEALTHY</code> – The IoT Greengrass Core software or a component is in a failed state on the core device.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CoreDeviceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the core device. The core device status can be:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>HEALTHY</code> – The IoT Greengrass Core software and all components run on the core device without
     *         issue.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UNHEALTHY</code> – The IoT Greengrass Core software or a component is in a failed state on the core
     *         device.
     *         </p>
     *         </li>
     * @see CoreDeviceStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The time at which the core device's status last updated, expressed in ISO 8601 format.
     * </p>
     * 
     * @return The time at which the core device's status last updated, expressed in ISO 8601 format.
     */
    public final Instant lastStatusUpdateTimestamp() {
        return lastStatusUpdateTimestamp;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of key-value pairs that contain metadata for the resource. For more information, see <a
     * href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your resources</a> in the
     * <i>IoT Greengrass V2 Developer Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of key-value pairs that contain metadata for the resource. For more information, see <a
     *         href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your resources</a>
     *         in the <i>IoT Greengrass V2 Developer Guide</i>.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(coreDeviceThingName());
        hashCode = 31 * hashCode + Objects.hashCode(coreVersion());
        hashCode = 31 * hashCode + Objects.hashCode(platform());
        hashCode = 31 * hashCode + Objects.hashCode(architecture());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastStatusUpdateTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCoreDeviceResponse)) {
            return false;
        }
        GetCoreDeviceResponse other = (GetCoreDeviceResponse) obj;
        return Objects.equals(coreDeviceThingName(), other.coreDeviceThingName())
                && Objects.equals(coreVersion(), other.coreVersion()) && Objects.equals(platform(), other.platform())
                && Objects.equals(architecture(), other.architecture())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(lastStatusUpdateTimestamp(), other.lastStatusUpdateTimestamp()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCoreDeviceResponse").add("CoreDeviceThingName", coreDeviceThingName())
                .add("CoreVersion", coreVersion()).add("Platform", platform()).add("Architecture", architecture())
                .add("Status", statusAsString()).add("LastStatusUpdateTimestamp", lastStatusUpdateTimestamp())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "coreDeviceThingName":
            return Optional.ofNullable(clazz.cast(coreDeviceThingName()));
        case "coreVersion":
            return Optional.ofNullable(clazz.cast(coreVersion()));
        case "platform":
            return Optional.ofNullable(clazz.cast(platform()));
        case "architecture":
            return Optional.ofNullable(clazz.cast(architecture()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "lastStatusUpdateTimestamp":
            return Optional.ofNullable(clazz.cast(lastStatusUpdateTimestamp()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetCoreDeviceResponse, T> g) {
        return obj -> g.apply((GetCoreDeviceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GreengrassV2Response.Builder, SdkPojo, CopyableBuilder<Builder, GetCoreDeviceResponse> {
        /**
         * <p>
         * The name of the core device. This is also the name of the IoT thing.
         * </p>
         * 
         * @param coreDeviceThingName
         *        The name of the core device. This is also the name of the IoT thing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coreDeviceThingName(String coreDeviceThingName);

        /**
         * <p>
         * The version of the IoT Greengrass Core software that the core device runs. This version is equivalent to the
         * version of the Greengrass nucleus component that runs on the core device. For more information, see the <a
         * href="https://docs.aws.amazon.com/greengrass/v2/developerguide/greengrass-nucleus-component.html">Greengrass
         * nucleus component</a> in the <i>IoT Greengrass V2 Developer Guide</i>.
         * </p>
         * 
         * @param coreVersion
         *        The version of the IoT Greengrass Core software that the core device runs. This version is equivalent
         *        to the version of the Greengrass nucleus component that runs on the core device. For more information,
         *        see the <a
         *        href="https://docs.aws.amazon.com/greengrass/v2/developerguide/greengrass-nucleus-component.html"
         *        >Greengrass nucleus component</a> in the <i>IoT Greengrass V2 Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coreVersion(String coreVersion);

        /**
         * <p>
         * The operating system platform that the core device runs.
         * </p>
         * 
         * @param platform
         *        The operating system platform that the core device runs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platform(String platform);

        /**
         * <p>
         * The computer architecture of the core device.
         * </p>
         * 
         * @param architecture
         *        The computer architecture of the core device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder architecture(String architecture);

        /**
         * <p>
         * The status of the core device. The core device status can be:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>HEALTHY</code> – The IoT Greengrass Core software and all components run on the core device without
         * issue.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UNHEALTHY</code> – The IoT Greengrass Core software or a component is in a failed state on the core
         * device.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the core device. The core device status can be:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>HEALTHY</code> – The IoT Greengrass Core software and all components run on the core device
         *        without issue.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UNHEALTHY</code> – The IoT Greengrass Core software or a component is in a failed state on the
         *        core device.
         *        </p>
         *        </li>
         * @see CoreDeviceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CoreDeviceStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the core device. The core device status can be:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>HEALTHY</code> – The IoT Greengrass Core software and all components run on the core device without
         * issue.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UNHEALTHY</code> – The IoT Greengrass Core software or a component is in a failed state on the core
         * device.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the core device. The core device status can be:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>HEALTHY</code> – The IoT Greengrass Core software and all components run on the core device
         *        without issue.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UNHEALTHY</code> – The IoT Greengrass Core software or a component is in a failed state on the
         *        core device.
         *        </p>
         *        </li>
         * @see CoreDeviceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CoreDeviceStatus
         */
        Builder status(CoreDeviceStatus status);

        /**
         * <p>
         * The time at which the core device's status last updated, expressed in ISO 8601 format.
         * </p>
         * 
         * @param lastStatusUpdateTimestamp
         *        The time at which the core device's status last updated, expressed in ISO 8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastStatusUpdateTimestamp(Instant lastStatusUpdateTimestamp);

        /**
         * <p>
         * A list of key-value pairs that contain metadata for the resource. For more information, see <a
         * href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your resources</a> in
         * the <i>IoT Greengrass V2 Developer Guide</i>.
         * </p>
         * 
         * @param tags
         *        A list of key-value pairs that contain metadata for the resource. For more information, see <a
         *        href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your
         *        resources</a> in the <i>IoT Greengrass V2 Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends GreengrassV2Response.BuilderImpl implements Builder {
        private String coreDeviceThingName;

        private String coreVersion;

        private String platform;

        private String architecture;

        private String status;

        private Instant lastStatusUpdateTimestamp;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetCoreDeviceResponse model) {
            super(model);
            coreDeviceThingName(model.coreDeviceThingName);
            coreVersion(model.coreVersion);
            platform(model.platform);
            architecture(model.architecture);
            status(model.status);
            lastStatusUpdateTimestamp(model.lastStatusUpdateTimestamp);
            tags(model.tags);
        }

        public final String getCoreDeviceThingName() {
            return coreDeviceThingName;
        }

        public final void setCoreDeviceThingName(String coreDeviceThingName) {
            this.coreDeviceThingName = coreDeviceThingName;
        }

        @Override
        @Transient
        public final Builder coreDeviceThingName(String coreDeviceThingName) {
            this.coreDeviceThingName = coreDeviceThingName;
            return this;
        }

        public final String getCoreVersion() {
            return coreVersion;
        }

        public final void setCoreVersion(String coreVersion) {
            this.coreVersion = coreVersion;
        }

        @Override
        @Transient
        public final Builder coreVersion(String coreVersion) {
            this.coreVersion = coreVersion;
            return this;
        }

        public final String getPlatform() {
            return platform;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        @Override
        @Transient
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        public final String getArchitecture() {
            return architecture;
        }

        public final void setArchitecture(String architecture) {
            this.architecture = architecture;
        }

        @Override
        @Transient
        public final Builder architecture(String architecture) {
            this.architecture = architecture;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(CoreDeviceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getLastStatusUpdateTimestamp() {
            return lastStatusUpdateTimestamp;
        }

        public final void setLastStatusUpdateTimestamp(Instant lastStatusUpdateTimestamp) {
            this.lastStatusUpdateTimestamp = lastStatusUpdateTimestamp;
        }

        @Override
        @Transient
        public final Builder lastStatusUpdateTimestamp(Instant lastStatusUpdateTimestamp) {
            this.lastStatusUpdateTimestamp = lastStatusUpdateTimestamp;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public GetCoreDeviceResponse build() {
            return new GetCoreDeviceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
