/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrassv2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains parameters for a Linux process that contains an Lambda function.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LambdaLinuxProcessParams implements SdkPojo, Serializable,
        ToCopyableBuilder<LambdaLinuxProcessParams.Builder, LambdaLinuxProcessParams> {
    private static final SdkField<String> ISOLATION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("isolationMode").getter(getter(LambdaLinuxProcessParams::isolationModeAsString))
            .setter(setter(Builder::isolationMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isolationMode").build()).build();

    private static final SdkField<LambdaContainerParams> CONTAINER_PARAMS_FIELD = SdkField
            .<LambdaContainerParams> builder(MarshallingType.SDK_POJO).memberName("containerParams")
            .getter(getter(LambdaLinuxProcessParams::containerParams)).setter(setter(Builder::containerParams))
            .constructor(LambdaContainerParams::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerParams").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ISOLATION_MODE_FIELD,
            CONTAINER_PARAMS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String isolationMode;

    private final LambdaContainerParams containerParams;

    private LambdaLinuxProcessParams(BuilderImpl builder) {
        this.isolationMode = builder.isolationMode;
        this.containerParams = builder.containerParams;
    }

    /**
     * <p>
     * The isolation mode for the process that contains the Lambda function. The process can run in an isolated runtime
     * environment inside the IoT Greengrass container, or as a regular process outside any container.
     * </p>
     * <p>
     * Default: <code>GreengrassContainer</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #isolationMode}
     * will return {@link LambdaIsolationMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #isolationModeAsString}.
     * </p>
     * 
     * @return The isolation mode for the process that contains the Lambda function. The process can run in an isolated
     *         runtime environment inside the IoT Greengrass container, or as a regular process outside any
     *         container.</p>
     *         <p>
     *         Default: <code>GreengrassContainer</code>
     * @see LambdaIsolationMode
     */
    public final LambdaIsolationMode isolationMode() {
        return LambdaIsolationMode.fromValue(isolationMode);
    }

    /**
     * <p>
     * The isolation mode for the process that contains the Lambda function. The process can run in an isolated runtime
     * environment inside the IoT Greengrass container, or as a regular process outside any container.
     * </p>
     * <p>
     * Default: <code>GreengrassContainer</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #isolationMode}
     * will return {@link LambdaIsolationMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #isolationModeAsString}.
     * </p>
     * 
     * @return The isolation mode for the process that contains the Lambda function. The process can run in an isolated
     *         runtime environment inside the IoT Greengrass container, or as a regular process outside any
     *         container.</p>
     *         <p>
     *         Default: <code>GreengrassContainer</code>
     * @see LambdaIsolationMode
     */
    public final String isolationModeAsString() {
        return isolationMode;
    }

    /**
     * <p>
     * The parameters for the container in which the Lambda function runs.
     * </p>
     * 
     * @return The parameters for the container in which the Lambda function runs.
     */
    public final LambdaContainerParams containerParams() {
        return containerParams;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(isolationModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(containerParams());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LambdaLinuxProcessParams)) {
            return false;
        }
        LambdaLinuxProcessParams other = (LambdaLinuxProcessParams) obj;
        return Objects.equals(isolationModeAsString(), other.isolationModeAsString())
                && Objects.equals(containerParams(), other.containerParams());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LambdaLinuxProcessParams").add("IsolationMode", isolationModeAsString())
                .add("ContainerParams", containerParams()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "isolationMode":
            return Optional.ofNullable(clazz.cast(isolationModeAsString()));
        case "containerParams":
            return Optional.ofNullable(clazz.cast(containerParams()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LambdaLinuxProcessParams, T> g) {
        return obj -> g.apply((LambdaLinuxProcessParams) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LambdaLinuxProcessParams> {
        /**
         * <p>
         * The isolation mode for the process that contains the Lambda function. The process can run in an isolated
         * runtime environment inside the IoT Greengrass container, or as a regular process outside any container.
         * </p>
         * <p>
         * Default: <code>GreengrassContainer</code>
         * </p>
         * 
         * @param isolationMode
         *        The isolation mode for the process that contains the Lambda function. The process can run in an
         *        isolated runtime environment inside the IoT Greengrass container, or as a regular process outside any
         *        container.</p>
         *        <p>
         *        Default: <code>GreengrassContainer</code>
         * @see LambdaIsolationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LambdaIsolationMode
         */
        Builder isolationMode(String isolationMode);

        /**
         * <p>
         * The isolation mode for the process that contains the Lambda function. The process can run in an isolated
         * runtime environment inside the IoT Greengrass container, or as a regular process outside any container.
         * </p>
         * <p>
         * Default: <code>GreengrassContainer</code>
         * </p>
         * 
         * @param isolationMode
         *        The isolation mode for the process that contains the Lambda function. The process can run in an
         *        isolated runtime environment inside the IoT Greengrass container, or as a regular process outside any
         *        container.</p>
         *        <p>
         *        Default: <code>GreengrassContainer</code>
         * @see LambdaIsolationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LambdaIsolationMode
         */
        Builder isolationMode(LambdaIsolationMode isolationMode);

        /**
         * <p>
         * The parameters for the container in which the Lambda function runs.
         * </p>
         * 
         * @param containerParams
         *        The parameters for the container in which the Lambda function runs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerParams(LambdaContainerParams containerParams);

        /**
         * <p>
         * The parameters for the container in which the Lambda function runs.
         * </p>
         * This is a convenience that creates an instance of the {@link LambdaContainerParams.Builder} avoiding the need
         * to create one manually via {@link LambdaContainerParams#builder()}.
         *
         * When the {@link Consumer} completes, {@link LambdaContainerParams.Builder#build()} is called immediately and
         * its result is passed to {@link #containerParams(LambdaContainerParams)}.
         * 
         * @param containerParams
         *        a consumer that will call methods on {@link LambdaContainerParams.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #containerParams(LambdaContainerParams)
         */
        default Builder containerParams(Consumer<LambdaContainerParams.Builder> containerParams) {
            return containerParams(LambdaContainerParams.builder().applyMutation(containerParams).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String isolationMode;

        private LambdaContainerParams containerParams;

        private BuilderImpl() {
        }

        private BuilderImpl(LambdaLinuxProcessParams model) {
            isolationMode(model.isolationMode);
            containerParams(model.containerParams);
        }

        public final String getIsolationMode() {
            return isolationMode;
        }

        public final void setIsolationMode(String isolationMode) {
            this.isolationMode = isolationMode;
        }

        @Override
        @Transient
        public final Builder isolationMode(String isolationMode) {
            this.isolationMode = isolationMode;
            return this;
        }

        @Override
        @Transient
        public final Builder isolationMode(LambdaIsolationMode isolationMode) {
            this.isolationMode(isolationMode == null ? null : isolationMode.toString());
            return this;
        }

        public final LambdaContainerParams.Builder getContainerParams() {
            return containerParams != null ? containerParams.toBuilder() : null;
        }

        public final void setContainerParams(LambdaContainerParams.BuilderImpl containerParams) {
            this.containerParams = containerParams != null ? containerParams.build() : null;
        }

        @Override
        @Transient
        public final Builder containerParams(LambdaContainerParams containerParams) {
            this.containerParams = containerParams;
            return this;
        }

        @Override
        public LambdaLinuxProcessParams build() {
            return new LambdaLinuxProcessParams(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
