/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrassv2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDeploymentsRequest extends GreengrassV2Request implements
        ToCopyableBuilder<ListDeploymentsRequest.Builder, ListDeploymentsRequest> {
    private static final SdkField<String> TARGET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetArn").getter(getter(ListDeploymentsRequest::targetArn)).setter(setter(Builder::targetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("targetArn").build()).build();

    private static final SdkField<String> HISTORY_FILTER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("historyFilter").getter(getter(ListDeploymentsRequest::historyFilterAsString))
            .setter(setter(Builder::historyFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("historyFilter").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListDeploymentsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListDeploymentsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_ARN_FIELD,
            HISTORY_FILTER_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final String targetArn;

    private final String historyFilter;

    private final Integer maxResults;

    private final String nextToken;

    private ListDeploymentsRequest(BuilderImpl builder) {
        super(builder);
        this.targetArn = builder.targetArn;
        this.historyFilter = builder.historyFilter;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the target
     * IoT thing or thing group.
     * </p>
     * 
     * @return The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the
     *         target IoT thing or thing group.
     */
    public final String targetArn() {
        return targetArn;
    }

    /**
     * <p>
     * The filter for the list of deployments. Choose one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ALL</code> – The list includes all deployments.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LATEST_ONLY</code> – The list includes only the latest revision of each deployment.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Default: <code>LATEST_ONLY</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #historyFilter}
     * will return {@link DeploymentHistoryFilter#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #historyFilterAsString}.
     * </p>
     * 
     * @return The filter for the list of deployments. Choose one of the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ALL</code> – The list includes all deployments.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LATEST_ONLY</code> – The list includes only the latest revision of each deployment.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Default: <code>LATEST_ONLY</code>
     * @see DeploymentHistoryFilter
     */
    public final DeploymentHistoryFilter historyFilter() {
        return DeploymentHistoryFilter.fromValue(historyFilter);
    }

    /**
     * <p>
     * The filter for the list of deployments. Choose one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ALL</code> – The list includes all deployments.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LATEST_ONLY</code> – The list includes only the latest revision of each deployment.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Default: <code>LATEST_ONLY</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #historyFilter}
     * will return {@link DeploymentHistoryFilter#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #historyFilterAsString}.
     * </p>
     * 
     * @return The filter for the list of deployments. Choose one of the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ALL</code> – The list includes all deployments.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LATEST_ONLY</code> – The list includes only the latest revision of each deployment.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Default: <code>LATEST_ONLY</code>
     * @see DeploymentHistoryFilter
     */
    public final String historyFilterAsString() {
        return historyFilter;
    }

    /**
     * <p>
     * The maximum number of results to be returned per paginated request.
     * </p>
     * 
     * @return The maximum number of results to be returned per paginated request.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token to be used for the next set of paginated results.
     * </p>
     * 
     * @return The token to be used for the next set of paginated results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(targetArn());
        hashCode = 31 * hashCode + Objects.hashCode(historyFilterAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDeploymentsRequest)) {
            return false;
        }
        ListDeploymentsRequest other = (ListDeploymentsRequest) obj;
        return Objects.equals(targetArn(), other.targetArn())
                && Objects.equals(historyFilterAsString(), other.historyFilterAsString())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListDeploymentsRequest").add("TargetArn", targetArn())
                .add("HistoryFilter", historyFilterAsString()).add("MaxResults", maxResults()).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "targetArn":
            return Optional.ofNullable(clazz.cast(targetArn()));
        case "historyFilter":
            return Optional.ofNullable(clazz.cast(historyFilterAsString()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDeploymentsRequest, T> g) {
        return obj -> g.apply((ListDeploymentsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GreengrassV2Request.Builder, SdkPojo, CopyableBuilder<Builder, ListDeploymentsRequest> {
        /**
         * <p>
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the
         * target IoT thing or thing group.
         * </p>
         * 
         * @param targetArn
         *        The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of
         *        the target IoT thing or thing group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetArn(String targetArn);

        /**
         * <p>
         * The filter for the list of deployments. Choose one of the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ALL</code> – The list includes all deployments.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LATEST_ONLY</code> – The list includes only the latest revision of each deployment.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Default: <code>LATEST_ONLY</code>
         * </p>
         * 
         * @param historyFilter
         *        The filter for the list of deployments. Choose one of the following options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ALL</code> – The list includes all deployments.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LATEST_ONLY</code> – The list includes only the latest revision of each deployment.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Default: <code>LATEST_ONLY</code>
         * @see DeploymentHistoryFilter
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentHistoryFilter
         */
        Builder historyFilter(String historyFilter);

        /**
         * <p>
         * The filter for the list of deployments. Choose one of the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ALL</code> – The list includes all deployments.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LATEST_ONLY</code> – The list includes only the latest revision of each deployment.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Default: <code>LATEST_ONLY</code>
         * </p>
         * 
         * @param historyFilter
         *        The filter for the list of deployments. Choose one of the following options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ALL</code> – The list includes all deployments.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LATEST_ONLY</code> – The list includes only the latest revision of each deployment.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Default: <code>LATEST_ONLY</code>
         * @see DeploymentHistoryFilter
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentHistoryFilter
         */
        Builder historyFilter(DeploymentHistoryFilter historyFilter);

        /**
         * <p>
         * The maximum number of results to be returned per paginated request.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to be returned per paginated request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token to be used for the next set of paginated results.
         * </p>
         * 
         * @param nextToken
         *        The token to be used for the next set of paginated results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GreengrassV2Request.BuilderImpl implements Builder {
        private String targetArn;

        private String historyFilter;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDeploymentsRequest model) {
            super(model);
            targetArn(model.targetArn);
            historyFilter(model.historyFilter);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getTargetArn() {
            return targetArn;
        }

        public final void setTargetArn(String targetArn) {
            this.targetArn = targetArn;
        }

        @Override
        @Transient
        public final Builder targetArn(String targetArn) {
            this.targetArn = targetArn;
            return this;
        }

        public final String getHistoryFilter() {
            return historyFilter;
        }

        public final void setHistoryFilter(String historyFilter) {
            this.historyFilter = historyFilter;
        }

        @Override
        @Transient
        public final Builder historyFilter(String historyFilter) {
            this.historyFilter = historyFilter;
            return this;
        }

        @Override
        @Transient
        public final Builder historyFilter(DeploymentHistoryFilter historyFilter) {
            this.historyFilter(historyFilter == null ? null : historyFilter.toString());
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListDeploymentsRequest build() {
            return new ListDeploymentsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
