/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrassv2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListEffectiveDeploymentsResponse extends GreengrassV2Response implements
        ToCopyableBuilder<ListEffectiveDeploymentsResponse.Builder, ListEffectiveDeploymentsResponse> {
    private static final SdkField<List<EffectiveDeployment>> EFFECTIVE_DEPLOYMENTS_FIELD = SdkField
            .<List<EffectiveDeployment>> builder(MarshallingType.LIST)
            .memberName("effectiveDeployments")
            .getter(getter(ListEffectiveDeploymentsResponse::effectiveDeployments))
            .setter(setter(Builder::effectiveDeployments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("effectiveDeployments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EffectiveDeployment> builder(MarshallingType.SDK_POJO)
                                            .constructor(EffectiveDeployment::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListEffectiveDeploymentsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EFFECTIVE_DEPLOYMENTS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<EffectiveDeployment> effectiveDeployments;

    private final String nextToken;

    private ListEffectiveDeploymentsResponse(BuilderImpl builder) {
        super(builder);
        this.effectiveDeployments = builder.effectiveDeployments;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the EffectiveDeployments property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEffectiveDeployments() {
        return effectiveDeployments != null && !(effectiveDeployments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list that summarizes each deployment on the core device.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEffectiveDeployments} method.
     * </p>
     * 
     * @return A list that summarizes each deployment on the core device.
     */
    public final List<EffectiveDeployment> effectiveDeployments() {
        return effectiveDeployments;
    }

    /**
     * <p>
     * The token for the next set of results, or null if there are no additional results.
     * </p>
     * 
     * @return The token for the next set of results, or null if there are no additional results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEffectiveDeployments() ? effectiveDeployments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEffectiveDeploymentsResponse)) {
            return false;
        }
        ListEffectiveDeploymentsResponse other = (ListEffectiveDeploymentsResponse) obj;
        return hasEffectiveDeployments() == other.hasEffectiveDeployments()
                && Objects.equals(effectiveDeployments(), other.effectiveDeployments())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListEffectiveDeploymentsResponse")
                .add("EffectiveDeployments", hasEffectiveDeployments() ? effectiveDeployments() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "effectiveDeployments":
            return Optional.ofNullable(clazz.cast(effectiveDeployments()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListEffectiveDeploymentsResponse, T> g) {
        return obj -> g.apply((ListEffectiveDeploymentsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GreengrassV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, ListEffectiveDeploymentsResponse> {
        /**
         * <p>
         * A list that summarizes each deployment on the core device.
         * </p>
         * 
         * @param effectiveDeployments
         *        A list that summarizes each deployment on the core device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder effectiveDeployments(Collection<EffectiveDeployment> effectiveDeployments);

        /**
         * <p>
         * A list that summarizes each deployment on the core device.
         * </p>
         * 
         * @param effectiveDeployments
         *        A list that summarizes each deployment on the core device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder effectiveDeployments(EffectiveDeployment... effectiveDeployments);

        /**
         * <p>
         * A list that summarizes each deployment on the core device.
         * </p>
         * This is a convenience that creates an instance of the {@link List<EffectiveDeployment>.Builder} avoiding the
         * need to create one manually via {@link List<EffectiveDeployment>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EffectiveDeployment>.Builder#build()} is called immediately
         * and its result is passed to {@link #effectiveDeployments(List<EffectiveDeployment>)}.
         * 
         * @param effectiveDeployments
         *        a consumer that will call methods on {@link List<EffectiveDeployment>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #effectiveDeployments(List<EffectiveDeployment>)
         */
        Builder effectiveDeployments(Consumer<EffectiveDeployment.Builder>... effectiveDeployments);

        /**
         * <p>
         * The token for the next set of results, or null if there are no additional results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results, or null if there are no additional results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends GreengrassV2Response.BuilderImpl implements Builder {
        private List<EffectiveDeployment> effectiveDeployments = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEffectiveDeploymentsResponse model) {
            super(model);
            effectiveDeployments(model.effectiveDeployments);
            nextToken(model.nextToken);
        }

        public final List<EffectiveDeployment.Builder> getEffectiveDeployments() {
            List<EffectiveDeployment.Builder> result = EffectiveDeploymentsListCopier.copyToBuilder(this.effectiveDeployments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEffectiveDeployments(Collection<EffectiveDeployment.BuilderImpl> effectiveDeployments) {
            this.effectiveDeployments = EffectiveDeploymentsListCopier.copyFromBuilder(effectiveDeployments);
        }

        @Override
        @Transient
        public final Builder effectiveDeployments(Collection<EffectiveDeployment> effectiveDeployments) {
            this.effectiveDeployments = EffectiveDeploymentsListCopier.copy(effectiveDeployments);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder effectiveDeployments(EffectiveDeployment... effectiveDeployments) {
            effectiveDeployments(Arrays.asList(effectiveDeployments));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder effectiveDeployments(Consumer<EffectiveDeployment.Builder>... effectiveDeployments) {
            effectiveDeployments(Stream.of(effectiveDeployments).map(c -> EffectiveDeployment.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListEffectiveDeploymentsResponse build() {
            return new ListEffectiveDeploymentsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
