/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrassv2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about system resource limits that the IoT Greengrass Core software applies to a component's
 * processes. For more information, see <a href=
 * "https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-greengrass-core-v2.html#configure-component-system-resource-limits"
 * >Configure system resource limits for components</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SystemResourceLimits implements SdkPojo, Serializable,
        ToCopyableBuilder<SystemResourceLimits.Builder, SystemResourceLimits> {
    private static final SdkField<Long> MEMORY_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("memory")
            .getter(getter(SystemResourceLimits::memory)).setter(setter(Builder::memory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memory").build()).build();

    private static final SdkField<Double> CPUS_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("cpus")
            .getter(getter(SystemResourceLimits::cpus)).setter(setter(Builder::cpus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMORY_FIELD, CPUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long memory;

    private final Double cpus;

    private SystemResourceLimits(BuilderImpl builder) {
        this.memory = builder.memory;
        this.cpus = builder.cpus;
    }

    /**
     * <p>
     * The maximum amount of RAM, expressed in kilobytes, that a component's processes can use on the core device.
     * </p>
     * 
     * @return The maximum amount of RAM, expressed in kilobytes, that a component's processes can use on the core
     *         device.
     */
    public final Long memory() {
        return memory;
    }

    /**
     * <p>
     * The maximum amount of CPU time that a component's processes can use on the core device. A core device's total CPU
     * time is equivalent to the device's number of CPU cores. For example, on a core device with 4 CPU cores, you can
     * set this value to <code>2</code> to limit the component's processes to 50 percent usage of each CPU core. On a
     * device with 1 CPU core, you can set this value to <code>0.25</code> to limit the component's processes to 25
     * percent usage of the CPU. If you set this value to a number greater than the number of CPU cores, the IoT
     * Greengrass Core software doesn't limit the component's CPU usage.
     * </p>
     * 
     * @return The maximum amount of CPU time that a component's processes can use on the core device. A core device's
     *         total CPU time is equivalent to the device's number of CPU cores. For example, on a core device with 4
     *         CPU cores, you can set this value to <code>2</code> to limit the component's processes to 50 percent
     *         usage of each CPU core. On a device with 1 CPU core, you can set this value to <code>0.25</code> to limit
     *         the component's processes to 25 percent usage of the CPU. If you set this value to a number greater than
     *         the number of CPU cores, the IoT Greengrass Core software doesn't limit the component's CPU usage.
     */
    public final Double cpus() {
        return cpus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(memory());
        hashCode = 31 * hashCode + Objects.hashCode(cpus());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SystemResourceLimits)) {
            return false;
        }
        SystemResourceLimits other = (SystemResourceLimits) obj;
        return Objects.equals(memory(), other.memory()) && Objects.equals(cpus(), other.cpus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SystemResourceLimits").add("Memory", memory()).add("Cpus", cpus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "memory":
            return Optional.ofNullable(clazz.cast(memory()));
        case "cpus":
            return Optional.ofNullable(clazz.cast(cpus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SystemResourceLimits, T> g) {
        return obj -> g.apply((SystemResourceLimits) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SystemResourceLimits> {
        /**
         * <p>
         * The maximum amount of RAM, expressed in kilobytes, that a component's processes can use on the core device.
         * </p>
         * 
         * @param memory
         *        The maximum amount of RAM, expressed in kilobytes, that a component's processes can use on the core
         *        device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memory(Long memory);

        /**
         * <p>
         * The maximum amount of CPU time that a component's processes can use on the core device. A core device's total
         * CPU time is equivalent to the device's number of CPU cores. For example, on a core device with 4 CPU cores,
         * you can set this value to <code>2</code> to limit the component's processes to 50 percent usage of each CPU
         * core. On a device with 1 CPU core, you can set this value to <code>0.25</code> to limit the component's
         * processes to 25 percent usage of the CPU. If you set this value to a number greater than the number of CPU
         * cores, the IoT Greengrass Core software doesn't limit the component's CPU usage.
         * </p>
         * 
         * @param cpus
         *        The maximum amount of CPU time that a component's processes can use on the core device. A core
         *        device's total CPU time is equivalent to the device's number of CPU cores. For example, on a core
         *        device with 4 CPU cores, you can set this value to <code>2</code> to limit the component's processes
         *        to 50 percent usage of each CPU core. On a device with 1 CPU core, you can set this value to
         *        <code>0.25</code> to limit the component's processes to 25 percent usage of the CPU. If you set this
         *        value to a number greater than the number of CPU cores, the IoT Greengrass Core software doesn't limit
         *        the component's CPU usage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cpus(Double cpus);
    }

    static final class BuilderImpl implements Builder {
        private Long memory;

        private Double cpus;

        private BuilderImpl() {
        }

        private BuilderImpl(SystemResourceLimits model) {
            memory(model.memory);
            cpus(model.cpus);
        }

        public final Long getMemory() {
            return memory;
        }

        public final void setMemory(Long memory) {
            this.memory = memory;
        }

        @Override
        @Transient
        public final Builder memory(Long memory) {
            this.memory = memory;
            return this;
        }

        public final Double getCpus() {
            return cpus;
        }

        public final void setCpus(Double cpus) {
            this.cpus = cpus;
        }

        @Override
        @Transient
        public final Builder cpus(Double cpus) {
            this.cpus = cpus;
            return this;
        }

        @Override
        public SystemResourceLimits build() {
            return new SystemResourceLimits(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
