/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrassv2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.greengrassv2.model.InstalledComponentLifecycleState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstalledComponent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstalledComponent> {
    private static final SdkField<String> COMPONENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("componentName").getter(InstalledComponent.getter(InstalledComponent::componentName)).setter(InstalledComponent.setter(Builder::componentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentName").build()}).build();
    private static final SdkField<String> COMPONENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("componentVersion").getter(InstalledComponent.getter(InstalledComponent::componentVersion)).setter(InstalledComponent.setter(Builder::componentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentVersion").build()}).build();
    private static final SdkField<String> LIFECYCLE_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lifecycleState").getter(InstalledComponent.getter(InstalledComponent::lifecycleStateAsString)).setter(InstalledComponent.setter(Builder::lifecycleState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecycleState").build()}).build();
    private static final SdkField<String> LIFECYCLE_STATE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lifecycleStateDetails").getter(InstalledComponent.getter(InstalledComponent::lifecycleStateDetails)).setter(InstalledComponent.setter(Builder::lifecycleStateDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecycleStateDetails").build()}).build();
    private static final SdkField<Boolean> IS_ROOT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isRoot").getter(InstalledComponent.getter(InstalledComponent::isRoot)).setter(InstalledComponent.setter(Builder::isRoot)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isRoot").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPONENT_NAME_FIELD, COMPONENT_VERSION_FIELD, LIFECYCLE_STATE_FIELD, LIFECYCLE_STATE_DETAILS_FIELD, IS_ROOT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String componentName;
    private final String componentVersion;
    private final String lifecycleState;
    private final String lifecycleStateDetails;
    private final Boolean isRoot;

    private InstalledComponent(BuilderImpl builder) {
        this.componentName = builder.componentName;
        this.componentVersion = builder.componentVersion;
        this.lifecycleState = builder.lifecycleState;
        this.lifecycleStateDetails = builder.lifecycleStateDetails;
        this.isRoot = builder.isRoot;
    }

    public final String componentName() {
        return this.componentName;
    }

    public final String componentVersion() {
        return this.componentVersion;
    }

    public final InstalledComponentLifecycleState lifecycleState() {
        return InstalledComponentLifecycleState.fromValue(this.lifecycleState);
    }

    public final String lifecycleStateAsString() {
        return this.lifecycleState;
    }

    public final String lifecycleStateDetails() {
        return this.lifecycleStateDetails;
    }

    public final Boolean isRoot() {
        return this.isRoot;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.componentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.componentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleStateDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.isRoot());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstalledComponent)) {
            return false;
        }
        InstalledComponent other = (InstalledComponent)obj;
        return Objects.equals(this.componentName(), other.componentName()) && Objects.equals(this.componentVersion(), other.componentVersion()) && Objects.equals(this.lifecycleStateAsString(), other.lifecycleStateAsString()) && Objects.equals(this.lifecycleStateDetails(), other.lifecycleStateDetails()) && Objects.equals(this.isRoot(), other.isRoot());
    }

    public final String toString() {
        return ToString.builder((String)"InstalledComponent").add("ComponentName", (Object)this.componentName()).add("ComponentVersion", (Object)this.componentVersion()).add("LifecycleState", (Object)this.lifecycleStateAsString()).add("LifecycleStateDetails", (Object)this.lifecycleStateDetails()).add("IsRoot", (Object)this.isRoot()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "componentName": {
                return Optional.ofNullable(clazz.cast(this.componentName()));
            }
            case "componentVersion": {
                return Optional.ofNullable(clazz.cast(this.componentVersion()));
            }
            case "lifecycleState": {
                return Optional.ofNullable(clazz.cast(this.lifecycleStateAsString()));
            }
            case "lifecycleStateDetails": {
                return Optional.ofNullable(clazz.cast(this.lifecycleStateDetails()));
            }
            case "isRoot": {
                return Optional.ofNullable(clazz.cast(this.isRoot()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstalledComponent, T> g) {
        return obj -> g.apply((InstalledComponent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String componentName;
        private String componentVersion;
        private String lifecycleState;
        private String lifecycleStateDetails;
        private Boolean isRoot;

        private BuilderImpl() {
        }

        private BuilderImpl(InstalledComponent model) {
            this.componentName(model.componentName);
            this.componentVersion(model.componentVersion);
            this.lifecycleState(model.lifecycleState);
            this.lifecycleStateDetails(model.lifecycleStateDetails);
            this.isRoot(model.isRoot);
        }

        public final String getComponentName() {
            return this.componentName;
        }

        public final void setComponentName(String componentName) {
            this.componentName = componentName;
        }

        @Override
        @Transient
        public final Builder componentName(String componentName) {
            this.componentName = componentName;
            return this;
        }

        public final String getComponentVersion() {
            return this.componentVersion;
        }

        public final void setComponentVersion(String componentVersion) {
            this.componentVersion = componentVersion;
        }

        @Override
        @Transient
        public final Builder componentVersion(String componentVersion) {
            this.componentVersion = componentVersion;
            return this;
        }

        public final String getLifecycleState() {
            return this.lifecycleState;
        }

        public final void setLifecycleState(String lifecycleState) {
            this.lifecycleState = lifecycleState;
        }

        @Override
        @Transient
        public final Builder lifecycleState(String lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        @Override
        @Transient
        public final Builder lifecycleState(InstalledComponentLifecycleState lifecycleState) {
            this.lifecycleState(lifecycleState == null ? null : lifecycleState.toString());
            return this;
        }

        public final String getLifecycleStateDetails() {
            return this.lifecycleStateDetails;
        }

        public final void setLifecycleStateDetails(String lifecycleStateDetails) {
            this.lifecycleStateDetails = lifecycleStateDetails;
        }

        @Override
        @Transient
        public final Builder lifecycleStateDetails(String lifecycleStateDetails) {
            this.lifecycleStateDetails = lifecycleStateDetails;
            return this;
        }

        public final Boolean getIsRoot() {
            return this.isRoot;
        }

        public final void setIsRoot(Boolean isRoot) {
            this.isRoot = isRoot;
        }

        @Override
        @Transient
        public final Builder isRoot(Boolean isRoot) {
            this.isRoot = isRoot;
            return this;
        }

        public InstalledComponent build() {
            return new InstalledComponent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstalledComponent> {
        public Builder componentName(String var1);

        public Builder componentVersion(String var1);

        public Builder lifecycleState(String var1);

        public Builder lifecycleState(InstalledComponentLifecycleState var1);

        public Builder lifecycleStateDetails(String var1);

        public Builder isRoot(Boolean var1);
    }
}

