/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrassv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the status of a component in the IoT Greengrass service.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CloudComponentStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<CloudComponentStatus.Builder, CloudComponentStatus> {
    private static final SdkField<String> COMPONENT_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("componentState").getter(getter(CloudComponentStatus::componentStateAsString))
            .setter(setter(Builder::componentState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentState").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("message")
            .getter(getter(CloudComponentStatus::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()).build();

    private static final SdkField<Map<String, String>> ERRORS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("errors")
            .getter(getter(CloudComponentStatus::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPONENT_STATE_FIELD,
            MESSAGE_FIELD, ERRORS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String componentState;

    private final String message;

    private final Map<String, String> errors;

    private CloudComponentStatus(BuilderImpl builder) {
        this.componentState = builder.componentState;
        this.message = builder.message;
        this.errors = builder.errors;
    }

    /**
     * <p>
     * The state of the component.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #componentState}
     * will return {@link CloudComponentState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #componentStateAsString}.
     * </p>
     * 
     * @return The state of the component.
     * @see CloudComponentState
     */
    public final CloudComponentState componentState() {
        return CloudComponentState.fromValue(componentState);
    }

    /**
     * <p>
     * The state of the component.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #componentState}
     * will return {@link CloudComponentState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #componentStateAsString}.
     * </p>
     * 
     * @return The state of the component.
     * @see CloudComponentState
     */
    public final String componentStateAsString() {
        return componentState;
    }

    /**
     * <p>
     * A message that communicates details, such as errors, about the status of the component.
     * </p>
     * 
     * @return A message that communicates details, such as errors, about the status of the component.
     */
    public final String message() {
        return message;
    }

    /**
     * For responses, this returns true if the service returned a value for the Errors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A dictionary of errors that communicate why the component is in an error state. For example, if IoT Greengrass
     * can't access an artifact for the component, then <code>errors</code> contains the artifact's URI as a key, and
     * the error message as the value for that key.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasErrors} method.
     * </p>
     * 
     * @return A dictionary of errors that communicate why the component is in an error state. For example, if IoT
     *         Greengrass can't access an artifact for the component, then <code>errors</code> contains the artifact's
     *         URI as a key, and the error message as the value for that key.
     */
    public final Map<String, String> errors() {
        return errors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(componentStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(hasErrors() ? errors() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudComponentStatus)) {
            return false;
        }
        CloudComponentStatus other = (CloudComponentStatus) obj;
        return Objects.equals(componentStateAsString(), other.componentStateAsString())
                && Objects.equals(message(), other.message()) && hasErrors() == other.hasErrors()
                && Objects.equals(errors(), other.errors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CloudComponentStatus").add("ComponentState", componentStateAsString()).add("Message", message())
                .add("Errors", hasErrors() ? errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "componentState":
            return Optional.ofNullable(clazz.cast(componentStateAsString()));
        case "message":
            return Optional.ofNullable(clazz.cast(message()));
        case "errors":
            return Optional.ofNullable(clazz.cast(errors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CloudComponentStatus, T> g) {
        return obj -> g.apply((CloudComponentStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CloudComponentStatus> {
        /**
         * <p>
         * The state of the component.
         * </p>
         * 
         * @param componentState
         *        The state of the component.
         * @see CloudComponentState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CloudComponentState
         */
        Builder componentState(String componentState);

        /**
         * <p>
         * The state of the component.
         * </p>
         * 
         * @param componentState
         *        The state of the component.
         * @see CloudComponentState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CloudComponentState
         */
        Builder componentState(CloudComponentState componentState);

        /**
         * <p>
         * A message that communicates details, such as errors, about the status of the component.
         * </p>
         * 
         * @param message
         *        A message that communicates details, such as errors, about the status of the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * A dictionary of errors that communicate why the component is in an error state. For example, if IoT
         * Greengrass can't access an artifact for the component, then <code>errors</code> contains the artifact's URI
         * as a key, and the error message as the value for that key.
         * </p>
         * 
         * @param errors
         *        A dictionary of errors that communicate why the component is in an error state. For example, if IoT
         *        Greengrass can't access an artifact for the component, then <code>errors</code> contains the
         *        artifact's URI as a key, and the error message as the value for that key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Map<String, String> errors);
    }

    static final class BuilderImpl implements Builder {
        private String componentState;

        private String message;

        private Map<String, String> errors = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CloudComponentStatus model) {
            componentState(model.componentState);
            message(model.message);
            errors(model.errors);
        }

        public final String getComponentState() {
            return componentState;
        }

        public final void setComponentState(String componentState) {
            this.componentState = componentState;
        }

        @Override
        public final Builder componentState(String componentState) {
            this.componentState = componentState;
            return this;
        }

        @Override
        public final Builder componentState(CloudComponentState componentState) {
            this.componentState(componentState == null ? null : componentState.toString());
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final Map<String, String> getErrors() {
            if (errors instanceof SdkAutoConstructMap) {
                return null;
            }
            return errors;
        }

        public final void setErrors(Map<String, String> errors) {
            this.errors = StringMapCopier.copy(errors);
        }

        @Override
        public final Builder errors(Map<String, String> errors) {
            this.errors = StringMapCopier.copy(errors);
            return this;
        }

        @Override
        public CloudComponentStatus build() {
            return new CloudComponentStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
