/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrassv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetComponentVersionArtifactRequest extends GreengrassV2Request implements
        ToCopyableBuilder<GetComponentVersionArtifactRequest.Builder, GetComponentVersionArtifactRequest> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(GetComponentVersionArtifactRequest::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("arn").build()).build();

    private static final SdkField<String> ARTIFACT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("artifactName").getter(getter(GetComponentVersionArtifactRequest::artifactName))
            .setter(setter(Builder::artifactName))
            .traits(LocationTrait.builder().location(MarshallLocation.GREEDY_PATH).locationName("artifactName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ARN_FIELD, ARTIFACT_NAME_FIELD));

    private final String arn;

    private final String artifactName;

    private GetComponentVersionArtifactRequest(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.artifactName = builder.artifactName;
    }

    /**
     * <p>
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the component
     * version. Specify the ARN of a public component version.
     * </p>
     * 
     * @return The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the
     *         component version. Specify the ARN of a public component version.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the artifact.
     * </p>
     * <p>
     * You can use the <a
     * href="https://docs.aws.amazon.com/greengrass/v2/APIReference/API_GetComponent.html">GetComponent</a> operation to
     * download the component recipe, which includes the URI of the artifact. The artifact name is the section of the
     * URI after the scheme. For example, in the artifact URI <code>greengrass:SomeArtifact.zip</code>, the artifact
     * name is <code>SomeArtifact.zip</code>.
     * </p>
     * 
     * @return The name of the artifact.</p>
     *         <p>
     *         You can use the <a
     *         href="https://docs.aws.amazon.com/greengrass/v2/APIReference/API_GetComponent.html">GetComponent</a>
     *         operation to download the component recipe, which includes the URI of the artifact. The artifact name is
     *         the section of the URI after the scheme. For example, in the artifact URI
     *         <code>greengrass:SomeArtifact.zip</code>, the artifact name is <code>SomeArtifact.zip</code>.
     */
    public final String artifactName() {
        return artifactName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(artifactName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetComponentVersionArtifactRequest)) {
            return false;
        }
        GetComponentVersionArtifactRequest other = (GetComponentVersionArtifactRequest) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(artifactName(), other.artifactName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetComponentVersionArtifactRequest").add("Arn", arn()).add("ArtifactName", artifactName())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "artifactName":
            return Optional.ofNullable(clazz.cast(artifactName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetComponentVersionArtifactRequest, T> g) {
        return obj -> g.apply((GetComponentVersionArtifactRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GreengrassV2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, GetComponentVersionArtifactRequest> {
        /**
         * <p>
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the
         * component version. Specify the ARN of a public component version.
         * </p>
         * 
         * @param arn
         *        The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of
         *        the component version. Specify the ARN of a public component version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the artifact.
         * </p>
         * <p>
         * You can use the <a
         * href="https://docs.aws.amazon.com/greengrass/v2/APIReference/API_GetComponent.html">GetComponent</a>
         * operation to download the component recipe, which includes the URI of the artifact. The artifact name is the
         * section of the URI after the scheme. For example, in the artifact URI
         * <code>greengrass:SomeArtifact.zip</code>, the artifact name is <code>SomeArtifact.zip</code>.
         * </p>
         * 
         * @param artifactName
         *        The name of the artifact.</p>
         *        <p>
         *        You can use the <a
         *        href="https://docs.aws.amazon.com/greengrass/v2/APIReference/API_GetComponent.html">GetComponent</a>
         *        operation to download the component recipe, which includes the URI of the artifact. The artifact name
         *        is the section of the URI after the scheme. For example, in the artifact URI
         *        <code>greengrass:SomeArtifact.zip</code>, the artifact name is <code>SomeArtifact.zip</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder artifactName(String artifactName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GreengrassV2Request.BuilderImpl implements Builder {
        private String arn;

        private String artifactName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetComponentVersionArtifactRequest model) {
            super(model);
            arn(model.arn);
            artifactName(model.artifactName);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getArtifactName() {
            return artifactName;
        }

        public final void setArtifactName(String artifactName) {
            this.artifactName = artifactName;
        }

        @Override
        public final Builder artifactName(String artifactName) {
            this.artifactName = artifactName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetComponentVersionArtifactRequest build() {
            return new GetComponentVersionArtifactRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
