/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrassv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a component on a Greengrass core device.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstalledComponent implements SdkPojo, Serializable,
        ToCopyableBuilder<InstalledComponent.Builder, InstalledComponent> {
    private static final SdkField<String> COMPONENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("componentName").getter(getter(InstalledComponent::componentName)).setter(setter(Builder::componentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentName").build()).build();

    private static final SdkField<String> COMPONENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("componentVersion").getter(getter(InstalledComponent::componentVersion))
            .setter(setter(Builder::componentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentVersion").build()).build();

    private static final SdkField<String> LIFECYCLE_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lifecycleState").getter(getter(InstalledComponent::lifecycleStateAsString))
            .setter(setter(Builder::lifecycleState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecycleState").build()).build();

    private static final SdkField<String> LIFECYCLE_STATE_DETAILS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lifecycleStateDetails").getter(getter(InstalledComponent::lifecycleStateDetails))
            .setter(setter(Builder::lifecycleStateDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecycleStateDetails").build())
            .build();

    private static final SdkField<Boolean> IS_ROOT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isRoot").getter(getter(InstalledComponent::isRoot)).setter(setter(Builder::isRoot))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isRoot").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPONENT_NAME_FIELD,
            COMPONENT_VERSION_FIELD, LIFECYCLE_STATE_FIELD, LIFECYCLE_STATE_DETAILS_FIELD, IS_ROOT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String componentName;

    private final String componentVersion;

    private final String lifecycleState;

    private final String lifecycleStateDetails;

    private final Boolean isRoot;

    private InstalledComponent(BuilderImpl builder) {
        this.componentName = builder.componentName;
        this.componentVersion = builder.componentVersion;
        this.lifecycleState = builder.lifecycleState;
        this.lifecycleStateDetails = builder.lifecycleStateDetails;
        this.isRoot = builder.isRoot;
    }

    /**
     * <p>
     * The name of the component.
     * </p>
     * 
     * @return The name of the component.
     */
    public final String componentName() {
        return componentName;
    }

    /**
     * <p>
     * The version of the component.
     * </p>
     * 
     * @return The version of the component.
     */
    public final String componentVersion() {
        return componentVersion;
    }

    /**
     * <p>
     * The lifecycle state of the component.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lifecycleState}
     * will return {@link InstalledComponentLifecycleState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #lifecycleStateAsString}.
     * </p>
     * 
     * @return The lifecycle state of the component.
     * @see InstalledComponentLifecycleState
     */
    public final InstalledComponentLifecycleState lifecycleState() {
        return InstalledComponentLifecycleState.fromValue(lifecycleState);
    }

    /**
     * <p>
     * The lifecycle state of the component.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lifecycleState}
     * will return {@link InstalledComponentLifecycleState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #lifecycleStateAsString}.
     * </p>
     * 
     * @return The lifecycle state of the component.
     * @see InstalledComponentLifecycleState
     */
    public final String lifecycleStateAsString() {
        return lifecycleState;
    }

    /**
     * <p>
     * The details about the lifecycle state of the component.
     * </p>
     * 
     * @return The details about the lifecycle state of the component.
     */
    public final String lifecycleStateDetails() {
        return lifecycleStateDetails;
    }

    /**
     * <p>
     * Whether or not the component is a root component.
     * </p>
     * 
     * @return Whether or not the component is a root component.
     */
    public final Boolean isRoot() {
        return isRoot;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(componentName());
        hashCode = 31 * hashCode + Objects.hashCode(componentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(lifecycleStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lifecycleStateDetails());
        hashCode = 31 * hashCode + Objects.hashCode(isRoot());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstalledComponent)) {
            return false;
        }
        InstalledComponent other = (InstalledComponent) obj;
        return Objects.equals(componentName(), other.componentName())
                && Objects.equals(componentVersion(), other.componentVersion())
                && Objects.equals(lifecycleStateAsString(), other.lifecycleStateAsString())
                && Objects.equals(lifecycleStateDetails(), other.lifecycleStateDetails())
                && Objects.equals(isRoot(), other.isRoot());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InstalledComponent").add("ComponentName", componentName())
                .add("ComponentVersion", componentVersion()).add("LifecycleState", lifecycleStateAsString())
                .add("LifecycleStateDetails", lifecycleStateDetails()).add("IsRoot", isRoot()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "componentName":
            return Optional.ofNullable(clazz.cast(componentName()));
        case "componentVersion":
            return Optional.ofNullable(clazz.cast(componentVersion()));
        case "lifecycleState":
            return Optional.ofNullable(clazz.cast(lifecycleStateAsString()));
        case "lifecycleStateDetails":
            return Optional.ofNullable(clazz.cast(lifecycleStateDetails()));
        case "isRoot":
            return Optional.ofNullable(clazz.cast(isRoot()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstalledComponent, T> g) {
        return obj -> g.apply((InstalledComponent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstalledComponent> {
        /**
         * <p>
         * The name of the component.
         * </p>
         * 
         * @param componentName
         *        The name of the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentName(String componentName);

        /**
         * <p>
         * The version of the component.
         * </p>
         * 
         * @param componentVersion
         *        The version of the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentVersion(String componentVersion);

        /**
         * <p>
         * The lifecycle state of the component.
         * </p>
         * 
         * @param lifecycleState
         *        The lifecycle state of the component.
         * @see InstalledComponentLifecycleState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstalledComponentLifecycleState
         */
        Builder lifecycleState(String lifecycleState);

        /**
         * <p>
         * The lifecycle state of the component.
         * </p>
         * 
         * @param lifecycleState
         *        The lifecycle state of the component.
         * @see InstalledComponentLifecycleState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstalledComponentLifecycleState
         */
        Builder lifecycleState(InstalledComponentLifecycleState lifecycleState);

        /**
         * <p>
         * The details about the lifecycle state of the component.
         * </p>
         * 
         * @param lifecycleStateDetails
         *        The details about the lifecycle state of the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycleStateDetails(String lifecycleStateDetails);

        /**
         * <p>
         * Whether or not the component is a root component.
         * </p>
         * 
         * @param isRoot
         *        Whether or not the component is a root component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isRoot(Boolean isRoot);
    }

    static final class BuilderImpl implements Builder {
        private String componentName;

        private String componentVersion;

        private String lifecycleState;

        private String lifecycleStateDetails;

        private Boolean isRoot;

        private BuilderImpl() {
        }

        private BuilderImpl(InstalledComponent model) {
            componentName(model.componentName);
            componentVersion(model.componentVersion);
            lifecycleState(model.lifecycleState);
            lifecycleStateDetails(model.lifecycleStateDetails);
            isRoot(model.isRoot);
        }

        public final String getComponentName() {
            return componentName;
        }

        public final void setComponentName(String componentName) {
            this.componentName = componentName;
        }

        @Override
        public final Builder componentName(String componentName) {
            this.componentName = componentName;
            return this;
        }

        public final String getComponentVersion() {
            return componentVersion;
        }

        public final void setComponentVersion(String componentVersion) {
            this.componentVersion = componentVersion;
        }

        @Override
        public final Builder componentVersion(String componentVersion) {
            this.componentVersion = componentVersion;
            return this;
        }

        public final String getLifecycleState() {
            return lifecycleState;
        }

        public final void setLifecycleState(String lifecycleState) {
            this.lifecycleState = lifecycleState;
        }

        @Override
        public final Builder lifecycleState(String lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        @Override
        public final Builder lifecycleState(InstalledComponentLifecycleState lifecycleState) {
            this.lifecycleState(lifecycleState == null ? null : lifecycleState.toString());
            return this;
        }

        public final String getLifecycleStateDetails() {
            return lifecycleStateDetails;
        }

        public final void setLifecycleStateDetails(String lifecycleStateDetails) {
            this.lifecycleStateDetails = lifecycleStateDetails;
        }

        @Override
        public final Builder lifecycleStateDetails(String lifecycleStateDetails) {
            this.lifecycleStateDetails = lifecycleStateDetails;
            return this;
        }

        public final Boolean getIsRoot() {
            return isRoot;
        }

        public final void setIsRoot(Boolean isRoot) {
            this.isRoot = isRoot;
        }

        @Override
        public final Builder isRoot(Boolean isRoot) {
            this.isRoot = isRoot;
            return this;
        }

        @Override
        public InstalledComponent build() {
            return new InstalledComponent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
