/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrassv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResolveComponentCandidatesResponse extends GreengrassV2Response implements
        ToCopyableBuilder<ResolveComponentCandidatesResponse.Builder, ResolveComponentCandidatesResponse> {
    private static final SdkField<List<ResolvedComponentVersion>> RESOLVED_COMPONENT_VERSIONS_FIELD = SdkField
            .<List<ResolvedComponentVersion>> builder(MarshallingType.LIST)
            .memberName("resolvedComponentVersions")
            .getter(getter(ResolveComponentCandidatesResponse::resolvedComponentVersions))
            .setter(setter(Builder::resolvedComponentVersions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resolvedComponentVersions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResolvedComponentVersion> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResolvedComponentVersion::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(RESOLVED_COMPONENT_VERSIONS_FIELD));

    private final List<ResolvedComponentVersion> resolvedComponentVersions;

    private ResolveComponentCandidatesResponse(BuilderImpl builder) {
        super(builder);
        this.resolvedComponentVersions = builder.resolvedComponentVersions;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResolvedComponentVersions property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasResolvedComponentVersions() {
        return resolvedComponentVersions != null && !(resolvedComponentVersions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of components that meet the requirements that you specify in the request. This list includes each
     * component's recipe that you can use to install the component.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResolvedComponentVersions} method.
     * </p>
     * 
     * @return A list of components that meet the requirements that you specify in the request. This list includes each
     *         component's recipe that you can use to install the component.
     */
    public final List<ResolvedComponentVersion> resolvedComponentVersions() {
        return resolvedComponentVersions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasResolvedComponentVersions() ? resolvedComponentVersions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResolveComponentCandidatesResponse)) {
            return false;
        }
        ResolveComponentCandidatesResponse other = (ResolveComponentCandidatesResponse) obj;
        return hasResolvedComponentVersions() == other.hasResolvedComponentVersions()
                && Objects.equals(resolvedComponentVersions(), other.resolvedComponentVersions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResolveComponentCandidatesResponse")
                .add("ResolvedComponentVersions", hasResolvedComponentVersions() ? resolvedComponentVersions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resolvedComponentVersions":
            return Optional.ofNullable(clazz.cast(resolvedComponentVersions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResolveComponentCandidatesResponse, T> g) {
        return obj -> g.apply((ResolveComponentCandidatesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GreengrassV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, ResolveComponentCandidatesResponse> {
        /**
         * <p>
         * A list of components that meet the requirements that you specify in the request. This list includes each
         * component's recipe that you can use to install the component.
         * </p>
         * 
         * @param resolvedComponentVersions
         *        A list of components that meet the requirements that you specify in the request. This list includes
         *        each component's recipe that you can use to install the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resolvedComponentVersions(Collection<ResolvedComponentVersion> resolvedComponentVersions);

        /**
         * <p>
         * A list of components that meet the requirements that you specify in the request. This list includes each
         * component's recipe that you can use to install the component.
         * </p>
         * 
         * @param resolvedComponentVersions
         *        A list of components that meet the requirements that you specify in the request. This list includes
         *        each component's recipe that you can use to install the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resolvedComponentVersions(ResolvedComponentVersion... resolvedComponentVersions);

        /**
         * <p>
         * A list of components that meet the requirements that you specify in the request. This list includes each
         * component's recipe that you can use to install the component.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<ResolvedComponentVersion>.Builder}
         * avoiding the need to create one manually via {@link List<ResolvedComponentVersion>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ResolvedComponentVersion>.Builder#build()} is called
         * immediately and its result is passed to {@link #resolvedComponentVersions(List<ResolvedComponentVersion>)}.
         * 
         * @param resolvedComponentVersions
         *        a consumer that will call methods on {@link List<ResolvedComponentVersion>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resolvedComponentVersions(List<ResolvedComponentVersion>)
         */
        Builder resolvedComponentVersions(Consumer<ResolvedComponentVersion.Builder>... resolvedComponentVersions);
    }

    static final class BuilderImpl extends GreengrassV2Response.BuilderImpl implements Builder {
        private List<ResolvedComponentVersion> resolvedComponentVersions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ResolveComponentCandidatesResponse model) {
            super(model);
            resolvedComponentVersions(model.resolvedComponentVersions);
        }

        public final List<ResolvedComponentVersion.Builder> getResolvedComponentVersions() {
            List<ResolvedComponentVersion.Builder> result = ResolvedComponentVersionsListCopier
                    .copyToBuilder(this.resolvedComponentVersions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResolvedComponentVersions(Collection<ResolvedComponentVersion.BuilderImpl> resolvedComponentVersions) {
            this.resolvedComponentVersions = ResolvedComponentVersionsListCopier.copyFromBuilder(resolvedComponentVersions);
        }

        @Override
        public final Builder resolvedComponentVersions(Collection<ResolvedComponentVersion> resolvedComponentVersions) {
            this.resolvedComponentVersions = ResolvedComponentVersionsListCopier.copy(resolvedComponentVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resolvedComponentVersions(ResolvedComponentVersion... resolvedComponentVersions) {
            resolvedComponentVersions(Arrays.asList(resolvedComponentVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resolvedComponentVersions(Consumer<ResolvedComponentVersion.Builder>... resolvedComponentVersions) {
            resolvedComponentVersions(Stream.of(resolvedComponentVersions)
                    .map(c -> ResolvedComponentVersion.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ResolveComponentCandidatesResponse build() {
            return new ResolveComponentCandidatesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
