/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrassv2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDeploymentRequest extends GreengrassV2Request implements
        ToCopyableBuilder<CreateDeploymentRequest.Builder, CreateDeploymentRequest> {
    private static final SdkField<String> TARGET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetArn").getter(getter(CreateDeploymentRequest::targetArn)).setter(setter(Builder::targetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetArn").build()).build();

    private static final SdkField<String> DEPLOYMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deploymentName").getter(getter(CreateDeploymentRequest::deploymentName))
            .setter(setter(Builder::deploymentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentName").build()).build();

    private static final SdkField<Map<String, ComponentDeploymentSpecification>> COMPONENTS_FIELD = SdkField
            .<Map<String, ComponentDeploymentSpecification>> builder(MarshallingType.MAP)
            .memberName("components")
            .getter(getter(CreateDeploymentRequest::components))
            .setter(setter(Builder::components))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("components").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<ComponentDeploymentSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(ComponentDeploymentSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<DeploymentIoTJobConfiguration> IOT_JOB_CONFIGURATION_FIELD = SdkField
            .<DeploymentIoTJobConfiguration> builder(MarshallingType.SDK_POJO).memberName("iotJobConfiguration")
            .getter(getter(CreateDeploymentRequest::iotJobConfiguration)).setter(setter(Builder::iotJobConfiguration))
            .constructor(DeploymentIoTJobConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iotJobConfiguration").build())
            .build();

    private static final SdkField<DeploymentPolicies> DEPLOYMENT_POLICIES_FIELD = SdkField
            .<DeploymentPolicies> builder(MarshallingType.SDK_POJO).memberName("deploymentPolicies")
            .getter(getter(CreateDeploymentRequest::deploymentPolicies)).setter(setter(Builder::deploymentPolicies))
            .constructor(DeploymentPolicies::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentPolicies").build())
            .build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateDeploymentRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateDeploymentRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_ARN_FIELD,
            DEPLOYMENT_NAME_FIELD, COMPONENTS_FIELD, IOT_JOB_CONFIGURATION_FIELD, DEPLOYMENT_POLICIES_FIELD, TAGS_FIELD,
            CLIENT_TOKEN_FIELD));

    private final String targetArn;

    private final String deploymentName;

    private final Map<String, ComponentDeploymentSpecification> components;

    private final DeploymentIoTJobConfiguration iotJobConfiguration;

    private final DeploymentPolicies deploymentPolicies;

    private final Map<String, String> tags;

    private final String clientToken;

    private CreateDeploymentRequest(BuilderImpl builder) {
        super(builder);
        this.targetArn = builder.targetArn;
        this.deploymentName = builder.deploymentName;
        this.components = builder.components;
        this.iotJobConfiguration = builder.iotJobConfiguration;
        this.deploymentPolicies = builder.deploymentPolicies;
        this.tags = builder.tags;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the target
     * IoT thing or thing group.
     * </p>
     * 
     * @return The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the
     *         target IoT thing or thing group.
     */
    public final String targetArn() {
        return targetArn;
    }

    /**
     * <p>
     * The name of the deployment.
     * </p>
     * 
     * @return The name of the deployment.
     */
    public final String deploymentName() {
        return deploymentName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Components property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasComponents() {
        return components != null && !(components instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The components to deploy. This is a dictionary, where each key is the name of a component, and each key's value
     * is the version and configuration to deploy for that component.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasComponents} method.
     * </p>
     * 
     * @return The components to deploy. This is a dictionary, where each key is the name of a component, and each key's
     *         value is the version and configuration to deploy for that component.
     */
    public final Map<String, ComponentDeploymentSpecification> components() {
        return components;
    }

    /**
     * <p>
     * The job configuration for the deployment configuration. The job configuration specifies the rollout, timeout, and
     * stop configurations for the deployment configuration.
     * </p>
     * 
     * @return The job configuration for the deployment configuration. The job configuration specifies the rollout,
     *         timeout, and stop configurations for the deployment configuration.
     */
    public final DeploymentIoTJobConfiguration iotJobConfiguration() {
        return iotJobConfiguration;
    }

    /**
     * <p>
     * The deployment policies for the deployment. These policies define how the deployment updates components and
     * handles failure.
     * </p>
     * 
     * @return The deployment policies for the deployment. These policies define how the deployment updates components
     *         and handles failure.
     */
    public final DeploymentPolicies deploymentPolicies() {
        return deploymentPolicies;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of key-value pairs that contain metadata for the resource. For more information, see <a
     * href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your resources</a> in the
     * <i>IoT Greengrass V2 Developer Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of key-value pairs that contain metadata for the resource. For more information, see <a
     *         href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your resources</a>
     *         in the <i>IoT Greengrass V2 Developer Guide</i>.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you can provide to ensure that the request is idempotent. Idempotency
     * means that the request is successfully processed only once, even if you send the request multiple times. When a
     * request succeeds, and you specify the same client token for subsequent successful requests, the IoT Greengrass V2
     * service returns the successful response that it caches from the previous request. IoT Greengrass V2 caches
     * successful responses for idempotent requests for up to 8 hours.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you can provide to ensure that the request is idempotent.
     *         Idempotency means that the request is successfully processed only once, even if you send the request
     *         multiple times. When a request succeeds, and you specify the same client token for subsequent successful
     *         requests, the IoT Greengrass V2 service returns the successful response that it caches from the previous
     *         request. IoT Greengrass V2 caches successful responses for idempotent requests for up to 8 hours.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(targetArn());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentName());
        hashCode = 31 * hashCode + Objects.hashCode(hasComponents() ? components() : null);
        hashCode = 31 * hashCode + Objects.hashCode(iotJobConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentPolicies());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDeploymentRequest)) {
            return false;
        }
        CreateDeploymentRequest other = (CreateDeploymentRequest) obj;
        return Objects.equals(targetArn(), other.targetArn()) && Objects.equals(deploymentName(), other.deploymentName())
                && hasComponents() == other.hasComponents() && Objects.equals(components(), other.components())
                && Objects.equals(iotJobConfiguration(), other.iotJobConfiguration())
                && Objects.equals(deploymentPolicies(), other.deploymentPolicies()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDeploymentRequest").add("TargetArn", targetArn()).add("DeploymentName", deploymentName())
                .add("Components", hasComponents() ? components() : null).add("IotJobConfiguration", iotJobConfiguration())
                .add("DeploymentPolicies", deploymentPolicies()).add("Tags", hasTags() ? tags() : null)
                .add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "targetArn":
            return Optional.ofNullable(clazz.cast(targetArn()));
        case "deploymentName":
            return Optional.ofNullable(clazz.cast(deploymentName()));
        case "components":
            return Optional.ofNullable(clazz.cast(components()));
        case "iotJobConfiguration":
            return Optional.ofNullable(clazz.cast(iotJobConfiguration()));
        case "deploymentPolicies":
            return Optional.ofNullable(clazz.cast(deploymentPolicies()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDeploymentRequest, T> g) {
        return obj -> g.apply((CreateDeploymentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GreengrassV2Request.Builder, SdkPojo, CopyableBuilder<Builder, CreateDeploymentRequest> {
        /**
         * <p>
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the
         * target IoT thing or thing group.
         * </p>
         * 
         * @param targetArn
         *        The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of
         *        the target IoT thing or thing group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetArn(String targetArn);

        /**
         * <p>
         * The name of the deployment.
         * </p>
         * 
         * @param deploymentName
         *        The name of the deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentName(String deploymentName);

        /**
         * <p>
         * The components to deploy. This is a dictionary, where each key is the name of a component, and each key's
         * value is the version and configuration to deploy for that component.
         * </p>
         * 
         * @param components
         *        The components to deploy. This is a dictionary, where each key is the name of a component, and each
         *        key's value is the version and configuration to deploy for that component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder components(Map<String, ComponentDeploymentSpecification> components);

        /**
         * <p>
         * The job configuration for the deployment configuration. The job configuration specifies the rollout, timeout,
         * and stop configurations for the deployment configuration.
         * </p>
         * 
         * @param iotJobConfiguration
         *        The job configuration for the deployment configuration. The job configuration specifies the rollout,
         *        timeout, and stop configurations for the deployment configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iotJobConfiguration(DeploymentIoTJobConfiguration iotJobConfiguration);

        /**
         * <p>
         * The job configuration for the deployment configuration. The job configuration specifies the rollout, timeout,
         * and stop configurations for the deployment configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link DeploymentIoTJobConfiguration.Builder} avoiding
         * the need to create one manually via {@link DeploymentIoTJobConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link DeploymentIoTJobConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #iotJobConfiguration(DeploymentIoTJobConfiguration)}.
         * 
         * @param iotJobConfiguration
         *        a consumer that will call methods on {@link DeploymentIoTJobConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #iotJobConfiguration(DeploymentIoTJobConfiguration)
         */
        default Builder iotJobConfiguration(Consumer<DeploymentIoTJobConfiguration.Builder> iotJobConfiguration) {
            return iotJobConfiguration(DeploymentIoTJobConfiguration.builder().applyMutation(iotJobConfiguration).build());
        }

        /**
         * <p>
         * The deployment policies for the deployment. These policies define how the deployment updates components and
         * handles failure.
         * </p>
         * 
         * @param deploymentPolicies
         *        The deployment policies for the deployment. These policies define how the deployment updates
         *        components and handles failure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentPolicies(DeploymentPolicies deploymentPolicies);

        /**
         * <p>
         * The deployment policies for the deployment. These policies define how the deployment updates components and
         * handles failure.
         * </p>
         * This is a convenience that creates an instance of the {@link DeploymentPolicies.Builder} avoiding the need to
         * create one manually via {@link DeploymentPolicies#builder()}.
         *
         * When the {@link Consumer} completes, {@link DeploymentPolicies.Builder#build()} is called immediately and its
         * result is passed to {@link #deploymentPolicies(DeploymentPolicies)}.
         * 
         * @param deploymentPolicies
         *        a consumer that will call methods on {@link DeploymentPolicies.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deploymentPolicies(DeploymentPolicies)
         */
        default Builder deploymentPolicies(Consumer<DeploymentPolicies.Builder> deploymentPolicies) {
            return deploymentPolicies(DeploymentPolicies.builder().applyMutation(deploymentPolicies).build());
        }

        /**
         * <p>
         * A list of key-value pairs that contain metadata for the resource. For more information, see <a
         * href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your resources</a> in
         * the <i>IoT Greengrass V2 Developer Guide</i>.
         * </p>
         * 
         * @param tags
         *        A list of key-value pairs that contain metadata for the resource. For more information, see <a
         *        href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your
         *        resources</a> in the <i>IoT Greengrass V2 Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * A unique, case-sensitive identifier that you can provide to ensure that the request is idempotent.
         * Idempotency means that the request is successfully processed only once, even if you send the request multiple
         * times. When a request succeeds, and you specify the same client token for subsequent successful requests, the
         * IoT Greengrass V2 service returns the successful response that it caches from the previous request. IoT
         * Greengrass V2 caches successful responses for idempotent requests for up to 8 hours.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you can provide to ensure that the request is idempotent.
         *        Idempotency means that the request is successfully processed only once, even if you send the request
         *        multiple times. When a request succeeds, and you specify the same client token for subsequent
         *        successful requests, the IoT Greengrass V2 service returns the successful response that it caches from
         *        the previous request. IoT Greengrass V2 caches successful responses for idempotent requests for up to
         *        8 hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GreengrassV2Request.BuilderImpl implements Builder {
        private String targetArn;

        private String deploymentName;

        private Map<String, ComponentDeploymentSpecification> components = DefaultSdkAutoConstructMap.getInstance();

        private DeploymentIoTJobConfiguration iotJobConfiguration;

        private DeploymentPolicies deploymentPolicies;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDeploymentRequest model) {
            super(model);
            targetArn(model.targetArn);
            deploymentName(model.deploymentName);
            components(model.components);
            iotJobConfiguration(model.iotJobConfiguration);
            deploymentPolicies(model.deploymentPolicies);
            tags(model.tags);
            clientToken(model.clientToken);
        }

        public final String getTargetArn() {
            return targetArn;
        }

        public final void setTargetArn(String targetArn) {
            this.targetArn = targetArn;
        }

        @Override
        @Transient
        public final Builder targetArn(String targetArn) {
            this.targetArn = targetArn;
            return this;
        }

        public final String getDeploymentName() {
            return deploymentName;
        }

        public final void setDeploymentName(String deploymentName) {
            this.deploymentName = deploymentName;
        }

        @Override
        @Transient
        public final Builder deploymentName(String deploymentName) {
            this.deploymentName = deploymentName;
            return this;
        }

        public final Map<String, ComponentDeploymentSpecification.Builder> getComponents() {
            Map<String, ComponentDeploymentSpecification.Builder> result = ComponentDeploymentSpecificationsCopier
                    .copyToBuilder(this.components);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setComponents(Map<String, ComponentDeploymentSpecification.BuilderImpl> components) {
            this.components = ComponentDeploymentSpecificationsCopier.copyFromBuilder(components);
        }

        @Override
        @Transient
        public final Builder components(Map<String, ComponentDeploymentSpecification> components) {
            this.components = ComponentDeploymentSpecificationsCopier.copy(components);
            return this;
        }

        public final DeploymentIoTJobConfiguration.Builder getIotJobConfiguration() {
            return iotJobConfiguration != null ? iotJobConfiguration.toBuilder() : null;
        }

        public final void setIotJobConfiguration(DeploymentIoTJobConfiguration.BuilderImpl iotJobConfiguration) {
            this.iotJobConfiguration = iotJobConfiguration != null ? iotJobConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder iotJobConfiguration(DeploymentIoTJobConfiguration iotJobConfiguration) {
            this.iotJobConfiguration = iotJobConfiguration;
            return this;
        }

        public final DeploymentPolicies.Builder getDeploymentPolicies() {
            return deploymentPolicies != null ? deploymentPolicies.toBuilder() : null;
        }

        public final void setDeploymentPolicies(DeploymentPolicies.BuilderImpl deploymentPolicies) {
            this.deploymentPolicies = deploymentPolicies != null ? deploymentPolicies.build() : null;
        }

        @Override
        @Transient
        public final Builder deploymentPolicies(DeploymentPolicies deploymentPolicies) {
            this.deploymentPolicies = deploymentPolicies;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        @Transient
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDeploymentRequest build() {
            return new CreateDeploymentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
