/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrassv2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a deployment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Deployment implements SdkPojo, Serializable, ToCopyableBuilder<Deployment.Builder, Deployment> {
    private static final SdkField<String> TARGET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetArn").getter(getter(Deployment::targetArn)).setter(setter(Builder::targetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetArn").build()).build();

    private static final SdkField<String> REVISION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("revisionId").getter(getter(Deployment::revisionId)).setter(setter(Builder::revisionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revisionId").build()).build();

    private static final SdkField<String> DEPLOYMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deploymentId").getter(getter(Deployment::deploymentId)).setter(setter(Builder::deploymentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentId").build()).build();

    private static final SdkField<String> DEPLOYMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deploymentName").getter(getter(Deployment::deploymentName)).setter(setter(Builder::deploymentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentName").build()).build();

    private static final SdkField<Instant> CREATION_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTimestamp").getter(getter(Deployment::creationTimestamp))
            .setter(setter(Builder::creationTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTimestamp").build()).build();

    private static final SdkField<String> DEPLOYMENT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deploymentStatus").getter(getter(Deployment::deploymentStatusAsString))
            .setter(setter(Builder::deploymentStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentStatus").build()).build();

    private static final SdkField<Boolean> IS_LATEST_FOR_TARGET_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isLatestForTarget").getter(getter(Deployment::isLatestForTarget))
            .setter(setter(Builder::isLatestForTarget))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isLatestForTarget").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_ARN_FIELD,
            REVISION_ID_FIELD, DEPLOYMENT_ID_FIELD, DEPLOYMENT_NAME_FIELD, CREATION_TIMESTAMP_FIELD, DEPLOYMENT_STATUS_FIELD,
            IS_LATEST_FOR_TARGET_FIELD));

    private static final long serialVersionUID = 1L;

    private final String targetArn;

    private final String revisionId;

    private final String deploymentId;

    private final String deploymentName;

    private final Instant creationTimestamp;

    private final String deploymentStatus;

    private final Boolean isLatestForTarget;

    private Deployment(BuilderImpl builder) {
        this.targetArn = builder.targetArn;
        this.revisionId = builder.revisionId;
        this.deploymentId = builder.deploymentId;
        this.deploymentName = builder.deploymentName;
        this.creationTimestamp = builder.creationTimestamp;
        this.deploymentStatus = builder.deploymentStatus;
        this.isLatestForTarget = builder.isLatestForTarget;
    }

    /**
     * <p>
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the target
     * IoT thing or thing group.
     * </p>
     * 
     * @return The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the
     *         target IoT thing or thing group.
     */
    public final String targetArn() {
        return targetArn;
    }

    /**
     * <p>
     * The revision number of the deployment.
     * </p>
     * 
     * @return The revision number of the deployment.
     */
    public final String revisionId() {
        return revisionId;
    }

    /**
     * <p>
     * The ID of the deployment.
     * </p>
     * 
     * @return The ID of the deployment.
     */
    public final String deploymentId() {
        return deploymentId;
    }

    /**
     * <p>
     * The name of the deployment.
     * </p>
     * 
     * @return The name of the deployment.
     */
    public final String deploymentName() {
        return deploymentName;
    }

    /**
     * <p>
     * The time at which the deployment was created, expressed in ISO 8601 format.
     * </p>
     * 
     * @return The time at which the deployment was created, expressed in ISO 8601 format.
     */
    public final Instant creationTimestamp() {
        return creationTimestamp;
    }

    /**
     * <p>
     * The status of the deployment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deploymentStatus}
     * will return {@link DeploymentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #deploymentStatusAsString}.
     * </p>
     * 
     * @return The status of the deployment.
     * @see DeploymentStatus
     */
    public final DeploymentStatus deploymentStatus() {
        return DeploymentStatus.fromValue(deploymentStatus);
    }

    /**
     * <p>
     * The status of the deployment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deploymentStatus}
     * will return {@link DeploymentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #deploymentStatusAsString}.
     * </p>
     * 
     * @return The status of the deployment.
     * @see DeploymentStatus
     */
    public final String deploymentStatusAsString() {
        return deploymentStatus;
    }

    /**
     * <p>
     * Whether or not the deployment is the latest revision for its target.
     * </p>
     * 
     * @return Whether or not the deployment is the latest revision for its target.
     */
    public final Boolean isLatestForTarget() {
        return isLatestForTarget;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(targetArn());
        hashCode = 31 * hashCode + Objects.hashCode(revisionId());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentName());
        hashCode = 31 * hashCode + Objects.hashCode(creationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(isLatestForTarget());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Deployment)) {
            return false;
        }
        Deployment other = (Deployment) obj;
        return Objects.equals(targetArn(), other.targetArn()) && Objects.equals(revisionId(), other.revisionId())
                && Objects.equals(deploymentId(), other.deploymentId())
                && Objects.equals(deploymentName(), other.deploymentName())
                && Objects.equals(creationTimestamp(), other.creationTimestamp())
                && Objects.equals(deploymentStatusAsString(), other.deploymentStatusAsString())
                && Objects.equals(isLatestForTarget(), other.isLatestForTarget());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Deployment").add("TargetArn", targetArn()).add("RevisionId", revisionId())
                .add("DeploymentId", deploymentId()).add("DeploymentName", deploymentName())
                .add("CreationTimestamp", creationTimestamp()).add("DeploymentStatus", deploymentStatusAsString())
                .add("IsLatestForTarget", isLatestForTarget()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "targetArn":
            return Optional.ofNullable(clazz.cast(targetArn()));
        case "revisionId":
            return Optional.ofNullable(clazz.cast(revisionId()));
        case "deploymentId":
            return Optional.ofNullable(clazz.cast(deploymentId()));
        case "deploymentName":
            return Optional.ofNullable(clazz.cast(deploymentName()));
        case "creationTimestamp":
            return Optional.ofNullable(clazz.cast(creationTimestamp()));
        case "deploymentStatus":
            return Optional.ofNullable(clazz.cast(deploymentStatusAsString()));
        case "isLatestForTarget":
            return Optional.ofNullable(clazz.cast(isLatestForTarget()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Deployment, T> g) {
        return obj -> g.apply((Deployment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Deployment> {
        /**
         * <p>
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the
         * target IoT thing or thing group.
         * </p>
         * 
         * @param targetArn
         *        The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of
         *        the target IoT thing or thing group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetArn(String targetArn);

        /**
         * <p>
         * The revision number of the deployment.
         * </p>
         * 
         * @param revisionId
         *        The revision number of the deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisionId(String revisionId);

        /**
         * <p>
         * The ID of the deployment.
         * </p>
         * 
         * @param deploymentId
         *        The ID of the deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentId(String deploymentId);

        /**
         * <p>
         * The name of the deployment.
         * </p>
         * 
         * @param deploymentName
         *        The name of the deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentName(String deploymentName);

        /**
         * <p>
         * The time at which the deployment was created, expressed in ISO 8601 format.
         * </p>
         * 
         * @param creationTimestamp
         *        The time at which the deployment was created, expressed in ISO 8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimestamp(Instant creationTimestamp);

        /**
         * <p>
         * The status of the deployment.
         * </p>
         * 
         * @param deploymentStatus
         *        The status of the deployment.
         * @see DeploymentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentStatus
         */
        Builder deploymentStatus(String deploymentStatus);

        /**
         * <p>
         * The status of the deployment.
         * </p>
         * 
         * @param deploymentStatus
         *        The status of the deployment.
         * @see DeploymentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentStatus
         */
        Builder deploymentStatus(DeploymentStatus deploymentStatus);

        /**
         * <p>
         * Whether or not the deployment is the latest revision for its target.
         * </p>
         * 
         * @param isLatestForTarget
         *        Whether or not the deployment is the latest revision for its target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isLatestForTarget(Boolean isLatestForTarget);
    }

    static final class BuilderImpl implements Builder {
        private String targetArn;

        private String revisionId;

        private String deploymentId;

        private String deploymentName;

        private Instant creationTimestamp;

        private String deploymentStatus;

        private Boolean isLatestForTarget;

        private BuilderImpl() {
        }

        private BuilderImpl(Deployment model) {
            targetArn(model.targetArn);
            revisionId(model.revisionId);
            deploymentId(model.deploymentId);
            deploymentName(model.deploymentName);
            creationTimestamp(model.creationTimestamp);
            deploymentStatus(model.deploymentStatus);
            isLatestForTarget(model.isLatestForTarget);
        }

        public final String getTargetArn() {
            return targetArn;
        }

        public final void setTargetArn(String targetArn) {
            this.targetArn = targetArn;
        }

        @Override
        @Transient
        public final Builder targetArn(String targetArn) {
            this.targetArn = targetArn;
            return this;
        }

        public final String getRevisionId() {
            return revisionId;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        @Override
        @Transient
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        public final String getDeploymentId() {
            return deploymentId;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        @Override
        @Transient
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final String getDeploymentName() {
            return deploymentName;
        }

        public final void setDeploymentName(String deploymentName) {
            this.deploymentName = deploymentName;
        }

        @Override
        @Transient
        public final Builder deploymentName(String deploymentName) {
            this.deploymentName = deploymentName;
            return this;
        }

        public final Instant getCreationTimestamp() {
            return creationTimestamp;
        }

        public final void setCreationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
        }

        @Override
        @Transient
        public final Builder creationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public final String getDeploymentStatus() {
            return deploymentStatus;
        }

        public final void setDeploymentStatus(String deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
        }

        @Override
        @Transient
        public final Builder deploymentStatus(String deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder deploymentStatus(DeploymentStatus deploymentStatus) {
            this.deploymentStatus(deploymentStatus == null ? null : deploymentStatus.toString());
            return this;
        }

        public final Boolean getIsLatestForTarget() {
            return isLatestForTarget;
        }

        public final void setIsLatestForTarget(Boolean isLatestForTarget) {
            this.isLatestForTarget = isLatestForTarget;
        }

        @Override
        @Transient
        public final Builder isLatestForTarget(Boolean isLatestForTarget) {
            this.isLatestForTarget = isLatestForTarget;
            return this;
        }

        @Override
        public Deployment build() {
            return new Deployment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
