/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrassv2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains an error that occurs from a request to disassociate a client device from a core device. The <a
 * href="https://docs.aws.amazon.com/greengrass/v2/APIReference/API_BatchDisassociateClientDeviceWithCoreDevice.html"
 * >BatchDisassociateClientDeviceWithCoreDevice</a> operation returns a list of these errors.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisassociateClientDeviceFromCoreDeviceErrorEntry
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<DisassociateClientDeviceFromCoreDeviceErrorEntry.Builder, DisassociateClientDeviceFromCoreDeviceErrorEntry> {
    private static final SdkField<String> THING_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("thingName").getter(getter(DisassociateClientDeviceFromCoreDeviceErrorEntry::thingName))
            .setter(setter(Builder::thingName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingName").build()).build();

    private static final SdkField<String> CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("code")
            .getter(getter(DisassociateClientDeviceFromCoreDeviceErrorEntry::code)).setter(setter(Builder::code))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("code").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("message")
            .getter(getter(DisassociateClientDeviceFromCoreDeviceErrorEntry::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THING_NAME_FIELD, CODE_FIELD,
            MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String thingName;

    private final String code;

    private final String message;

    private DisassociateClientDeviceFromCoreDeviceErrorEntry(BuilderImpl builder) {
        this.thingName = builder.thingName;
        this.code = builder.code;
        this.message = builder.message;
    }

    /**
     * <p>
     * The name of the IoT thing whose disassociate request failed.
     * </p>
     * 
     * @return The name of the IoT thing whose disassociate request failed.
     */
    public final String thingName() {
        return thingName;
    }

    /**
     * <p>
     * The error code for the request.
     * </p>
     * 
     * @return The error code for the request.
     */
    public final String code() {
        return code;
    }

    /**
     * <p>
     * A message that provides additional information about the error.
     * </p>
     * 
     * @return A message that provides additional information about the error.
     */
    public final String message() {
        return message;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(thingName());
        hashCode = 31 * hashCode + Objects.hashCode(code());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateClientDeviceFromCoreDeviceErrorEntry)) {
            return false;
        }
        DisassociateClientDeviceFromCoreDeviceErrorEntry other = (DisassociateClientDeviceFromCoreDeviceErrorEntry) obj;
        return Objects.equals(thingName(), other.thingName()) && Objects.equals(code(), other.code())
                && Objects.equals(message(), other.message());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DisassociateClientDeviceFromCoreDeviceErrorEntry").add("ThingName", thingName())
                .add("Code", code()).add("Message", message()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "thingName":
            return Optional.ofNullable(clazz.cast(thingName()));
        case "code":
            return Optional.ofNullable(clazz.cast(code()));
        case "message":
            return Optional.ofNullable(clazz.cast(message()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DisassociateClientDeviceFromCoreDeviceErrorEntry, T> g) {
        return obj -> g.apply((DisassociateClientDeviceFromCoreDeviceErrorEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DisassociateClientDeviceFromCoreDeviceErrorEntry> {
        /**
         * <p>
         * The name of the IoT thing whose disassociate request failed.
         * </p>
         * 
         * @param thingName
         *        The name of the IoT thing whose disassociate request failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingName(String thingName);

        /**
         * <p>
         * The error code for the request.
         * </p>
         * 
         * @param code
         *        The error code for the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder code(String code);

        /**
         * <p>
         * A message that provides additional information about the error.
         * </p>
         * 
         * @param message
         *        A message that provides additional information about the error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);
    }

    static final class BuilderImpl implements Builder {
        private String thingName;

        private String code;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateClientDeviceFromCoreDeviceErrorEntry model) {
            thingName(model.thingName);
            code(model.code);
            message(model.message);
        }

        public final String getThingName() {
            return thingName;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        @Override
        @Transient
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        public final String getCode() {
            return code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        @Transient
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        @Transient
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public DisassociateClientDeviceFromCoreDeviceErrorEntry build() {
            return new DisassociateClientDeviceFromCoreDeviceErrorEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
