/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrassv2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about an exponential rollout rate for a configuration deployment job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IoTJobExponentialRolloutRate implements SdkPojo, Serializable,
        ToCopyableBuilder<IoTJobExponentialRolloutRate.Builder, IoTJobExponentialRolloutRate> {
    private static final SdkField<Integer> BASE_RATE_PER_MINUTE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("baseRatePerMinute").getter(getter(IoTJobExponentialRolloutRate::baseRatePerMinute))
            .setter(setter(Builder::baseRatePerMinute))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baseRatePerMinute").build()).build();

    private static final SdkField<Double> INCREMENT_FACTOR_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("incrementFactor").getter(getter(IoTJobExponentialRolloutRate::incrementFactor))
            .setter(setter(Builder::incrementFactor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("incrementFactor").build()).build();

    private static final SdkField<IoTJobRateIncreaseCriteria> RATE_INCREASE_CRITERIA_FIELD = SdkField
            .<IoTJobRateIncreaseCriteria> builder(MarshallingType.SDK_POJO).memberName("rateIncreaseCriteria")
            .getter(getter(IoTJobExponentialRolloutRate::rateIncreaseCriteria)).setter(setter(Builder::rateIncreaseCriteria))
            .constructor(IoTJobRateIncreaseCriteria::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rateIncreaseCriteria").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASE_RATE_PER_MINUTE_FIELD,
            INCREMENT_FACTOR_FIELD, RATE_INCREASE_CRITERIA_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer baseRatePerMinute;

    private final Double incrementFactor;

    private final IoTJobRateIncreaseCriteria rateIncreaseCriteria;

    private IoTJobExponentialRolloutRate(BuilderImpl builder) {
        this.baseRatePerMinute = builder.baseRatePerMinute;
        this.incrementFactor = builder.incrementFactor;
        this.rateIncreaseCriteria = builder.rateIncreaseCriteria;
    }

    /**
     * <p>
     * The minimum number of devices that receive a pending job notification, per minute, when the job starts. This
     * parameter defines the initial rollout rate of the job.
     * </p>
     * 
     * @return The minimum number of devices that receive a pending job notification, per minute, when the job starts.
     *         This parameter defines the initial rollout rate of the job.
     */
    public final Integer baseRatePerMinute() {
        return baseRatePerMinute;
    }

    /**
     * <p>
     * The exponential factor to increase the rollout rate for the job.
     * </p>
     * <p>
     * This parameter supports up to one digit after the decimal (for example, you can specify <code>1.5</code>, but not
     * <code>1.55</code>).
     * </p>
     * 
     * @return The exponential factor to increase the rollout rate for the job.</p>
     *         <p>
     *         This parameter supports up to one digit after the decimal (for example, you can specify <code>1.5</code>,
     *         but not <code>1.55</code>).
     */
    public final Double incrementFactor() {
        return incrementFactor;
    }

    /**
     * <p>
     * The criteria to increase the rollout rate for the job.
     * </p>
     * 
     * @return The criteria to increase the rollout rate for the job.
     */
    public final IoTJobRateIncreaseCriteria rateIncreaseCriteria() {
        return rateIncreaseCriteria;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(baseRatePerMinute());
        hashCode = 31 * hashCode + Objects.hashCode(incrementFactor());
        hashCode = 31 * hashCode + Objects.hashCode(rateIncreaseCriteria());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IoTJobExponentialRolloutRate)) {
            return false;
        }
        IoTJobExponentialRolloutRate other = (IoTJobExponentialRolloutRate) obj;
        return Objects.equals(baseRatePerMinute(), other.baseRatePerMinute())
                && Objects.equals(incrementFactor(), other.incrementFactor())
                && Objects.equals(rateIncreaseCriteria(), other.rateIncreaseCriteria());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IoTJobExponentialRolloutRate").add("BaseRatePerMinute", baseRatePerMinute())
                .add("IncrementFactor", incrementFactor()).add("RateIncreaseCriteria", rateIncreaseCriteria()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "baseRatePerMinute":
            return Optional.ofNullable(clazz.cast(baseRatePerMinute()));
        case "incrementFactor":
            return Optional.ofNullable(clazz.cast(incrementFactor()));
        case "rateIncreaseCriteria":
            return Optional.ofNullable(clazz.cast(rateIncreaseCriteria()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IoTJobExponentialRolloutRate, T> g) {
        return obj -> g.apply((IoTJobExponentialRolloutRate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IoTJobExponentialRolloutRate> {
        /**
         * <p>
         * The minimum number of devices that receive a pending job notification, per minute, when the job starts. This
         * parameter defines the initial rollout rate of the job.
         * </p>
         * 
         * @param baseRatePerMinute
         *        The minimum number of devices that receive a pending job notification, per minute, when the job
         *        starts. This parameter defines the initial rollout rate of the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseRatePerMinute(Integer baseRatePerMinute);

        /**
         * <p>
         * The exponential factor to increase the rollout rate for the job.
         * </p>
         * <p>
         * This parameter supports up to one digit after the decimal (for example, you can specify <code>1.5</code>, but
         * not <code>1.55</code>).
         * </p>
         * 
         * @param incrementFactor
         *        The exponential factor to increase the rollout rate for the job.</p>
         *        <p>
         *        This parameter supports up to one digit after the decimal (for example, you can specify
         *        <code>1.5</code>, but not <code>1.55</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder incrementFactor(Double incrementFactor);

        /**
         * <p>
         * The criteria to increase the rollout rate for the job.
         * </p>
         * 
         * @param rateIncreaseCriteria
         *        The criteria to increase the rollout rate for the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rateIncreaseCriteria(IoTJobRateIncreaseCriteria rateIncreaseCriteria);

        /**
         * <p>
         * The criteria to increase the rollout rate for the job.
         * </p>
         * This is a convenience that creates an instance of the {@link IoTJobRateIncreaseCriteria.Builder} avoiding the
         * need to create one manually via {@link IoTJobRateIncreaseCriteria#builder()}.
         *
         * When the {@link Consumer} completes, {@link IoTJobRateIncreaseCriteria.Builder#build()} is called immediately
         * and its result is passed to {@link #rateIncreaseCriteria(IoTJobRateIncreaseCriteria)}.
         * 
         * @param rateIncreaseCriteria
         *        a consumer that will call methods on {@link IoTJobRateIncreaseCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rateIncreaseCriteria(IoTJobRateIncreaseCriteria)
         */
        default Builder rateIncreaseCriteria(Consumer<IoTJobRateIncreaseCriteria.Builder> rateIncreaseCriteria) {
            return rateIncreaseCriteria(IoTJobRateIncreaseCriteria.builder().applyMutation(rateIncreaseCriteria).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Integer baseRatePerMinute;

        private Double incrementFactor;

        private IoTJobRateIncreaseCriteria rateIncreaseCriteria;

        private BuilderImpl() {
        }

        private BuilderImpl(IoTJobExponentialRolloutRate model) {
            baseRatePerMinute(model.baseRatePerMinute);
            incrementFactor(model.incrementFactor);
            rateIncreaseCriteria(model.rateIncreaseCriteria);
        }

        public final Integer getBaseRatePerMinute() {
            return baseRatePerMinute;
        }

        public final void setBaseRatePerMinute(Integer baseRatePerMinute) {
            this.baseRatePerMinute = baseRatePerMinute;
        }

        @Override
        @Transient
        public final Builder baseRatePerMinute(Integer baseRatePerMinute) {
            this.baseRatePerMinute = baseRatePerMinute;
            return this;
        }

        public final Double getIncrementFactor() {
            return incrementFactor;
        }

        public final void setIncrementFactor(Double incrementFactor) {
            this.incrementFactor = incrementFactor;
        }

        @Override
        @Transient
        public final Builder incrementFactor(Double incrementFactor) {
            this.incrementFactor = incrementFactor;
            return this;
        }

        public final IoTJobRateIncreaseCriteria.Builder getRateIncreaseCriteria() {
            return rateIncreaseCriteria != null ? rateIncreaseCriteria.toBuilder() : null;
        }

        public final void setRateIncreaseCriteria(IoTJobRateIncreaseCriteria.BuilderImpl rateIncreaseCriteria) {
            this.rateIncreaseCriteria = rateIncreaseCriteria != null ? rateIncreaseCriteria.build() : null;
        }

        @Override
        @Transient
        public final Builder rateIncreaseCriteria(IoTJobRateIncreaseCriteria rateIncreaseCriteria) {
            this.rateIncreaseCriteria = rateIncreaseCriteria;
            return this;
        }

        @Override
        public IoTJobExponentialRolloutRate build() {
            return new IoTJobExponentialRolloutRate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
