/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrassv2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a container in which Lambda functions run on Greengrass core devices.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LambdaContainerParams implements SdkPojo, Serializable,
        ToCopyableBuilder<LambdaContainerParams.Builder, LambdaContainerParams> {
    private static final SdkField<Integer> MEMORY_SIZE_IN_KB_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("memorySizeInKB").getter(getter(LambdaContainerParams::memorySizeInKB))
            .setter(setter(Builder::memorySizeInKB))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memorySizeInKB").build()).build();

    private static final SdkField<Boolean> MOUNT_RO_SYSFS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("mountROSysfs").getter(getter(LambdaContainerParams::mountROSysfs)).setter(setter(Builder::mountROSysfs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mountROSysfs").build()).build();

    private static final SdkField<List<LambdaVolumeMount>> VOLUMES_FIELD = SdkField
            .<List<LambdaVolumeMount>> builder(MarshallingType.LIST)
            .memberName("volumes")
            .getter(getter(LambdaContainerParams::volumes))
            .setter(setter(Builder::volumes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LambdaVolumeMount> builder(MarshallingType.SDK_POJO)
                                            .constructor(LambdaVolumeMount::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<LambdaDeviceMount>> DEVICES_FIELD = SdkField
            .<List<LambdaDeviceMount>> builder(MarshallingType.LIST)
            .memberName("devices")
            .getter(getter(LambdaContainerParams::devices))
            .setter(setter(Builder::devices))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("devices").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LambdaDeviceMount> builder(MarshallingType.SDK_POJO)
                                            .constructor(LambdaDeviceMount::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMORY_SIZE_IN_KB_FIELD,
            MOUNT_RO_SYSFS_FIELD, VOLUMES_FIELD, DEVICES_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer memorySizeInKB;

    private final Boolean mountROSysfs;

    private final List<LambdaVolumeMount> volumes;

    private final List<LambdaDeviceMount> devices;

    private LambdaContainerParams(BuilderImpl builder) {
        this.memorySizeInKB = builder.memorySizeInKB;
        this.mountROSysfs = builder.mountROSysfs;
        this.volumes = builder.volumes;
        this.devices = builder.devices;
    }

    /**
     * <p>
     * The memory size of the container, expressed in kilobytes.
     * </p>
     * <p>
     * Default: <code>16384</code> (16 MB)
     * </p>
     * 
     * @return The memory size of the container, expressed in kilobytes.</p>
     *         <p>
     *         Default: <code>16384</code> (16 MB)
     */
    public final Integer memorySizeInKB() {
        return memorySizeInKB;
    }

    /**
     * <p>
     * Whether or not the container can read information from the device's <code>/sys</code> folder.
     * </p>
     * <p>
     * Default: <code>false</code>
     * </p>
     * 
     * @return Whether or not the container can read information from the device's <code>/sys</code> folder.</p>
     *         <p>
     *         Default: <code>false</code>
     */
    public final Boolean mountROSysfs() {
        return mountROSysfs;
    }

    /**
     * For responses, this returns true if the service returned a value for the Volumes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasVolumes() {
        return volumes != null && !(volumes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of volumes that the container can access.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVolumes} method.
     * </p>
     * 
     * @return The list of volumes that the container can access.
     */
    public final List<LambdaVolumeMount> volumes() {
        return volumes;
    }

    /**
     * For responses, this returns true if the service returned a value for the Devices property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDevices() {
        return devices != null && !(devices instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of system devices that the container can access.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDevices} method.
     * </p>
     * 
     * @return The list of system devices that the container can access.
     */
    public final List<LambdaDeviceMount> devices() {
        return devices;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(memorySizeInKB());
        hashCode = 31 * hashCode + Objects.hashCode(mountROSysfs());
        hashCode = 31 * hashCode + Objects.hashCode(hasVolumes() ? volumes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDevices() ? devices() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LambdaContainerParams)) {
            return false;
        }
        LambdaContainerParams other = (LambdaContainerParams) obj;
        return Objects.equals(memorySizeInKB(), other.memorySizeInKB()) && Objects.equals(mountROSysfs(), other.mountROSysfs())
                && hasVolumes() == other.hasVolumes() && Objects.equals(volumes(), other.volumes())
                && hasDevices() == other.hasDevices() && Objects.equals(devices(), other.devices());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LambdaContainerParams").add("MemorySizeInKB", memorySizeInKB())
                .add("MountROSysfs", mountROSysfs()).add("Volumes", hasVolumes() ? volumes() : null)
                .add("Devices", hasDevices() ? devices() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "memorySizeInKB":
            return Optional.ofNullable(clazz.cast(memorySizeInKB()));
        case "mountROSysfs":
            return Optional.ofNullable(clazz.cast(mountROSysfs()));
        case "volumes":
            return Optional.ofNullable(clazz.cast(volumes()));
        case "devices":
            return Optional.ofNullable(clazz.cast(devices()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LambdaContainerParams, T> g) {
        return obj -> g.apply((LambdaContainerParams) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LambdaContainerParams> {
        /**
         * <p>
         * The memory size of the container, expressed in kilobytes.
         * </p>
         * <p>
         * Default: <code>16384</code> (16 MB)
         * </p>
         * 
         * @param memorySizeInKB
         *        The memory size of the container, expressed in kilobytes.</p>
         *        <p>
         *        Default: <code>16384</code> (16 MB)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memorySizeInKB(Integer memorySizeInKB);

        /**
         * <p>
         * Whether or not the container can read information from the device's <code>/sys</code> folder.
         * </p>
         * <p>
         * Default: <code>false</code>
         * </p>
         * 
         * @param mountROSysfs
         *        Whether or not the container can read information from the device's <code>/sys</code> folder.</p>
         *        <p>
         *        Default: <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mountROSysfs(Boolean mountROSysfs);

        /**
         * <p>
         * The list of volumes that the container can access.
         * </p>
         * 
         * @param volumes
         *        The list of volumes that the container can access.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumes(Collection<LambdaVolumeMount> volumes);

        /**
         * <p>
         * The list of volumes that the container can access.
         * </p>
         * 
         * @param volumes
         *        The list of volumes that the container can access.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumes(LambdaVolumeMount... volumes);

        /**
         * <p>
         * The list of volumes that the container can access.
         * </p>
         * This is a convenience that creates an instance of the {@link List<LambdaVolumeMount>.Builder} avoiding the
         * need to create one manually via {@link List<LambdaVolumeMount>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LambdaVolumeMount>.Builder#build()} is called immediately
         * and its result is passed to {@link #volumes(List<LambdaVolumeMount>)}.
         * 
         * @param volumes
         *        a consumer that will call methods on {@link List<LambdaVolumeMount>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #volumes(List<LambdaVolumeMount>)
         */
        Builder volumes(Consumer<LambdaVolumeMount.Builder>... volumes);

        /**
         * <p>
         * The list of system devices that the container can access.
         * </p>
         * 
         * @param devices
         *        The list of system devices that the container can access.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder devices(Collection<LambdaDeviceMount> devices);

        /**
         * <p>
         * The list of system devices that the container can access.
         * </p>
         * 
         * @param devices
         *        The list of system devices that the container can access.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder devices(LambdaDeviceMount... devices);

        /**
         * <p>
         * The list of system devices that the container can access.
         * </p>
         * This is a convenience that creates an instance of the {@link List<LambdaDeviceMount>.Builder} avoiding the
         * need to create one manually via {@link List<LambdaDeviceMount>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LambdaDeviceMount>.Builder#build()} is called immediately
         * and its result is passed to {@link #devices(List<LambdaDeviceMount>)}.
         * 
         * @param devices
         *        a consumer that will call methods on {@link List<LambdaDeviceMount>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #devices(List<LambdaDeviceMount>)
         */
        Builder devices(Consumer<LambdaDeviceMount.Builder>... devices);
    }

    static final class BuilderImpl implements Builder {
        private Integer memorySizeInKB;

        private Boolean mountROSysfs;

        private List<LambdaVolumeMount> volumes = DefaultSdkAutoConstructList.getInstance();

        private List<LambdaDeviceMount> devices = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LambdaContainerParams model) {
            memorySizeInKB(model.memorySizeInKB);
            mountROSysfs(model.mountROSysfs);
            volumes(model.volumes);
            devices(model.devices);
        }

        public final Integer getMemorySizeInKB() {
            return memorySizeInKB;
        }

        public final void setMemorySizeInKB(Integer memorySizeInKB) {
            this.memorySizeInKB = memorySizeInKB;
        }

        @Override
        @Transient
        public final Builder memorySizeInKB(Integer memorySizeInKB) {
            this.memorySizeInKB = memorySizeInKB;
            return this;
        }

        public final Boolean getMountROSysfs() {
            return mountROSysfs;
        }

        public final void setMountROSysfs(Boolean mountROSysfs) {
            this.mountROSysfs = mountROSysfs;
        }

        @Override
        @Transient
        public final Builder mountROSysfs(Boolean mountROSysfs) {
            this.mountROSysfs = mountROSysfs;
            return this;
        }

        public final List<LambdaVolumeMount.Builder> getVolumes() {
            List<LambdaVolumeMount.Builder> result = LambdaVolumeListCopier.copyToBuilder(this.volumes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVolumes(Collection<LambdaVolumeMount.BuilderImpl> volumes) {
            this.volumes = LambdaVolumeListCopier.copyFromBuilder(volumes);
        }

        @Override
        @Transient
        public final Builder volumes(Collection<LambdaVolumeMount> volumes) {
            this.volumes = LambdaVolumeListCopier.copy(volumes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder volumes(LambdaVolumeMount... volumes) {
            volumes(Arrays.asList(volumes));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder volumes(Consumer<LambdaVolumeMount.Builder>... volumes) {
            volumes(Stream.of(volumes).map(c -> LambdaVolumeMount.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<LambdaDeviceMount.Builder> getDevices() {
            List<LambdaDeviceMount.Builder> result = LambdaDeviceListCopier.copyToBuilder(this.devices);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDevices(Collection<LambdaDeviceMount.BuilderImpl> devices) {
            this.devices = LambdaDeviceListCopier.copyFromBuilder(devices);
        }

        @Override
        @Transient
        public final Builder devices(Collection<LambdaDeviceMount> devices) {
            this.devices = LambdaDeviceListCopier.copy(devices);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder devices(LambdaDeviceMount... devices) {
            devices(Arrays.asList(devices));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder devices(Consumer<LambdaDeviceMount.Builder>... devices) {
            devices(Stream.of(devices).map(c -> LambdaDeviceMount.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public LambdaContainerParams build() {
            return new LambdaContainerParams(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
