/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrassv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCoreDeviceRequest extends GreengrassV2Request implements
        ToCopyableBuilder<GetCoreDeviceRequest.Builder, GetCoreDeviceRequest> {
    private static final SdkField<String> CORE_DEVICE_THING_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("coreDeviceThingName").getter(getter(GetCoreDeviceRequest::coreDeviceThingName))
            .setter(setter(Builder::coreDeviceThingName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("coreDeviceThingName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CORE_DEVICE_THING_NAME_FIELD));

    private final String coreDeviceThingName;

    private GetCoreDeviceRequest(BuilderImpl builder) {
        super(builder);
        this.coreDeviceThingName = builder.coreDeviceThingName;
    }

    /**
     * <p>
     * The name of the core device. This is also the name of the IoT thing.
     * </p>
     * 
     * @return The name of the core device. This is also the name of the IoT thing.
     */
    public final String coreDeviceThingName() {
        return coreDeviceThingName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(coreDeviceThingName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCoreDeviceRequest)) {
            return false;
        }
        GetCoreDeviceRequest other = (GetCoreDeviceRequest) obj;
        return Objects.equals(coreDeviceThingName(), other.coreDeviceThingName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCoreDeviceRequest").add("CoreDeviceThingName", coreDeviceThingName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "coreDeviceThingName":
            return Optional.ofNullable(clazz.cast(coreDeviceThingName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetCoreDeviceRequest, T> g) {
        return obj -> g.apply((GetCoreDeviceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GreengrassV2Request.Builder, SdkPojo, CopyableBuilder<Builder, GetCoreDeviceRequest> {
        /**
         * <p>
         * The name of the core device. This is also the name of the IoT thing.
         * </p>
         * 
         * @param coreDeviceThingName
         *        The name of the core device. This is also the name of the IoT thing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coreDeviceThingName(String coreDeviceThingName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GreengrassV2Request.BuilderImpl implements Builder {
        private String coreDeviceThingName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCoreDeviceRequest model) {
            super(model);
            coreDeviceThingName(model.coreDeviceThingName);
        }

        public final String getCoreDeviceThingName() {
            return coreDeviceThingName;
        }

        public final void setCoreDeviceThingName(String coreDeviceThingName) {
            this.coreDeviceThingName = coreDeviceThingName;
        }

        @Override
        public final Builder coreDeviceThingName(String coreDeviceThingName) {
            this.coreDeviceThingName = coreDeviceThingName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetCoreDeviceRequest build() {
            return new GetCoreDeviceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
