/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrassv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.greengrassv2.model.EffectiveDeployment;
import software.amazon.awssdk.services.greengrassv2.model.EffectiveDeploymentsListCopier;
import software.amazon.awssdk.services.greengrassv2.model.GreengrassV2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListEffectiveDeploymentsResponse
extends GreengrassV2Response
implements ToCopyableBuilder<Builder, ListEffectiveDeploymentsResponse> {
    private static final SdkField<List<EffectiveDeployment>> EFFECTIVE_DEPLOYMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("effectiveDeployments").getter(ListEffectiveDeploymentsResponse.getter(ListEffectiveDeploymentsResponse::effectiveDeployments)).setter(ListEffectiveDeploymentsResponse.setter(Builder::effectiveDeployments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("effectiveDeployments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EffectiveDeployment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListEffectiveDeploymentsResponse.getter(ListEffectiveDeploymentsResponse::nextToken)).setter(ListEffectiveDeploymentsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EFFECTIVE_DEPLOYMENTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<EffectiveDeployment> effectiveDeployments;
    private final String nextToken;

    private ListEffectiveDeploymentsResponse(BuilderImpl builder) {
        super(builder);
        this.effectiveDeployments = builder.effectiveDeployments;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasEffectiveDeployments() {
        return this.effectiveDeployments != null && !(this.effectiveDeployments instanceof SdkAutoConstructList);
    }

    public final List<EffectiveDeployment> effectiveDeployments() {
        return this.effectiveDeployments;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEffectiveDeployments() ? this.effectiveDeployments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEffectiveDeploymentsResponse)) {
            return false;
        }
        ListEffectiveDeploymentsResponse other = (ListEffectiveDeploymentsResponse)((Object)obj);
        return this.hasEffectiveDeployments() == other.hasEffectiveDeployments() && Objects.equals(this.effectiveDeployments(), other.effectiveDeployments()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListEffectiveDeploymentsResponse").add("EffectiveDeployments", this.hasEffectiveDeployments() ? this.effectiveDeployments() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "effectiveDeployments": {
                return Optional.ofNullable(clazz.cast(this.effectiveDeployments()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListEffectiveDeploymentsResponse, T> g) {
        return obj -> g.apply((ListEffectiveDeploymentsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GreengrassV2Response.BuilderImpl
    implements Builder {
        private List<EffectiveDeployment> effectiveDeployments = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEffectiveDeploymentsResponse model) {
            super(model);
            this.effectiveDeployments(model.effectiveDeployments);
            this.nextToken(model.nextToken);
        }

        public final List<EffectiveDeployment.Builder> getEffectiveDeployments() {
            List<EffectiveDeployment.Builder> result = EffectiveDeploymentsListCopier.copyToBuilder(this.effectiveDeployments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEffectiveDeployments(Collection<EffectiveDeployment.BuilderImpl> effectiveDeployments) {
            this.effectiveDeployments = EffectiveDeploymentsListCopier.copyFromBuilder(effectiveDeployments);
        }

        @Override
        public final Builder effectiveDeployments(Collection<EffectiveDeployment> effectiveDeployments) {
            this.effectiveDeployments = EffectiveDeploymentsListCopier.copy(effectiveDeployments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder effectiveDeployments(EffectiveDeployment ... effectiveDeployments) {
            this.effectiveDeployments(Arrays.asList(effectiveDeployments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder effectiveDeployments(Consumer<EffectiveDeployment.Builder> ... effectiveDeployments) {
            this.effectiveDeployments(Stream.of(effectiveDeployments).map(c -> (EffectiveDeployment)((EffectiveDeployment.Builder)EffectiveDeployment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListEffectiveDeploymentsResponse build() {
            return new ListEffectiveDeploymentsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GreengrassV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListEffectiveDeploymentsResponse> {
        public Builder effectiveDeployments(Collection<EffectiveDeployment> var1);

        public Builder effectiveDeployments(EffectiveDeployment ... var1);

        public Builder effectiveDeployments(Consumer<EffectiveDeployment.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

