/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrassv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetServiceRoleForAccountResponse extends GreengrassV2Response implements
        ToCopyableBuilder<GetServiceRoleForAccountResponse.Builder, GetServiceRoleForAccountResponse> {
    private static final SdkField<String> ASSOCIATED_AT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("associatedAt").getter(getter(GetServiceRoleForAccountResponse::associatedAt))
            .setter(setter(Builder::associatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedAt").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(GetServiceRoleForAccountResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATED_AT_FIELD,
            ROLE_ARN_FIELD));

    private final String associatedAt;

    private final String roleArn;

    private GetServiceRoleForAccountResponse(BuilderImpl builder) {
        super(builder);
        this.associatedAt = builder.associatedAt;
        this.roleArn = builder.roleArn;
    }

    /**
     * <p>
     * The time when the service role was associated with IoT Greengrass for your Amazon Web Services account in this
     * Amazon Web Services Region.
     * </p>
     * 
     * @return The time when the service role was associated with IoT Greengrass for your Amazon Web Services account in
     *         this Amazon Web Services Region.
     */
    public final String associatedAt() {
        return associatedAt;
    }

    /**
     * <p>
     * The ARN of the service role that is associated with IoT Greengrass for your Amazon Web Services account in this
     * Amazon Web Services Region.
     * </p>
     * 
     * @return The ARN of the service role that is associated with IoT Greengrass for your Amazon Web Services account
     *         in this Amazon Web Services Region.
     */
    public final String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(associatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetServiceRoleForAccountResponse)) {
            return false;
        }
        GetServiceRoleForAccountResponse other = (GetServiceRoleForAccountResponse) obj;
        return Objects.equals(associatedAt(), other.associatedAt()) && Objects.equals(roleArn(), other.roleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetServiceRoleForAccountResponse").add("AssociatedAt", associatedAt()).add("RoleArn", roleArn())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "associatedAt":
            return Optional.ofNullable(clazz.cast(associatedAt()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetServiceRoleForAccountResponse, T> g) {
        return obj -> g.apply((GetServiceRoleForAccountResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GreengrassV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, GetServiceRoleForAccountResponse> {
        /**
         * <p>
         * The time when the service role was associated with IoT Greengrass for your Amazon Web Services account in
         * this Amazon Web Services Region.
         * </p>
         * 
         * @param associatedAt
         *        The time when the service role was associated with IoT Greengrass for your Amazon Web Services account
         *        in this Amazon Web Services Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedAt(String associatedAt);

        /**
         * <p>
         * The ARN of the service role that is associated with IoT Greengrass for your Amazon Web Services account in
         * this Amazon Web Services Region.
         * </p>
         * 
         * @param roleArn
         *        The ARN of the service role that is associated with IoT Greengrass for your Amazon Web Services
         *        account in this Amazon Web Services Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);
    }

    static final class BuilderImpl extends GreengrassV2Response.BuilderImpl implements Builder {
        private String associatedAt;

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetServiceRoleForAccountResponse model) {
            super(model);
            associatedAt(model.associatedAt);
            roleArn(model.roleArn);
        }

        public final String getAssociatedAt() {
            return associatedAt;
        }

        public final void setAssociatedAt(String associatedAt) {
            this.associatedAt = associatedAt;
        }

        @Override
        public final Builder associatedAt(String associatedAt) {
            this.associatedAt = associatedAt;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Override
        public GetServiceRoleForAccountResponse build() {
            return new GetServiceRoleForAccountResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
