/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrassv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateConnectivityInfoRequest extends GreengrassV2Request implements
        ToCopyableBuilder<UpdateConnectivityInfoRequest.Builder, UpdateConnectivityInfoRequest> {
    private static final SdkField<String> THING_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("thingName").getter(getter(UpdateConnectivityInfoRequest::thingName)).setter(setter(Builder::thingName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("thingName").build()).build();

    private static final SdkField<List<ConnectivityInfo>> CONNECTIVITY_INFO_FIELD = SdkField
            .<List<ConnectivityInfo>> builder(MarshallingType.LIST)
            .memberName("connectivityInfo")
            .getter(getter(UpdateConnectivityInfoRequest::connectivityInfo))
            .setter(setter(Builder::connectivityInfo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectivityInfo").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConnectivityInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConnectivityInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THING_NAME_FIELD,
            CONNECTIVITY_INFO_FIELD));

    private final String thingName;

    private final List<ConnectivityInfo> connectivityInfo;

    private UpdateConnectivityInfoRequest(BuilderImpl builder) {
        super(builder);
        this.thingName = builder.thingName;
        this.connectivityInfo = builder.connectivityInfo;
    }

    /**
     * <p>
     * The name of the core device. This is also the name of the IoT thing.
     * </p>
     * 
     * @return The name of the core device. This is also the name of the IoT thing.
     */
    public final String thingName() {
        return thingName;
    }

    /**
     * For responses, this returns true if the service returned a value for the ConnectivityInfo property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasConnectivityInfo() {
        return connectivityInfo != null && !(connectivityInfo instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The connectivity information for the core device.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConnectivityInfo} method.
     * </p>
     * 
     * @return The connectivity information for the core device.
     */
    public final List<ConnectivityInfo> connectivityInfo() {
        return connectivityInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(thingName());
        hashCode = 31 * hashCode + Objects.hashCode(hasConnectivityInfo() ? connectivityInfo() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateConnectivityInfoRequest)) {
            return false;
        }
        UpdateConnectivityInfoRequest other = (UpdateConnectivityInfoRequest) obj;
        return Objects.equals(thingName(), other.thingName()) && hasConnectivityInfo() == other.hasConnectivityInfo()
                && Objects.equals(connectivityInfo(), other.connectivityInfo());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateConnectivityInfoRequest").add("ThingName", thingName())
                .add("ConnectivityInfo", hasConnectivityInfo() ? connectivityInfo() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "thingName":
            return Optional.ofNullable(clazz.cast(thingName()));
        case "connectivityInfo":
            return Optional.ofNullable(clazz.cast(connectivityInfo()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateConnectivityInfoRequest, T> g) {
        return obj -> g.apply((UpdateConnectivityInfoRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GreengrassV2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateConnectivityInfoRequest> {
        /**
         * <p>
         * The name of the core device. This is also the name of the IoT thing.
         * </p>
         * 
         * @param thingName
         *        The name of the core device. This is also the name of the IoT thing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingName(String thingName);

        /**
         * <p>
         * The connectivity information for the core device.
         * </p>
         * 
         * @param connectivityInfo
         *        The connectivity information for the core device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectivityInfo(Collection<ConnectivityInfo> connectivityInfo);

        /**
         * <p>
         * The connectivity information for the core device.
         * </p>
         * 
         * @param connectivityInfo
         *        The connectivity information for the core device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectivityInfo(ConnectivityInfo... connectivityInfo);

        /**
         * <p>
         * The connectivity information for the core device.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.greengrassv2.model.ConnectivityInfo.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.greengrassv2.model.ConnectivityInfo#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.greengrassv2.model.ConnectivityInfo.Builder#build()} is called
         * immediately and its result is passed to {@link #connectivityInfo(List<ConnectivityInfo>)}.
         * 
         * @param connectivityInfo
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.greengrassv2.model.ConnectivityInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectivityInfo(java.util.Collection<ConnectivityInfo>)
         */
        Builder connectivityInfo(Consumer<ConnectivityInfo.Builder>... connectivityInfo);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GreengrassV2Request.BuilderImpl implements Builder {
        private String thingName;

        private List<ConnectivityInfo> connectivityInfo = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateConnectivityInfoRequest model) {
            super(model);
            thingName(model.thingName);
            connectivityInfo(model.connectivityInfo);
        }

        public final String getThingName() {
            return thingName;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        @Override
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        public final List<ConnectivityInfo.Builder> getConnectivityInfo() {
            List<ConnectivityInfo.Builder> result = _connectivityInfoListCopier.copyToBuilder(this.connectivityInfo);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConnectivityInfo(Collection<ConnectivityInfo.BuilderImpl> connectivityInfo) {
            this.connectivityInfo = _connectivityInfoListCopier.copyFromBuilder(connectivityInfo);
        }

        @Override
        public final Builder connectivityInfo(Collection<ConnectivityInfo> connectivityInfo) {
            this.connectivityInfo = _connectivityInfoListCopier.copy(connectivityInfo);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectivityInfo(ConnectivityInfo... connectivityInfo) {
            connectivityInfo(Arrays.asList(connectivityInfo));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectivityInfo(Consumer<ConnectivityInfo.Builder>... connectivityInfo) {
            connectivityInfo(Stream.of(connectivityInfo).map(c -> ConnectivityInfo.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateConnectivityInfoRequest build() {
            return new UpdateConnectivityInfoRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
