/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrassv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchAssociateClientDeviceWithCoreDeviceRequest extends GreengrassV2Request
        implements
        ToCopyableBuilder<BatchAssociateClientDeviceWithCoreDeviceRequest.Builder, BatchAssociateClientDeviceWithCoreDeviceRequest> {
    private static final SdkField<List<AssociateClientDeviceWithCoreDeviceEntry>> ENTRIES_FIELD = SdkField
            .<List<AssociateClientDeviceWithCoreDeviceEntry>> builder(MarshallingType.LIST)
            .memberName("entries")
            .getter(getter(BatchAssociateClientDeviceWithCoreDeviceRequest::entries))
            .setter(setter(Builder::entries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssociateClientDeviceWithCoreDeviceEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssociateClientDeviceWithCoreDeviceEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CORE_DEVICE_THING_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("coreDeviceThingName")
            .getter(getter(BatchAssociateClientDeviceWithCoreDeviceRequest::coreDeviceThingName))
            .setter(setter(Builder::coreDeviceThingName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("coreDeviceThingName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTRIES_FIELD,
            CORE_DEVICE_THING_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<AssociateClientDeviceWithCoreDeviceEntry> entries;

    private final String coreDeviceThingName;

    private BatchAssociateClientDeviceWithCoreDeviceRequest(BuilderImpl builder) {
        super(builder);
        this.entries = builder.entries;
        this.coreDeviceThingName = builder.coreDeviceThingName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Entries property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEntries() {
        return entries != null && !(entries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of client devices to associate.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEntries} method.
     * </p>
     * 
     * @return The list of client devices to associate.
     */
    public final List<AssociateClientDeviceWithCoreDeviceEntry> entries() {
        return entries;
    }

    /**
     * <p>
     * The name of the core device. This is also the name of the IoT thing.
     * </p>
     * 
     * @return The name of the core device. This is also the name of the IoT thing.
     */
    public final String coreDeviceThingName() {
        return coreDeviceThingName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEntries() ? entries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(coreDeviceThingName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchAssociateClientDeviceWithCoreDeviceRequest)) {
            return false;
        }
        BatchAssociateClientDeviceWithCoreDeviceRequest other = (BatchAssociateClientDeviceWithCoreDeviceRequest) obj;
        return hasEntries() == other.hasEntries() && Objects.equals(entries(), other.entries())
                && Objects.equals(coreDeviceThingName(), other.coreDeviceThingName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchAssociateClientDeviceWithCoreDeviceRequest")
                .add("Entries", hasEntries() ? entries() : null).add("CoreDeviceThingName", coreDeviceThingName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "entries":
            return Optional.ofNullable(clazz.cast(entries()));
        case "coreDeviceThingName":
            return Optional.ofNullable(clazz.cast(coreDeviceThingName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("entries", ENTRIES_FIELD);
        map.put("coreDeviceThingName", CORE_DEVICE_THING_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchAssociateClientDeviceWithCoreDeviceRequest, T> g) {
        return obj -> g.apply((BatchAssociateClientDeviceWithCoreDeviceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GreengrassV2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchAssociateClientDeviceWithCoreDeviceRequest> {
        /**
         * <p>
         * The list of client devices to associate.
         * </p>
         * 
         * @param entries
         *        The list of client devices to associate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entries(Collection<AssociateClientDeviceWithCoreDeviceEntry> entries);

        /**
         * <p>
         * The list of client devices to associate.
         * </p>
         * 
         * @param entries
         *        The list of client devices to associate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entries(AssociateClientDeviceWithCoreDeviceEntry... entries);

        /**
         * <p>
         * The list of client devices to associate.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.greengrassv2.model.AssociateClientDeviceWithCoreDeviceEntry.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.greengrassv2.model.AssociateClientDeviceWithCoreDeviceEntry#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.greengrassv2.model.AssociateClientDeviceWithCoreDeviceEntry.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #entries(List<AssociateClientDeviceWithCoreDeviceEntry>)}.
         * 
         * @param entries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.greengrassv2.model.AssociateClientDeviceWithCoreDeviceEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entries(java.util.Collection<AssociateClientDeviceWithCoreDeviceEntry>)
         */
        Builder entries(Consumer<AssociateClientDeviceWithCoreDeviceEntry.Builder>... entries);

        /**
         * <p>
         * The name of the core device. This is also the name of the IoT thing.
         * </p>
         * 
         * @param coreDeviceThingName
         *        The name of the core device. This is also the name of the IoT thing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coreDeviceThingName(String coreDeviceThingName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GreengrassV2Request.BuilderImpl implements Builder {
        private List<AssociateClientDeviceWithCoreDeviceEntry> entries = DefaultSdkAutoConstructList.getInstance();

        private String coreDeviceThingName;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchAssociateClientDeviceWithCoreDeviceRequest model) {
            super(model);
            entries(model.entries);
            coreDeviceThingName(model.coreDeviceThingName);
        }

        public final List<AssociateClientDeviceWithCoreDeviceEntry.Builder> getEntries() {
            List<AssociateClientDeviceWithCoreDeviceEntry.Builder> result = AssociateClientDeviceWithCoreDeviceEntryListCopier
                    .copyToBuilder(this.entries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEntries(Collection<AssociateClientDeviceWithCoreDeviceEntry.BuilderImpl> entries) {
            this.entries = AssociateClientDeviceWithCoreDeviceEntryListCopier.copyFromBuilder(entries);
        }

        @Override
        public final Builder entries(Collection<AssociateClientDeviceWithCoreDeviceEntry> entries) {
            this.entries = AssociateClientDeviceWithCoreDeviceEntryListCopier.copy(entries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entries(AssociateClientDeviceWithCoreDeviceEntry... entries) {
            entries(Arrays.asList(entries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entries(Consumer<AssociateClientDeviceWithCoreDeviceEntry.Builder>... entries) {
            entries(Stream.of(entries).map(c -> AssociateClientDeviceWithCoreDeviceEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getCoreDeviceThingName() {
            return coreDeviceThingName;
        }

        public final void setCoreDeviceThingName(String coreDeviceThingName) {
            this.coreDeviceThingName = coreDeviceThingName;
        }

        @Override
        public final Builder coreDeviceThingName(String coreDeviceThingName) {
            this.coreDeviceThingName = coreDeviceThingName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchAssociateClientDeviceWithCoreDeviceRequest build() {
            return new BatchAssociateClientDeviceWithCoreDeviceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
