/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrassv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a component to deploy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ComponentDeploymentSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<ComponentDeploymentSpecification.Builder, ComponentDeploymentSpecification> {
    private static final SdkField<String> COMPONENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("componentVersion").getter(getter(ComponentDeploymentSpecification::componentVersion))
            .setter(setter(Builder::componentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentVersion").build()).build();

    private static final SdkField<ComponentConfigurationUpdate> CONFIGURATION_UPDATE_FIELD = SdkField
            .<ComponentConfigurationUpdate> builder(MarshallingType.SDK_POJO).memberName("configurationUpdate")
            .getter(getter(ComponentDeploymentSpecification::configurationUpdate)).setter(setter(Builder::configurationUpdate))
            .constructor(ComponentConfigurationUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationUpdate").build())
            .build();

    private static final SdkField<ComponentRunWith> RUN_WITH_FIELD = SdkField
            .<ComponentRunWith> builder(MarshallingType.SDK_POJO).memberName("runWith")
            .getter(getter(ComponentDeploymentSpecification::runWith)).setter(setter(Builder::runWith))
            .constructor(ComponentRunWith::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runWith").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPONENT_VERSION_FIELD,
            CONFIGURATION_UPDATE_FIELD, RUN_WITH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String componentVersion;

    private final ComponentConfigurationUpdate configurationUpdate;

    private final ComponentRunWith runWith;

    private ComponentDeploymentSpecification(BuilderImpl builder) {
        this.componentVersion = builder.componentVersion;
        this.configurationUpdate = builder.configurationUpdate;
        this.runWith = builder.runWith;
    }

    /**
     * <p>
     * The version of the component.
     * </p>
     * 
     * @return The version of the component.
     */
    public final String componentVersion() {
        return componentVersion;
    }

    /**
     * <p>
     * The configuration updates to deploy for the component. You can define <i>reset</i> updates and <i>merge</i>
     * updates. A reset updates the keys that you specify to the default configuration for the component. A merge
     * updates the core device's component configuration with the keys and values that you specify. The IoT Greengrass
     * Core software applies reset updates before it applies merge updates. For more information, see <a
     * href="https://docs.aws.amazon.com/greengrass/v2/developerguide/update-component-configurations.html">Update
     * component configurations</a> in the <i>IoT Greengrass V2 Developer Guide</i>.
     * </p>
     * 
     * @return The configuration updates to deploy for the component. You can define <i>reset</i> updates and
     *         <i>merge</i> updates. A reset updates the keys that you specify to the default configuration for the
     *         component. A merge updates the core device's component configuration with the keys and values that you
     *         specify. The IoT Greengrass Core software applies reset updates before it applies merge updates. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/greengrass/v2/developerguide/update-component-configurations.html"
     *         >Update component configurations</a> in the <i>IoT Greengrass V2 Developer Guide</i>.
     */
    public final ComponentConfigurationUpdate configurationUpdate() {
        return configurationUpdate;
    }

    /**
     * <p>
     * The system user and group that the IoT Greengrass Core software uses to run component processes on the core
     * device. If you omit this parameter, the IoT Greengrass Core software uses the system user and group that you
     * configure for the core device. For more information, see <a href=
     * "https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-greengrass-core-v2.html#configure-component-user"
     * >Configure the user and group that run components</a> in the <i>IoT Greengrass V2 Developer Guide</i>.
     * </p>
     * 
     * @return The system user and group that the IoT Greengrass Core software uses to run component processes on the
     *         core device. If you omit this parameter, the IoT Greengrass Core software uses the system user and group
     *         that you configure for the core device. For more information, see <a href=
     *         "https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-greengrass-core-v2.html#configure-component-user"
     *         >Configure the user and group that run components</a> in the <i>IoT Greengrass V2 Developer Guide</i>.
     */
    public final ComponentRunWith runWith() {
        return runWith;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(componentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(configurationUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(runWith());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComponentDeploymentSpecification)) {
            return false;
        }
        ComponentDeploymentSpecification other = (ComponentDeploymentSpecification) obj;
        return Objects.equals(componentVersion(), other.componentVersion())
                && Objects.equals(configurationUpdate(), other.configurationUpdate())
                && Objects.equals(runWith(), other.runWith());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ComponentDeploymentSpecification").add("ComponentVersion", componentVersion())
                .add("ConfigurationUpdate", configurationUpdate()).add("RunWith", runWith()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "componentVersion":
            return Optional.ofNullable(clazz.cast(componentVersion()));
        case "configurationUpdate":
            return Optional.ofNullable(clazz.cast(configurationUpdate()));
        case "runWith":
            return Optional.ofNullable(clazz.cast(runWith()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("componentVersion", COMPONENT_VERSION_FIELD);
        map.put("configurationUpdate", CONFIGURATION_UPDATE_FIELD);
        map.put("runWith", RUN_WITH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ComponentDeploymentSpecification, T> g) {
        return obj -> g.apply((ComponentDeploymentSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ComponentDeploymentSpecification> {
        /**
         * <p>
         * The version of the component.
         * </p>
         * 
         * @param componentVersion
         *        The version of the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentVersion(String componentVersion);

        /**
         * <p>
         * The configuration updates to deploy for the component. You can define <i>reset</i> updates and <i>merge</i>
         * updates. A reset updates the keys that you specify to the default configuration for the component. A merge
         * updates the core device's component configuration with the keys and values that you specify. The IoT
         * Greengrass Core software applies reset updates before it applies merge updates. For more information, see <a
         * href="https://docs.aws.amazon.com/greengrass/v2/developerguide/update-component-configurations.html">Update
         * component configurations</a> in the <i>IoT Greengrass V2 Developer Guide</i>.
         * </p>
         * 
         * @param configurationUpdate
         *        The configuration updates to deploy for the component. You can define <i>reset</i> updates and
         *        <i>merge</i> updates. A reset updates the keys that you specify to the default configuration for the
         *        component. A merge updates the core device's component configuration with the keys and values that you
         *        specify. The IoT Greengrass Core software applies reset updates before it applies merge updates. For
         *        more information, see <a
         *        href="https://docs.aws.amazon.com/greengrass/v2/developerguide/update-component-configurations.html"
         *        >Update component configurations</a> in the <i>IoT Greengrass V2 Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationUpdate(ComponentConfigurationUpdate configurationUpdate);

        /**
         * <p>
         * The configuration updates to deploy for the component. You can define <i>reset</i> updates and <i>merge</i>
         * updates. A reset updates the keys that you specify to the default configuration for the component. A merge
         * updates the core device's component configuration with the keys and values that you specify. The IoT
         * Greengrass Core software applies reset updates before it applies merge updates. For more information, see <a
         * href="https://docs.aws.amazon.com/greengrass/v2/developerguide/update-component-configurations.html">Update
         * component configurations</a> in the <i>IoT Greengrass V2 Developer Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link ComponentConfigurationUpdate.Builder}
         * avoiding the need to create one manually via {@link ComponentConfigurationUpdate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ComponentConfigurationUpdate.Builder#build()} is called
         * immediately and its result is passed to {@link #configurationUpdate(ComponentConfigurationUpdate)}.
         * 
         * @param configurationUpdate
         *        a consumer that will call methods on {@link ComponentConfigurationUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configurationUpdate(ComponentConfigurationUpdate)
         */
        default Builder configurationUpdate(Consumer<ComponentConfigurationUpdate.Builder> configurationUpdate) {
            return configurationUpdate(ComponentConfigurationUpdate.builder().applyMutation(configurationUpdate).build());
        }

        /**
         * <p>
         * The system user and group that the IoT Greengrass Core software uses to run component processes on the core
         * device. If you omit this parameter, the IoT Greengrass Core software uses the system user and group that you
         * configure for the core device. For more information, see <a href=
         * "https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-greengrass-core-v2.html#configure-component-user"
         * >Configure the user and group that run components</a> in the <i>IoT Greengrass V2 Developer Guide</i>.
         * </p>
         * 
         * @param runWith
         *        The system user and group that the IoT Greengrass Core software uses to run component processes on the
         *        core device. If you omit this parameter, the IoT Greengrass Core software uses the system user and
         *        group that you configure for the core device. For more information, see <a href=
         *        "https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-greengrass-core-v2.html#configure-component-user"
         *        >Configure the user and group that run components</a> in the <i>IoT Greengrass V2 Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runWith(ComponentRunWith runWith);

        /**
         * <p>
         * The system user and group that the IoT Greengrass Core software uses to run component processes on the core
         * device. If you omit this parameter, the IoT Greengrass Core software uses the system user and group that you
         * configure for the core device. For more information, see <a href=
         * "https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-greengrass-core-v2.html#configure-component-user"
         * >Configure the user and group that run components</a> in the <i>IoT Greengrass V2 Developer Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link ComponentRunWith.Builder} avoiding the
         * need to create one manually via {@link ComponentRunWith#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ComponentRunWith.Builder#build()} is called immediately and its
         * result is passed to {@link #runWith(ComponentRunWith)}.
         * 
         * @param runWith
         *        a consumer that will call methods on {@link ComponentRunWith.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #runWith(ComponentRunWith)
         */
        default Builder runWith(Consumer<ComponentRunWith.Builder> runWith) {
            return runWith(ComponentRunWith.builder().applyMutation(runWith).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String componentVersion;

        private ComponentConfigurationUpdate configurationUpdate;

        private ComponentRunWith runWith;

        private BuilderImpl() {
        }

        private BuilderImpl(ComponentDeploymentSpecification model) {
            componentVersion(model.componentVersion);
            configurationUpdate(model.configurationUpdate);
            runWith(model.runWith);
        }

        public final String getComponentVersion() {
            return componentVersion;
        }

        public final void setComponentVersion(String componentVersion) {
            this.componentVersion = componentVersion;
        }

        @Override
        public final Builder componentVersion(String componentVersion) {
            this.componentVersion = componentVersion;
            return this;
        }

        public final ComponentConfigurationUpdate.Builder getConfigurationUpdate() {
            return configurationUpdate != null ? configurationUpdate.toBuilder() : null;
        }

        public final void setConfigurationUpdate(ComponentConfigurationUpdate.BuilderImpl configurationUpdate) {
            this.configurationUpdate = configurationUpdate != null ? configurationUpdate.build() : null;
        }

        @Override
        public final Builder configurationUpdate(ComponentConfigurationUpdate configurationUpdate) {
            this.configurationUpdate = configurationUpdate;
            return this;
        }

        public final ComponentRunWith.Builder getRunWith() {
            return runWith != null ? runWith.toBuilder() : null;
        }

        public final void setRunWith(ComponentRunWith.BuilderImpl runWith) {
            this.runWith = runWith != null ? runWith.build() : null;
        }

        @Override
        public final Builder runWith(ComponentRunWith runWith) {
            this.runWith = runWith;
            return this;
        }

        @Override
        public ComponentDeploymentSpecification build() {
            return new ComponentDeploymentSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
