/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrassv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information system user and group that the IoT Greengrass Core software uses to run component processes on
 * the core device. For more information, see <a href=
 * "https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-greengrass-core-v2.html#configure-component-user"
 * >Configure the user and group that run components</a> in the <i>IoT Greengrass V2 Developer Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ComponentRunWith implements SdkPojo, Serializable,
        ToCopyableBuilder<ComponentRunWith.Builder, ComponentRunWith> {
    private static final SdkField<String> POSIX_USER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("posixUser").getter(getter(ComponentRunWith::posixUser)).setter(setter(Builder::posixUser))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("posixUser").build()).build();

    private static final SdkField<SystemResourceLimits> SYSTEM_RESOURCE_LIMITS_FIELD = SdkField
            .<SystemResourceLimits> builder(MarshallingType.SDK_POJO).memberName("systemResourceLimits")
            .getter(getter(ComponentRunWith::systemResourceLimits)).setter(setter(Builder::systemResourceLimits))
            .constructor(SystemResourceLimits::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("systemResourceLimits").build())
            .build();

    private static final SdkField<String> WINDOWS_USER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("windowsUser").getter(getter(ComponentRunWith::windowsUser)).setter(setter(Builder::windowsUser))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("windowsUser").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POSIX_USER_FIELD,
            SYSTEM_RESOURCE_LIMITS_FIELD, WINDOWS_USER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String posixUser;

    private final SystemResourceLimits systemResourceLimits;

    private final String windowsUser;

    private ComponentRunWith(BuilderImpl builder) {
        this.posixUser = builder.posixUser;
        this.systemResourceLimits = builder.systemResourceLimits;
        this.windowsUser = builder.windowsUser;
    }

    /**
     * <p>
     * The POSIX system user and, optionally, group to use to run this component on Linux core devices. The user, and
     * group if specified, must exist on each Linux core device. Specify the user and group separated by a colon (
     * <code>:</code>) in the following format: <code>user:group</code>. The group is optional. If you don't specify a
     * group, the IoT Greengrass Core software uses the primary user for the group.
     * </p>
     * <p>
     * If you omit this parameter, the IoT Greengrass Core software uses the default system user and group that you
     * configure on the Greengrass nucleus component. For more information, see <a href=
     * "https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-greengrass-core-v2.html#configure-component-user"
     * >Configure the user and group that run components</a>.
     * </p>
     * 
     * @return The POSIX system user and, optionally, group to use to run this component on Linux core devices. The
     *         user, and group if specified, must exist on each Linux core device. Specify the user and group separated
     *         by a colon (<code>:</code>) in the following format: <code>user:group</code>. The group is optional. If
     *         you don't specify a group, the IoT Greengrass Core software uses the primary user for the group.</p>
     *         <p>
     *         If you omit this parameter, the IoT Greengrass Core software uses the default system user and group that
     *         you configure on the Greengrass nucleus component. For more information, see <a href=
     *         "https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-greengrass-core-v2.html#configure-component-user"
     *         >Configure the user and group that run components</a>.
     */
    public final String posixUser() {
        return posixUser;
    }

    /**
     * <p>
     * The system resource limits to apply to this component's process on the core device. IoT Greengrass currently
     * supports this feature on only Linux core devices.
     * </p>
     * <p>
     * If you omit this parameter, the IoT Greengrass Core software uses the default system resource limits that you
     * configure on the Greengrass nucleus component. For more information, see <a href=
     * "https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-greengrass-core-v2.html#configure-component-system-resource-limits"
     * >Configure system resource limits for components</a>.
     * </p>
     * 
     * @return The system resource limits to apply to this component's process on the core device. IoT Greengrass
     *         currently supports this feature on only Linux core devices.</p>
     *         <p>
     *         If you omit this parameter, the IoT Greengrass Core software uses the default system resource limits that
     *         you configure on the Greengrass nucleus component. For more information, see <a href=
     *         "https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-greengrass-core-v2.html#configure-component-system-resource-limits"
     *         >Configure system resource limits for components</a>.
     */
    public final SystemResourceLimits systemResourceLimits() {
        return systemResourceLimits;
    }

    /**
     * <p>
     * The Windows user to use to run this component on Windows core devices. The user must exist on each Windows core
     * device, and its name and password must be in the LocalSystem account's Credentials Manager instance.
     * </p>
     * <p>
     * If you omit this parameter, the IoT Greengrass Core software uses the default Windows user that you configure on
     * the Greengrass nucleus component. For more information, see <a href=
     * "https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-greengrass-core-v2.html#configure-component-user"
     * >Configure the user and group that run components</a>.
     * </p>
     * 
     * @return The Windows user to use to run this component on Windows core devices. The user must exist on each
     *         Windows core device, and its name and password must be in the LocalSystem account's Credentials Manager
     *         instance.</p>
     *         <p>
     *         If you omit this parameter, the IoT Greengrass Core software uses the default Windows user that you
     *         configure on the Greengrass nucleus component. For more information, see <a href=
     *         "https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-greengrass-core-v2.html#configure-component-user"
     *         >Configure the user and group that run components</a>.
     */
    public final String windowsUser() {
        return windowsUser;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(posixUser());
        hashCode = 31 * hashCode + Objects.hashCode(systemResourceLimits());
        hashCode = 31 * hashCode + Objects.hashCode(windowsUser());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComponentRunWith)) {
            return false;
        }
        ComponentRunWith other = (ComponentRunWith) obj;
        return Objects.equals(posixUser(), other.posixUser())
                && Objects.equals(systemResourceLimits(), other.systemResourceLimits())
                && Objects.equals(windowsUser(), other.windowsUser());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ComponentRunWith").add("PosixUser", posixUser())
                .add("SystemResourceLimits", systemResourceLimits()).add("WindowsUser", windowsUser()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "posixUser":
            return Optional.ofNullable(clazz.cast(posixUser()));
        case "systemResourceLimits":
            return Optional.ofNullable(clazz.cast(systemResourceLimits()));
        case "windowsUser":
            return Optional.ofNullable(clazz.cast(windowsUser()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("posixUser", POSIX_USER_FIELD);
        map.put("systemResourceLimits", SYSTEM_RESOURCE_LIMITS_FIELD);
        map.put("windowsUser", WINDOWS_USER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ComponentRunWith, T> g) {
        return obj -> g.apply((ComponentRunWith) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ComponentRunWith> {
        /**
         * <p>
         * The POSIX system user and, optionally, group to use to run this component on Linux core devices. The user,
         * and group if specified, must exist on each Linux core device. Specify the user and group separated by a colon
         * (<code>:</code>) in the following format: <code>user:group</code>. The group is optional. If you don't
         * specify a group, the IoT Greengrass Core software uses the primary user for the group.
         * </p>
         * <p>
         * If you omit this parameter, the IoT Greengrass Core software uses the default system user and group that you
         * configure on the Greengrass nucleus component. For more information, see <a href=
         * "https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-greengrass-core-v2.html#configure-component-user"
         * >Configure the user and group that run components</a>.
         * </p>
         * 
         * @param posixUser
         *        The POSIX system user and, optionally, group to use to run this component on Linux core devices. The
         *        user, and group if specified, must exist on each Linux core device. Specify the user and group
         *        separated by a colon (<code>:</code>) in the following format: <code>user:group</code>. The group is
         *        optional. If you don't specify a group, the IoT Greengrass Core software uses the primary user for the
         *        group.</p>
         *        <p>
         *        If you omit this parameter, the IoT Greengrass Core software uses the default system user and group
         *        that you configure on the Greengrass nucleus component. For more information, see <a href=
         *        "https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-greengrass-core-v2.html#configure-component-user"
         *        >Configure the user and group that run components</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder posixUser(String posixUser);

        /**
         * <p>
         * The system resource limits to apply to this component's process on the core device. IoT Greengrass currently
         * supports this feature on only Linux core devices.
         * </p>
         * <p>
         * If you omit this parameter, the IoT Greengrass Core software uses the default system resource limits that you
         * configure on the Greengrass nucleus component. For more information, see <a href=
         * "https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-greengrass-core-v2.html#configure-component-system-resource-limits"
         * >Configure system resource limits for components</a>.
         * </p>
         * 
         * @param systemResourceLimits
         *        The system resource limits to apply to this component's process on the core device. IoT Greengrass
         *        currently supports this feature on only Linux core devices.</p>
         *        <p>
         *        If you omit this parameter, the IoT Greengrass Core software uses the default system resource limits
         *        that you configure on the Greengrass nucleus component. For more information, see <a href=
         *        "https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-greengrass-core-v2.html#configure-component-system-resource-limits"
         *        >Configure system resource limits for components</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder systemResourceLimits(SystemResourceLimits systemResourceLimits);

        /**
         * <p>
         * The system resource limits to apply to this component's process on the core device. IoT Greengrass currently
         * supports this feature on only Linux core devices.
         * </p>
         * <p>
         * If you omit this parameter, the IoT Greengrass Core software uses the default system resource limits that you
         * configure on the Greengrass nucleus component. For more information, see <a href=
         * "https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-greengrass-core-v2.html#configure-component-system-resource-limits"
         * >Configure system resource limits for components</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link SystemResourceLimits.Builder} avoiding
         * the need to create one manually via {@link SystemResourceLimits#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SystemResourceLimits.Builder#build()} is called immediately and
         * its result is passed to {@link #systemResourceLimits(SystemResourceLimits)}.
         * 
         * @param systemResourceLimits
         *        a consumer that will call methods on {@link SystemResourceLimits.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #systemResourceLimits(SystemResourceLimits)
         */
        default Builder systemResourceLimits(Consumer<SystemResourceLimits.Builder> systemResourceLimits) {
            return systemResourceLimits(SystemResourceLimits.builder().applyMutation(systemResourceLimits).build());
        }

        /**
         * <p>
         * The Windows user to use to run this component on Windows core devices. The user must exist on each Windows
         * core device, and its name and password must be in the LocalSystem account's Credentials Manager instance.
         * </p>
         * <p>
         * If you omit this parameter, the IoT Greengrass Core software uses the default Windows user that you configure
         * on the Greengrass nucleus component. For more information, see <a href=
         * "https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-greengrass-core-v2.html#configure-component-user"
         * >Configure the user and group that run components</a>.
         * </p>
         * 
         * @param windowsUser
         *        The Windows user to use to run this component on Windows core devices. The user must exist on each
         *        Windows core device, and its name and password must be in the LocalSystem account's Credentials
         *        Manager instance.</p>
         *        <p>
         *        If you omit this parameter, the IoT Greengrass Core software uses the default Windows user that you
         *        configure on the Greengrass nucleus component. For more information, see <a href=
         *        "https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-greengrass-core-v2.html#configure-component-user"
         *        >Configure the user and group that run components</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowsUser(String windowsUser);
    }

    static final class BuilderImpl implements Builder {
        private String posixUser;

        private SystemResourceLimits systemResourceLimits;

        private String windowsUser;

        private BuilderImpl() {
        }

        private BuilderImpl(ComponentRunWith model) {
            posixUser(model.posixUser);
            systemResourceLimits(model.systemResourceLimits);
            windowsUser(model.windowsUser);
        }

        public final String getPosixUser() {
            return posixUser;
        }

        public final void setPosixUser(String posixUser) {
            this.posixUser = posixUser;
        }

        @Override
        public final Builder posixUser(String posixUser) {
            this.posixUser = posixUser;
            return this;
        }

        public final SystemResourceLimits.Builder getSystemResourceLimits() {
            return systemResourceLimits != null ? systemResourceLimits.toBuilder() : null;
        }

        public final void setSystemResourceLimits(SystemResourceLimits.BuilderImpl systemResourceLimits) {
            this.systemResourceLimits = systemResourceLimits != null ? systemResourceLimits.build() : null;
        }

        @Override
        public final Builder systemResourceLimits(SystemResourceLimits systemResourceLimits) {
            this.systemResourceLimits = systemResourceLimits;
            return this;
        }

        public final String getWindowsUser() {
            return windowsUser;
        }

        public final void setWindowsUser(String windowsUser) {
            this.windowsUser = windowsUser;
        }

        @Override
        public final Builder windowsUser(String windowsUser) {
            this.windowsUser = windowsUser;
            return this;
        }

        @Override
        public ComponentRunWith build() {
            return new ComponentRunWith(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
