/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrassv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains all error-related information for the deployment record. The status details will be null if the deployment
 * is in a success state.
 * </p>
 * <note>
 * <p>
 * Greengrass nucleus v2.8.0 or later is required to get an accurate <code>errorStack</code> and <code>errorTypes</code>
 * response. This field will not be returned for earlier Greengrass nucleus versions.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EffectiveDeploymentStatusDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<EffectiveDeploymentStatusDetails.Builder, EffectiveDeploymentStatusDetails> {
    private static final SdkField<List<String>> ERROR_STACK_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("errorStack")
            .getter(getter(EffectiveDeploymentStatusDetails::errorStack))
            .setter(setter(Builder::errorStack))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorStack").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ERROR_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("errorTypes")
            .getter(getter(EffectiveDeploymentStatusDetails::errorTypes))
            .setter(setter(Builder::errorTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_STACK_FIELD,
            ERROR_TYPES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> errorStack;

    private final List<String> errorTypes;

    private EffectiveDeploymentStatusDetails(BuilderImpl builder) {
        this.errorStack = builder.errorStack;
        this.errorTypes = builder.errorTypes;
    }

    /**
     * For responses, this returns true if the service returned a value for the ErrorStack property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasErrorStack() {
        return errorStack != null && !(errorStack instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains an ordered list of short error codes that range from the most generic error to the most specific one.
     * The error codes describe the reason for failure whenever the <code>coreDeviceExecutionStatus</code> is in a
     * failed state. The response will be an empty list if there is no error.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasErrorStack} method.
     * </p>
     * 
     * @return Contains an ordered list of short error codes that range from the most generic error to the most specific
     *         one. The error codes describe the reason for failure whenever the <code>coreDeviceExecutionStatus</code>
     *         is in a failed state. The response will be an empty list if there is no error.
     */
    public final List<String> errorStack() {
        return errorStack;
    }

    /**
     * For responses, this returns true if the service returned a value for the ErrorTypes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasErrorTypes() {
        return errorTypes != null && !(errorTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains tags which describe the error. You can use the error types to classify errors to assist with remediating
     * the failure. The response will be an empty list if there is no error.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasErrorTypes} method.
     * </p>
     * 
     * @return Contains tags which describe the error. You can use the error types to classify errors to assist with
     *         remediating the failure. The response will be an empty list if there is no error.
     */
    public final List<String> errorTypes() {
        return errorTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasErrorStack() ? errorStack() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasErrorTypes() ? errorTypes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EffectiveDeploymentStatusDetails)) {
            return false;
        }
        EffectiveDeploymentStatusDetails other = (EffectiveDeploymentStatusDetails) obj;
        return hasErrorStack() == other.hasErrorStack() && Objects.equals(errorStack(), other.errorStack())
                && hasErrorTypes() == other.hasErrorTypes() && Objects.equals(errorTypes(), other.errorTypes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EffectiveDeploymentStatusDetails").add("ErrorStack", hasErrorStack() ? errorStack() : null)
                .add("ErrorTypes", hasErrorTypes() ? errorTypes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "errorStack":
            return Optional.ofNullable(clazz.cast(errorStack()));
        case "errorTypes":
            return Optional.ofNullable(clazz.cast(errorTypes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("errorStack", ERROR_STACK_FIELD);
        map.put("errorTypes", ERROR_TYPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EffectiveDeploymentStatusDetails, T> g) {
        return obj -> g.apply((EffectiveDeploymentStatusDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EffectiveDeploymentStatusDetails> {
        /**
         * <p>
         * Contains an ordered list of short error codes that range from the most generic error to the most specific
         * one. The error codes describe the reason for failure whenever the <code>coreDeviceExecutionStatus</code> is
         * in a failed state. The response will be an empty list if there is no error.
         * </p>
         * 
         * @param errorStack
         *        Contains an ordered list of short error codes that range from the most generic error to the most
         *        specific one. The error codes describe the reason for failure whenever the
         *        <code>coreDeviceExecutionStatus</code> is in a failed state. The response will be an empty list if
         *        there is no error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorStack(Collection<String> errorStack);

        /**
         * <p>
         * Contains an ordered list of short error codes that range from the most generic error to the most specific
         * one. The error codes describe the reason for failure whenever the <code>coreDeviceExecutionStatus</code> is
         * in a failed state. The response will be an empty list if there is no error.
         * </p>
         * 
         * @param errorStack
         *        Contains an ordered list of short error codes that range from the most generic error to the most
         *        specific one. The error codes describe the reason for failure whenever the
         *        <code>coreDeviceExecutionStatus</code> is in a failed state. The response will be an empty list if
         *        there is no error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorStack(String... errorStack);

        /**
         * <p>
         * Contains tags which describe the error. You can use the error types to classify errors to assist with
         * remediating the failure. The response will be an empty list if there is no error.
         * </p>
         * 
         * @param errorTypes
         *        Contains tags which describe the error. You can use the error types to classify errors to assist with
         *        remediating the failure. The response will be an empty list if there is no error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorTypes(Collection<String> errorTypes);

        /**
         * <p>
         * Contains tags which describe the error. You can use the error types to classify errors to assist with
         * remediating the failure. The response will be an empty list if there is no error.
         * </p>
         * 
         * @param errorTypes
         *        Contains tags which describe the error. You can use the error types to classify errors to assist with
         *        remediating the failure. The response will be an empty list if there is no error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorTypes(String... errorTypes);
    }

    static final class BuilderImpl implements Builder {
        private List<String> errorStack = DefaultSdkAutoConstructList.getInstance();

        private List<String> errorTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EffectiveDeploymentStatusDetails model) {
            errorStack(model.errorStack);
            errorTypes(model.errorTypes);
        }

        public final Collection<String> getErrorStack() {
            if (errorStack instanceof SdkAutoConstructList) {
                return null;
            }
            return errorStack;
        }

        public final void setErrorStack(Collection<String> errorStack) {
            this.errorStack = EffectiveDeploymentErrorStackCopier.copy(errorStack);
        }

        @Override
        public final Builder errorStack(Collection<String> errorStack) {
            this.errorStack = EffectiveDeploymentErrorStackCopier.copy(errorStack);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorStack(String... errorStack) {
            errorStack(Arrays.asList(errorStack));
            return this;
        }

        public final Collection<String> getErrorTypes() {
            if (errorTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return errorTypes;
        }

        public final void setErrorTypes(Collection<String> errorTypes) {
            this.errorTypes = EffectiveDeploymentErrorTypeListCopier.copy(errorTypes);
        }

        @Override
        public final Builder errorTypes(Collection<String> errorTypes) {
            this.errorTypes = EffectiveDeploymentErrorTypeListCopier.copy(errorTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorTypes(String... errorTypes) {
            errorTypes(Arrays.asList(errorTypes));
            return this;
        }

        @Override
        public EffectiveDeploymentStatusDetails build() {
            return new EffectiveDeploymentStatusDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
