/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrassv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListInstalledComponentsRequest extends GreengrassV2Request implements
        ToCopyableBuilder<ListInstalledComponentsRequest.Builder, ListInstalledComponentsRequest> {
    private static final SdkField<String> CORE_DEVICE_THING_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("coreDeviceThingName").getter(getter(ListInstalledComponentsRequest::coreDeviceThingName))
            .setter(setter(Builder::coreDeviceThingName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("coreDeviceThingName").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListInstalledComponentsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListInstalledComponentsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<String> TOPOLOGY_FILTER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("topologyFilter").getter(getter(ListInstalledComponentsRequest::topologyFilterAsString))
            .setter(setter(Builder::topologyFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("topologyFilter").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CORE_DEVICE_THING_NAME_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, TOPOLOGY_FILTER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String coreDeviceThingName;

    private final Integer maxResults;

    private final String nextToken;

    private final String topologyFilter;

    private ListInstalledComponentsRequest(BuilderImpl builder) {
        super(builder);
        this.coreDeviceThingName = builder.coreDeviceThingName;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.topologyFilter = builder.topologyFilter;
    }

    /**
     * <p>
     * The name of the core device. This is also the name of the IoT thing.
     * </p>
     * 
     * @return The name of the core device. This is also the name of the IoT thing.
     */
    public final String coreDeviceThingName() {
        return coreDeviceThingName;
    }

    /**
     * <p>
     * The maximum number of results to be returned per paginated request.
     * </p>
     * 
     * @return The maximum number of results to be returned per paginated request.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token to be used for the next set of paginated results.
     * </p>
     * 
     * @return The token to be used for the next set of paginated results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The filter for the list of components. Choose from the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ALL</code> – The list includes all components installed on the core device.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ROOT</code> – The list includes only <i>root</i> components, which are components that you specify in a
     * deployment. When you choose this option, the list doesn't include components that the core device installs as
     * dependencies of other components.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Default: <code>ROOT</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #topologyFilter}
     * will return {@link InstalledComponentTopologyFilter#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #topologyFilterAsString}.
     * </p>
     * 
     * @return The filter for the list of components. Choose from the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ALL</code> – The list includes all components installed on the core device.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ROOT</code> – The list includes only <i>root</i> components, which are components that you specify
     *         in a deployment. When you choose this option, the list doesn't include components that the core device
     *         installs as dependencies of other components.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Default: <code>ROOT</code>
     * @see InstalledComponentTopologyFilter
     */
    public final InstalledComponentTopologyFilter topologyFilter() {
        return InstalledComponentTopologyFilter.fromValue(topologyFilter);
    }

    /**
     * <p>
     * The filter for the list of components. Choose from the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ALL</code> – The list includes all components installed on the core device.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ROOT</code> – The list includes only <i>root</i> components, which are components that you specify in a
     * deployment. When you choose this option, the list doesn't include components that the core device installs as
     * dependencies of other components.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Default: <code>ROOT</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #topologyFilter}
     * will return {@link InstalledComponentTopologyFilter#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #topologyFilterAsString}.
     * </p>
     * 
     * @return The filter for the list of components. Choose from the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ALL</code> – The list includes all components installed on the core device.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ROOT</code> – The list includes only <i>root</i> components, which are components that you specify
     *         in a deployment. When you choose this option, the list doesn't include components that the core device
     *         installs as dependencies of other components.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Default: <code>ROOT</code>
     * @see InstalledComponentTopologyFilter
     */
    public final String topologyFilterAsString() {
        return topologyFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(coreDeviceThingName());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(topologyFilterAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInstalledComponentsRequest)) {
            return false;
        }
        ListInstalledComponentsRequest other = (ListInstalledComponentsRequest) obj;
        return Objects.equals(coreDeviceThingName(), other.coreDeviceThingName())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(topologyFilterAsString(), other.topologyFilterAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListInstalledComponentsRequest").add("CoreDeviceThingName", coreDeviceThingName())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).add("TopologyFilter", topologyFilterAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "coreDeviceThingName":
            return Optional.ofNullable(clazz.cast(coreDeviceThingName()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "topologyFilter":
            return Optional.ofNullable(clazz.cast(topologyFilterAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("coreDeviceThingName", CORE_DEVICE_THING_NAME_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("topologyFilter", TOPOLOGY_FILTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListInstalledComponentsRequest, T> g) {
        return obj -> g.apply((ListInstalledComponentsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GreengrassV2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, ListInstalledComponentsRequest> {
        /**
         * <p>
         * The name of the core device. This is also the name of the IoT thing.
         * </p>
         * 
         * @param coreDeviceThingName
         *        The name of the core device. This is also the name of the IoT thing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coreDeviceThingName(String coreDeviceThingName);

        /**
         * <p>
         * The maximum number of results to be returned per paginated request.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to be returned per paginated request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token to be used for the next set of paginated results.
         * </p>
         * 
         * @param nextToken
         *        The token to be used for the next set of paginated results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The filter for the list of components. Choose from the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ALL</code> – The list includes all components installed on the core device.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ROOT</code> – The list includes only <i>root</i> components, which are components that you specify in a
         * deployment. When you choose this option, the list doesn't include components that the core device installs as
         * dependencies of other components.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Default: <code>ROOT</code>
         * </p>
         * 
         * @param topologyFilter
         *        The filter for the list of components. Choose from the following options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ALL</code> – The list includes all components installed on the core device.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ROOT</code> – The list includes only <i>root</i> components, which are components that you
         *        specify in a deployment. When you choose this option, the list doesn't include components that the
         *        core device installs as dependencies of other components.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Default: <code>ROOT</code>
         * @see InstalledComponentTopologyFilter
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstalledComponentTopologyFilter
         */
        Builder topologyFilter(String topologyFilter);

        /**
         * <p>
         * The filter for the list of components. Choose from the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ALL</code> – The list includes all components installed on the core device.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ROOT</code> – The list includes only <i>root</i> components, which are components that you specify in a
         * deployment. When you choose this option, the list doesn't include components that the core device installs as
         * dependencies of other components.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Default: <code>ROOT</code>
         * </p>
         * 
         * @param topologyFilter
         *        The filter for the list of components. Choose from the following options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ALL</code> – The list includes all components installed on the core device.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ROOT</code> – The list includes only <i>root</i> components, which are components that you
         *        specify in a deployment. When you choose this option, the list doesn't include components that the
         *        core device installs as dependencies of other components.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Default: <code>ROOT</code>
         * @see InstalledComponentTopologyFilter
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstalledComponentTopologyFilter
         */
        Builder topologyFilter(InstalledComponentTopologyFilter topologyFilter);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GreengrassV2Request.BuilderImpl implements Builder {
        private String coreDeviceThingName;

        private Integer maxResults;

        private String nextToken;

        private String topologyFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInstalledComponentsRequest model) {
            super(model);
            coreDeviceThingName(model.coreDeviceThingName);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            topologyFilter(model.topologyFilter);
        }

        public final String getCoreDeviceThingName() {
            return coreDeviceThingName;
        }

        public final void setCoreDeviceThingName(String coreDeviceThingName) {
            this.coreDeviceThingName = coreDeviceThingName;
        }

        @Override
        public final Builder coreDeviceThingName(String coreDeviceThingName) {
            this.coreDeviceThingName = coreDeviceThingName;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getTopologyFilter() {
            return topologyFilter;
        }

        public final void setTopologyFilter(String topologyFilter) {
            this.topologyFilter = topologyFilter;
        }

        @Override
        public final Builder topologyFilter(String topologyFilter) {
            this.topologyFilter = topologyFilter;
            return this;
        }

        @Override
        public final Builder topologyFilter(InstalledComponentTopologyFilter topologyFilter) {
            this.topologyFilter(topologyFilter == null ? null : topologyFilter.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListInstalledComponentsRequest build() {
            return new ListInstalledComponentsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
