/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrassv2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.greengrassv2.model.CloudComponentStatus;
import software.amazon.awssdk.services.greengrassv2.model.ComponentPlatform;
import software.amazon.awssdk.services.greengrassv2.model.ComponentPlatformListCopier;
import software.amazon.awssdk.services.greengrassv2.model.GreengrassV2Response;
import software.amazon.awssdk.services.greengrassv2.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeComponentResponse
extends GreengrassV2Response
implements ToCopyableBuilder<Builder, DescribeComponentResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(DescribeComponentResponse.getter(DescribeComponentResponse::arn)).setter(DescribeComponentResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> COMPONENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("componentName").getter(DescribeComponentResponse.getter(DescribeComponentResponse::componentName)).setter(DescribeComponentResponse.setter(Builder::componentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentName").build()}).build();
    private static final SdkField<String> COMPONENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("componentVersion").getter(DescribeComponentResponse.getter(DescribeComponentResponse::componentVersion)).setter(DescribeComponentResponse.setter(Builder::componentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentVersion").build()}).build();
    private static final SdkField<Instant> CREATION_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTimestamp").getter(DescribeComponentResponse.getter(DescribeComponentResponse::creationTimestamp)).setter(DescribeComponentResponse.setter(Builder::creationTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTimestamp").build()}).build();
    private static final SdkField<String> PUBLISHER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("publisher").getter(DescribeComponentResponse.getter(DescribeComponentResponse::publisher)).setter(DescribeComponentResponse.setter(Builder::publisher)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publisher").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(DescribeComponentResponse.getter(DescribeComponentResponse::description)).setter(DescribeComponentResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<CloudComponentStatus> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("status").getter(DescribeComponentResponse.getter(DescribeComponentResponse::status)).setter(DescribeComponentResponse.setter(Builder::status)).constructor(CloudComponentStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<List<ComponentPlatform>> PLATFORMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("platforms").getter(DescribeComponentResponse.getter(DescribeComponentResponse::platforms)).setter(DescribeComponentResponse.setter(Builder::platforms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platforms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ComponentPlatform::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(DescribeComponentResponse.getter(DescribeComponentResponse::tags)).setter(DescribeComponentResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, COMPONENT_NAME_FIELD, COMPONENT_VERSION_FIELD, CREATION_TIMESTAMP_FIELD, PUBLISHER_FIELD, DESCRIPTION_FIELD, STATUS_FIELD, PLATFORMS_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeComponentResponse.memberNameToFieldInitializer();
    private final String arn;
    private final String componentName;
    private final String componentVersion;
    private final Instant creationTimestamp;
    private final String publisher;
    private final String description;
    private final CloudComponentStatus status;
    private final List<ComponentPlatform> platforms;
    private final Map<String, String> tags;

    private DescribeComponentResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.componentName = builder.componentName;
        this.componentVersion = builder.componentVersion;
        this.creationTimestamp = builder.creationTimestamp;
        this.publisher = builder.publisher;
        this.description = builder.description;
        this.status = builder.status;
        this.platforms = builder.platforms;
        this.tags = builder.tags;
    }

    public final String arn() {
        return this.arn;
    }

    public final String componentName() {
        return this.componentName;
    }

    public final String componentVersion() {
        return this.componentVersion;
    }

    public final Instant creationTimestamp() {
        return this.creationTimestamp;
    }

    public final String publisher() {
        return this.publisher;
    }

    public final String description() {
        return this.description;
    }

    public final CloudComponentStatus status() {
        return this.status;
    }

    public final boolean hasPlatforms() {
        return this.platforms != null && !(this.platforms instanceof SdkAutoConstructList);
    }

    public final List<ComponentPlatform> platforms() {
        return this.platforms;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.componentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.componentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.publisher());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPlatforms() ? this.platforms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeComponentResponse)) {
            return false;
        }
        DescribeComponentResponse other = (DescribeComponentResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.componentName(), other.componentName()) && Objects.equals(this.componentVersion(), other.componentVersion()) && Objects.equals(this.creationTimestamp(), other.creationTimestamp()) && Objects.equals(this.publisher(), other.publisher()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.status(), other.status()) && this.hasPlatforms() == other.hasPlatforms() && Objects.equals(this.platforms(), other.platforms()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeComponentResponse").add("Arn", (Object)this.arn()).add("ComponentName", (Object)this.componentName()).add("ComponentVersion", (Object)this.componentVersion()).add("CreationTimestamp", (Object)this.creationTimestamp()).add("Publisher", (Object)this.publisher()).add("Description", (Object)this.description()).add("Status", (Object)this.status()).add("Platforms", this.hasPlatforms() ? this.platforms() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "componentName": {
                return Optional.ofNullable(clazz.cast(this.componentName()));
            }
            case "componentVersion": {
                return Optional.ofNullable(clazz.cast(this.componentVersion()));
            }
            case "creationTimestamp": {
                return Optional.ofNullable(clazz.cast(this.creationTimestamp()));
            }
            case "publisher": {
                return Optional.ofNullable(clazz.cast(this.publisher()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "platforms": {
                return Optional.ofNullable(clazz.cast(this.platforms()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arn", ARN_FIELD);
        map.put("componentName", COMPONENT_NAME_FIELD);
        map.put("componentVersion", COMPONENT_VERSION_FIELD);
        map.put("creationTimestamp", CREATION_TIMESTAMP_FIELD);
        map.put("publisher", PUBLISHER_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("platforms", PLATFORMS_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeComponentResponse, T> g) {
        return obj -> g.apply((DescribeComponentResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GreengrassV2Response.BuilderImpl
    implements Builder {
        private String arn;
        private String componentName;
        private String componentVersion;
        private Instant creationTimestamp;
        private String publisher;
        private String description;
        private CloudComponentStatus status;
        private List<ComponentPlatform> platforms = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeComponentResponse model) {
            super(model);
            this.arn(model.arn);
            this.componentName(model.componentName);
            this.componentVersion(model.componentVersion);
            this.creationTimestamp(model.creationTimestamp);
            this.publisher(model.publisher);
            this.description(model.description);
            this.status(model.status);
            this.platforms(model.platforms);
            this.tags(model.tags);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getComponentName() {
            return this.componentName;
        }

        public final void setComponentName(String componentName) {
            this.componentName = componentName;
        }

        @Override
        public final Builder componentName(String componentName) {
            this.componentName = componentName;
            return this;
        }

        public final String getComponentVersion() {
            return this.componentVersion;
        }

        public final void setComponentVersion(String componentVersion) {
            this.componentVersion = componentVersion;
        }

        @Override
        public final Builder componentVersion(String componentVersion) {
            this.componentVersion = componentVersion;
            return this;
        }

        public final Instant getCreationTimestamp() {
            return this.creationTimestamp;
        }

        public final void setCreationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
        }

        @Override
        public final Builder creationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public final String getPublisher() {
            return this.publisher;
        }

        public final void setPublisher(String publisher) {
            this.publisher = publisher;
        }

        @Override
        public final Builder publisher(String publisher) {
            this.publisher = publisher;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final CloudComponentStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        public final void setStatus(CloudComponentStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(CloudComponentStatus status) {
            this.status = status;
            return this;
        }

        public final List<ComponentPlatform.Builder> getPlatforms() {
            List<ComponentPlatform.Builder> result = ComponentPlatformListCopier.copyToBuilder(this.platforms);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPlatforms(Collection<ComponentPlatform.BuilderImpl> platforms) {
            this.platforms = ComponentPlatformListCopier.copyFromBuilder(platforms);
        }

        @Override
        public final Builder platforms(Collection<ComponentPlatform> platforms) {
            this.platforms = ComponentPlatformListCopier.copy(platforms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder platforms(ComponentPlatform ... platforms) {
            this.platforms(Arrays.asList(platforms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder platforms(Consumer<ComponentPlatform.Builder> ... platforms) {
            this.platforms(Stream.of(platforms).map(c -> (ComponentPlatform)((ComponentPlatform.Builder)ComponentPlatform.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public DescribeComponentResponse build() {
            return new DescribeComponentResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GreengrassV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeComponentResponse> {
        public Builder arn(String var1);

        public Builder componentName(String var1);

        public Builder componentVersion(String var1);

        public Builder creationTimestamp(Instant var1);

        public Builder publisher(String var1);

        public Builder description(String var1);

        public Builder status(CloudComponentStatus var1);

        default public Builder status(Consumer<CloudComponentStatus.Builder> status) {
            return this.status((CloudComponentStatus)((CloudComponentStatus.Builder)CloudComponentStatus.builder().applyMutation(status)).build());
        }

        public Builder platforms(Collection<ComponentPlatform> var1);

        public Builder platforms(ComponentPlatform ... var1);

        public Builder platforms(Consumer<ComponentPlatform.Builder> ... var1);

        public Builder tags(Map<String, String> var1);
    }
}

