/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrassv2.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.greengrassv2.model.VendorGuidance;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResolvedComponentVersion
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResolvedComponentVersion> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(ResolvedComponentVersion.getter(ResolvedComponentVersion::arn)).setter(ResolvedComponentVersion.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> COMPONENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("componentName").getter(ResolvedComponentVersion.getter(ResolvedComponentVersion::componentName)).setter(ResolvedComponentVersion.setter(Builder::componentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentName").build()}).build();
    private static final SdkField<String> COMPONENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("componentVersion").getter(ResolvedComponentVersion.getter(ResolvedComponentVersion::componentVersion)).setter(ResolvedComponentVersion.setter(Builder::componentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentVersion").build()}).build();
    private static final SdkField<SdkBytes> RECIPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("recipe").getter(ResolvedComponentVersion.getter(ResolvedComponentVersion::recipe)).setter(ResolvedComponentVersion.setter(Builder::recipe)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recipe").build()}).build();
    private static final SdkField<String> VENDOR_GUIDANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vendorGuidance").getter(ResolvedComponentVersion.getter(ResolvedComponentVersion::vendorGuidanceAsString)).setter(ResolvedComponentVersion.setter(Builder::vendorGuidance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vendorGuidance").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("message").getter(ResolvedComponentVersion.getter(ResolvedComponentVersion::message)).setter(ResolvedComponentVersion.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, COMPONENT_NAME_FIELD, COMPONENT_VERSION_FIELD, RECIPE_FIELD, VENDOR_GUIDANCE_FIELD, MESSAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ResolvedComponentVersion.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String componentName;
    private final String componentVersion;
    private final SdkBytes recipe;
    private final String vendorGuidance;
    private final String message;

    private ResolvedComponentVersion(BuilderImpl builder) {
        this.arn = builder.arn;
        this.componentName = builder.componentName;
        this.componentVersion = builder.componentVersion;
        this.recipe = builder.recipe;
        this.vendorGuidance = builder.vendorGuidance;
        this.message = builder.message;
    }

    public final String arn() {
        return this.arn;
    }

    public final String componentName() {
        return this.componentName;
    }

    public final String componentVersion() {
        return this.componentVersion;
    }

    public final SdkBytes recipe() {
        return this.recipe;
    }

    public final VendorGuidance vendorGuidance() {
        return VendorGuidance.fromValue(this.vendorGuidance);
    }

    public final String vendorGuidanceAsString() {
        return this.vendorGuidance;
    }

    public final String message() {
        return this.message;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.componentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.componentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.recipe());
        hashCode = 31 * hashCode + Objects.hashCode(this.vendorGuidanceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResolvedComponentVersion)) {
            return false;
        }
        ResolvedComponentVersion other = (ResolvedComponentVersion)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.componentName(), other.componentName()) && Objects.equals(this.componentVersion(), other.componentVersion()) && Objects.equals(this.recipe(), other.recipe()) && Objects.equals(this.vendorGuidanceAsString(), other.vendorGuidanceAsString()) && Objects.equals(this.message(), other.message());
    }

    public final String toString() {
        return ToString.builder((String)"ResolvedComponentVersion").add("Arn", (Object)this.arn()).add("ComponentName", (Object)this.componentName()).add("ComponentVersion", (Object)this.componentVersion()).add("Recipe", (Object)this.recipe()).add("VendorGuidance", (Object)this.vendorGuidanceAsString()).add("Message", (Object)this.message()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "componentName": {
                return Optional.ofNullable(clazz.cast(this.componentName()));
            }
            case "componentVersion": {
                return Optional.ofNullable(clazz.cast(this.componentVersion()));
            }
            case "recipe": {
                return Optional.ofNullable(clazz.cast(this.recipe()));
            }
            case "vendorGuidance": {
                return Optional.ofNullable(clazz.cast(this.vendorGuidanceAsString()));
            }
            case "message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arn", ARN_FIELD);
        map.put("componentName", COMPONENT_NAME_FIELD);
        map.put("componentVersion", COMPONENT_VERSION_FIELD);
        map.put("recipe", RECIPE_FIELD);
        map.put("vendorGuidance", VENDOR_GUIDANCE_FIELD);
        map.put("message", MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResolvedComponentVersion, T> g) {
        return obj -> g.apply((ResolvedComponentVersion)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String componentName;
        private String componentVersion;
        private SdkBytes recipe;
        private String vendorGuidance;
        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(ResolvedComponentVersion model) {
            this.arn(model.arn);
            this.componentName(model.componentName);
            this.componentVersion(model.componentVersion);
            this.recipe(model.recipe);
            this.vendorGuidance(model.vendorGuidance);
            this.message(model.message);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getComponentName() {
            return this.componentName;
        }

        public final void setComponentName(String componentName) {
            this.componentName = componentName;
        }

        @Override
        public final Builder componentName(String componentName) {
            this.componentName = componentName;
            return this;
        }

        public final String getComponentVersion() {
            return this.componentVersion;
        }

        public final void setComponentVersion(String componentVersion) {
            this.componentVersion = componentVersion;
        }

        @Override
        public final Builder componentVersion(String componentVersion) {
            this.componentVersion = componentVersion;
            return this;
        }

        public final ByteBuffer getRecipe() {
            return this.recipe == null ? null : this.recipe.asByteBuffer();
        }

        public final void setRecipe(ByteBuffer recipe) {
            this.recipe(recipe == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)recipe));
        }

        @Override
        public final Builder recipe(SdkBytes recipe) {
            this.recipe = recipe;
            return this;
        }

        public final String getVendorGuidance() {
            return this.vendorGuidance;
        }

        public final void setVendorGuidance(String vendorGuidance) {
            this.vendorGuidance = vendorGuidance;
        }

        @Override
        public final Builder vendorGuidance(String vendorGuidance) {
            this.vendorGuidance = vendorGuidance;
            return this;
        }

        @Override
        public final Builder vendorGuidance(VendorGuidance vendorGuidance) {
            this.vendorGuidance(vendorGuidance == null ? null : vendorGuidance.toString());
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public ResolvedComponentVersion build() {
            return new ResolvedComponentVersion(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResolvedComponentVersion> {
        public Builder arn(String var1);

        public Builder componentName(String var1);

        public Builder componentVersion(String var1);

        public Builder recipe(SdkBytes var1);

        public Builder vendorGuidance(String var1);

        public Builder vendorGuidance(VendorGuidance var1);

        public Builder message(String var1);
    }
}

