/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrassv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about an endpoint and port where client devices can connect to an MQTT broker on a Greengrass
 * core device.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConnectivityInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<ConnectivityInfo.Builder, ConnectivityInfo> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(ConnectivityInfo::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> HOST_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("hostAddress").getter(getter(ConnectivityInfo::hostAddress)).setter(setter(Builder::hostAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostAddress").build()).build();

    private static final SdkField<Integer> PORT_NUMBER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("portNumber").getter(getter(ConnectivityInfo::portNumber)).setter(setter(Builder::portNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PortNumber").build()).build();

    private static final SdkField<String> METADATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("metadata").getter(getter(ConnectivityInfo::metadata)).setter(setter(Builder::metadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metadata").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, HOST_ADDRESS_FIELD,
            PORT_NUMBER_FIELD, METADATA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String hostAddress;

    private final Integer portNumber;

    private final String metadata;

    private ConnectivityInfo(BuilderImpl builder) {
        this.id = builder.id;
        this.hostAddress = builder.hostAddress;
        this.portNumber = builder.portNumber;
        this.metadata = builder.metadata;
    }

    /**
     * <p>
     * An ID for the connectivity information.
     * </p>
     * 
     * @return An ID for the connectivity information.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The IP address or DNS address where client devices can connect to an MQTT broker on the Greengrass core device.
     * </p>
     * 
     * @return The IP address or DNS address where client devices can connect to an MQTT broker on the Greengrass core
     *         device.
     */
    public final String hostAddress() {
        return hostAddress;
    }

    /**
     * <p>
     * The port where the MQTT broker operates on the core device. This port is typically 8883, which is the default
     * port for the MQTT broker component that runs on core devices.
     * </p>
     * 
     * @return The port where the MQTT broker operates on the core device. This port is typically 8883, which is the
     *         default port for the MQTT broker component that runs on core devices.
     */
    public final Integer portNumber() {
        return portNumber;
    }

    /**
     * <p>
     * Additional metadata to provide to client devices that connect to this core device.
     * </p>
     * 
     * @return Additional metadata to provide to client devices that connect to this core device.
     */
    public final String metadata() {
        return metadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(hostAddress());
        hashCode = 31 * hashCode + Objects.hashCode(portNumber());
        hashCode = 31 * hashCode + Objects.hashCode(metadata());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectivityInfo)) {
            return false;
        }
        ConnectivityInfo other = (ConnectivityInfo) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(hostAddress(), other.hostAddress())
                && Objects.equals(portNumber(), other.portNumber()) && Objects.equals(metadata(), other.metadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConnectivityInfo").add("Id", id()).add("HostAddress", hostAddress())
                .add("PortNumber", portNumber()).add("Metadata", metadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "hostAddress":
            return Optional.ofNullable(clazz.cast(hostAddress()));
        case "portNumber":
            return Optional.ofNullable(clazz.cast(portNumber()));
        case "metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("HostAddress", HOST_ADDRESS_FIELD);
        map.put("PortNumber", PORT_NUMBER_FIELD);
        map.put("Metadata", METADATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConnectivityInfo, T> g) {
        return obj -> g.apply((ConnectivityInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConnectivityInfo> {
        /**
         * <p>
         * An ID for the connectivity information.
         * </p>
         * 
         * @param id
         *        An ID for the connectivity information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The IP address or DNS address where client devices can connect to an MQTT broker on the Greengrass core
         * device.
         * </p>
         * 
         * @param hostAddress
         *        The IP address or DNS address where client devices can connect to an MQTT broker on the Greengrass
         *        core device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostAddress(String hostAddress);

        /**
         * <p>
         * The port where the MQTT broker operates on the core device. This port is typically 8883, which is the default
         * port for the MQTT broker component that runs on core devices.
         * </p>
         * 
         * @param portNumber
         *        The port where the MQTT broker operates on the core device. This port is typically 8883, which is the
         *        default port for the MQTT broker component that runs on core devices.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portNumber(Integer portNumber);

        /**
         * <p>
         * Additional metadata to provide to client devices that connect to this core device.
         * </p>
         * 
         * @param metadata
         *        Additional metadata to provide to client devices that connect to this core device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(String metadata);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String hostAddress;

        private Integer portNumber;

        private String metadata;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectivityInfo model) {
            id(model.id);
            hostAddress(model.hostAddress);
            portNumber(model.portNumber);
            metadata(model.metadata);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getHostAddress() {
            return hostAddress;
        }

        public final void setHostAddress(String hostAddress) {
            this.hostAddress = hostAddress;
        }

        @Override
        public final Builder hostAddress(String hostAddress) {
            this.hostAddress = hostAddress;
            return this;
        }

        public final Integer getPortNumber() {
            return portNumber;
        }

        public final void setPortNumber(Integer portNumber) {
            this.portNumber = portNumber;
        }

        @Override
        public final Builder portNumber(Integer portNumber) {
            this.portNumber = portNumber;
            return this;
        }

        public final String getMetadata() {
            return metadata;
        }

        public final void setMetadata(String metadata) {
            this.metadata = metadata;
        }

        @Override
        public final Builder metadata(String metadata) {
            this.metadata = metadata;
            return this;
        }

        @Override
        public ConnectivityInfo build() {
            return new ConnectivityInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
