/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.groundstation.model.DataflowEdgeListCopier;
import software.amazon.awssdk.services.groundstation.model.GroundStationResponse;
import software.amazon.awssdk.services.groundstation.model.TagsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetMissionProfileResponse
extends GroundStationResponse
implements ToCopyableBuilder<Builder, GetMissionProfileResponse> {
    private static final SdkField<Integer> CONTACT_POST_PASS_DURATION_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(GetMissionProfileResponse.getter(GetMissionProfileResponse::contactPostPassDurationSeconds)).setter(GetMissionProfileResponse.setter(Builder::contactPostPassDurationSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contactPostPassDurationSeconds").build()}).build();
    private static final SdkField<Integer> CONTACT_PRE_PASS_DURATION_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(GetMissionProfileResponse.getter(GetMissionProfileResponse::contactPrePassDurationSeconds)).setter(GetMissionProfileResponse.setter(Builder::contactPrePassDurationSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contactPrePassDurationSeconds").build()}).build();
    private static final SdkField<List<List<String>>> DATAFLOW_EDGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetMissionProfileResponse.getter(GetMissionProfileResponse::dataflowEdges)).setter(GetMissionProfileResponse.setter(Builder::dataflowEdges)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataflowEdges").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<Integer> MINIMUM_VIABLE_CONTACT_DURATION_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(GetMissionProfileResponse.getter(GetMissionProfileResponse::minimumViableContactDurationSeconds)).setter(GetMissionProfileResponse.setter(Builder::minimumViableContactDurationSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minimumViableContactDurationSeconds").build()}).build();
    private static final SdkField<String> MISSION_PROFILE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetMissionProfileResponse.getter(GetMissionProfileResponse::missionProfileArn)).setter(GetMissionProfileResponse.setter(Builder::missionProfileArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("missionProfileArn").build()}).build();
    private static final SdkField<String> MISSION_PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetMissionProfileResponse.getter(GetMissionProfileResponse::missionProfileId)).setter(GetMissionProfileResponse.setter(Builder::missionProfileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("missionProfileId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetMissionProfileResponse.getter(GetMissionProfileResponse::name)).setter(GetMissionProfileResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetMissionProfileResponse.getter(GetMissionProfileResponse::region)).setter(GetMissionProfileResponse.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(GetMissionProfileResponse.getter(GetMissionProfileResponse::tags)).setter(GetMissionProfileResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> TRACKING_CONFIG_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetMissionProfileResponse.getter(GetMissionProfileResponse::trackingConfigArn)).setter(GetMissionProfileResponse.setter(Builder::trackingConfigArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trackingConfigArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_POST_PASS_DURATION_SECONDS_FIELD, CONTACT_PRE_PASS_DURATION_SECONDS_FIELD, DATAFLOW_EDGES_FIELD, MINIMUM_VIABLE_CONTACT_DURATION_SECONDS_FIELD, MISSION_PROFILE_ARN_FIELD, MISSION_PROFILE_ID_FIELD, NAME_FIELD, REGION_FIELD, TAGS_FIELD, TRACKING_CONFIG_ARN_FIELD));
    private final Integer contactPostPassDurationSeconds;
    private final Integer contactPrePassDurationSeconds;
    private final List<List<String>> dataflowEdges;
    private final Integer minimumViableContactDurationSeconds;
    private final String missionProfileArn;
    private final String missionProfileId;
    private final String name;
    private final String region;
    private final Map<String, String> tags;
    private final String trackingConfigArn;

    private GetMissionProfileResponse(BuilderImpl builder) {
        super(builder);
        this.contactPostPassDurationSeconds = builder.contactPostPassDurationSeconds;
        this.contactPrePassDurationSeconds = builder.contactPrePassDurationSeconds;
        this.dataflowEdges = builder.dataflowEdges;
        this.minimumViableContactDurationSeconds = builder.minimumViableContactDurationSeconds;
        this.missionProfileArn = builder.missionProfileArn;
        this.missionProfileId = builder.missionProfileId;
        this.name = builder.name;
        this.region = builder.region;
        this.tags = builder.tags;
        this.trackingConfigArn = builder.trackingConfigArn;
    }

    public Integer contactPostPassDurationSeconds() {
        return this.contactPostPassDurationSeconds;
    }

    public Integer contactPrePassDurationSeconds() {
        return this.contactPrePassDurationSeconds;
    }

    public List<List<String>> dataflowEdges() {
        return this.dataflowEdges;
    }

    public Integer minimumViableContactDurationSeconds() {
        return this.minimumViableContactDurationSeconds;
    }

    public String missionProfileArn() {
        return this.missionProfileArn;
    }

    public String missionProfileId() {
        return this.missionProfileId;
    }

    public String name() {
        return this.name;
    }

    public String region() {
        return this.region;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public String trackingConfigArn() {
        return this.trackingConfigArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.contactPostPassDurationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.contactPrePassDurationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataflowEdges());
        hashCode = 31 * hashCode + Objects.hashCode(this.minimumViableContactDurationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.missionProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.missionProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.trackingConfigArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMissionProfileResponse)) {
            return false;
        }
        GetMissionProfileResponse other = (GetMissionProfileResponse)((Object)obj);
        return Objects.equals(this.contactPostPassDurationSeconds(), other.contactPostPassDurationSeconds()) && Objects.equals(this.contactPrePassDurationSeconds(), other.contactPrePassDurationSeconds()) && Objects.equals(this.dataflowEdges(), other.dataflowEdges()) && Objects.equals(this.minimumViableContactDurationSeconds(), other.minimumViableContactDurationSeconds()) && Objects.equals(this.missionProfileArn(), other.missionProfileArn()) && Objects.equals(this.missionProfileId(), other.missionProfileId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.region(), other.region()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.trackingConfigArn(), other.trackingConfigArn());
    }

    public String toString() {
        return ToString.builder((String)"GetMissionProfileResponse").add("ContactPostPassDurationSeconds", (Object)this.contactPostPassDurationSeconds()).add("ContactPrePassDurationSeconds", (Object)this.contactPrePassDurationSeconds()).add("DataflowEdges", this.dataflowEdges()).add("MinimumViableContactDurationSeconds", (Object)this.minimumViableContactDurationSeconds()).add("MissionProfileArn", (Object)this.missionProfileArn()).add("MissionProfileId", (Object)this.missionProfileId()).add("Name", (Object)this.name()).add("Region", (Object)this.region()).add("Tags", this.tags()).add("TrackingConfigArn", (Object)this.trackingConfigArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "contactPostPassDurationSeconds": {
                return Optional.ofNullable(clazz.cast(this.contactPostPassDurationSeconds()));
            }
            case "contactPrePassDurationSeconds": {
                return Optional.ofNullable(clazz.cast(this.contactPrePassDurationSeconds()));
            }
            case "dataflowEdges": {
                return Optional.ofNullable(clazz.cast(this.dataflowEdges()));
            }
            case "minimumViableContactDurationSeconds": {
                return Optional.ofNullable(clazz.cast(this.minimumViableContactDurationSeconds()));
            }
            case "missionProfileArn": {
                return Optional.ofNullable(clazz.cast(this.missionProfileArn()));
            }
            case "missionProfileId": {
                return Optional.ofNullable(clazz.cast(this.missionProfileId()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "trackingConfigArn": {
                return Optional.ofNullable(clazz.cast(this.trackingConfigArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMissionProfileResponse, T> g) {
        return obj -> g.apply((GetMissionProfileResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GroundStationResponse.BuilderImpl
    implements Builder {
        private Integer contactPostPassDurationSeconds;
        private Integer contactPrePassDurationSeconds;
        private List<List<String>> dataflowEdges = DefaultSdkAutoConstructList.getInstance();
        private Integer minimumViableContactDurationSeconds;
        private String missionProfileArn;
        private String missionProfileId;
        private String name;
        private String region;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String trackingConfigArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMissionProfileResponse model) {
            super(model);
            this.contactPostPassDurationSeconds(model.contactPostPassDurationSeconds);
            this.contactPrePassDurationSeconds(model.contactPrePassDurationSeconds);
            this.dataflowEdges(model.dataflowEdges);
            this.minimumViableContactDurationSeconds(model.minimumViableContactDurationSeconds);
            this.missionProfileArn(model.missionProfileArn);
            this.missionProfileId(model.missionProfileId);
            this.name(model.name);
            this.region(model.region);
            this.tags(model.tags);
            this.trackingConfigArn(model.trackingConfigArn);
        }

        public final Integer getContactPostPassDurationSeconds() {
            return this.contactPostPassDurationSeconds;
        }

        @Override
        public final Builder contactPostPassDurationSeconds(Integer contactPostPassDurationSeconds) {
            this.contactPostPassDurationSeconds = contactPostPassDurationSeconds;
            return this;
        }

        public final void setContactPostPassDurationSeconds(Integer contactPostPassDurationSeconds) {
            this.contactPostPassDurationSeconds = contactPostPassDurationSeconds;
        }

        public final Integer getContactPrePassDurationSeconds() {
            return this.contactPrePassDurationSeconds;
        }

        @Override
        public final Builder contactPrePassDurationSeconds(Integer contactPrePassDurationSeconds) {
            this.contactPrePassDurationSeconds = contactPrePassDurationSeconds;
            return this;
        }

        public final void setContactPrePassDurationSeconds(Integer contactPrePassDurationSeconds) {
            this.contactPrePassDurationSeconds = contactPrePassDurationSeconds;
        }

        public final Collection<? extends Collection<String>> getDataflowEdges() {
            return this.dataflowEdges;
        }

        @Override
        public final Builder dataflowEdges(Collection<? extends Collection<String>> dataflowEdges) {
            this.dataflowEdges = DataflowEdgeListCopier.copy(dataflowEdges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataflowEdges(Collection<String> ... dataflowEdges) {
            this.dataflowEdges((Collection<? extends Collection<String>>)Arrays.asList(dataflowEdges));
            return this;
        }

        public final void setDataflowEdges(Collection<? extends Collection<String>> dataflowEdges) {
            this.dataflowEdges = DataflowEdgeListCopier.copy(dataflowEdges);
        }

        public final Integer getMinimumViableContactDurationSeconds() {
            return this.minimumViableContactDurationSeconds;
        }

        @Override
        public final Builder minimumViableContactDurationSeconds(Integer minimumViableContactDurationSeconds) {
            this.minimumViableContactDurationSeconds = minimumViableContactDurationSeconds;
            return this;
        }

        public final void setMinimumViableContactDurationSeconds(Integer minimumViableContactDurationSeconds) {
            this.minimumViableContactDurationSeconds = minimumViableContactDurationSeconds;
        }

        public final String getMissionProfileArn() {
            return this.missionProfileArn;
        }

        @Override
        public final Builder missionProfileArn(String missionProfileArn) {
            this.missionProfileArn = missionProfileArn;
            return this;
        }

        public final void setMissionProfileArn(String missionProfileArn) {
            this.missionProfileArn = missionProfileArn;
        }

        public final String getMissionProfileId() {
            return this.missionProfileId;
        }

        @Override
        public final Builder missionProfileId(String missionProfileId) {
            this.missionProfileId = missionProfileId;
            return this;
        }

        public final void setMissionProfileId(String missionProfileId) {
            this.missionProfileId = missionProfileId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getRegion() {
            return this.region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public final Map<String, String> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        public final String getTrackingConfigArn() {
            return this.trackingConfigArn;
        }

        @Override
        public final Builder trackingConfigArn(String trackingConfigArn) {
            this.trackingConfigArn = trackingConfigArn;
            return this;
        }

        public final void setTrackingConfigArn(String trackingConfigArn) {
            this.trackingConfigArn = trackingConfigArn;
        }

        @Override
        public GetMissionProfileResponse build() {
            return new GetMissionProfileResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GroundStationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetMissionProfileResponse> {
        public Builder contactPostPassDurationSeconds(Integer var1);

        public Builder contactPrePassDurationSeconds(Integer var1);

        public Builder dataflowEdges(Collection<? extends Collection<String>> var1);

        public Builder dataflowEdges(Collection<String> ... var1);

        public Builder minimumViableContactDurationSeconds(Integer var1);

        public Builder missionProfileArn(String var1);

        public Builder missionProfileId(String var1);

        public Builder name(String var1);

        public Builder region(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder trackingConfigArn(String var1);
    }
}

