/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SatelliteListItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SatelliteListItem> {
    private static final SdkField<Integer> NORAD_SATELLITE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(SatelliteListItem.getter(SatelliteListItem::noradSatelliteID)).setter(SatelliteListItem.setter(Builder::noradSatelliteID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("noradSatelliteID").build()}).build();
    private static final SdkField<String> SATELLITE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SatelliteListItem.getter(SatelliteListItem::satelliteArn)).setter(SatelliteListItem.setter(Builder::satelliteArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("satelliteArn").build()}).build();
    private static final SdkField<String> SATELLITE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SatelliteListItem.getter(SatelliteListItem::satelliteId)).setter(SatelliteListItem.setter(Builder::satelliteId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("satelliteId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NORAD_SATELLITE_ID_FIELD, SATELLITE_ARN_FIELD, SATELLITE_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer noradSatelliteID;
    private final String satelliteArn;
    private final String satelliteId;

    private SatelliteListItem(BuilderImpl builder) {
        this.noradSatelliteID = builder.noradSatelliteID;
        this.satelliteArn = builder.satelliteArn;
        this.satelliteId = builder.satelliteId;
    }

    public Integer noradSatelliteID() {
        return this.noradSatelliteID;
    }

    public String satelliteArn() {
        return this.satelliteArn;
    }

    public String satelliteId() {
        return this.satelliteId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.noradSatelliteID());
        hashCode = 31 * hashCode + Objects.hashCode(this.satelliteArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.satelliteId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SatelliteListItem)) {
            return false;
        }
        SatelliteListItem other = (SatelliteListItem)obj;
        return Objects.equals(this.noradSatelliteID(), other.noradSatelliteID()) && Objects.equals(this.satelliteArn(), other.satelliteArn()) && Objects.equals(this.satelliteId(), other.satelliteId());
    }

    public String toString() {
        return ToString.builder((String)"SatelliteListItem").add("NoradSatelliteID", (Object)this.noradSatelliteID()).add("SatelliteArn", (Object)this.satelliteArn()).add("SatelliteId", (Object)this.satelliteId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "noradSatelliteID": {
                return Optional.ofNullable(clazz.cast(this.noradSatelliteID()));
            }
            case "satelliteArn": {
                return Optional.ofNullable(clazz.cast(this.satelliteArn()));
            }
            case "satelliteId": {
                return Optional.ofNullable(clazz.cast(this.satelliteId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SatelliteListItem, T> g) {
        return obj -> g.apply((SatelliteListItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer noradSatelliteID;
        private String satelliteArn;
        private String satelliteId;

        private BuilderImpl() {
        }

        private BuilderImpl(SatelliteListItem model) {
            this.noradSatelliteID(model.noradSatelliteID);
            this.satelliteArn(model.satelliteArn);
            this.satelliteId(model.satelliteId);
        }

        public final Integer getNoradSatelliteID() {
            return this.noradSatelliteID;
        }

        @Override
        public final Builder noradSatelliteID(Integer noradSatelliteID) {
            this.noradSatelliteID = noradSatelliteID;
            return this;
        }

        public final void setNoradSatelliteID(Integer noradSatelliteID) {
            this.noradSatelliteID = noradSatelliteID;
        }

        public final String getSatelliteArn() {
            return this.satelliteArn;
        }

        @Override
        public final Builder satelliteArn(String satelliteArn) {
            this.satelliteArn = satelliteArn;
            return this;
        }

        public final void setSatelliteArn(String satelliteArn) {
            this.satelliteArn = satelliteArn;
        }

        public final String getSatelliteId() {
            return this.satelliteId;
        }

        @Override
        public final Builder satelliteId(String satelliteId) {
            this.satelliteId = satelliteId;
            return this;
        }

        public final void setSatelliteId(String satelliteId) {
            this.satelliteId = satelliteId;
        }

        public SatelliteListItem build() {
            return new SatelliteListItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SatelliteListItem> {
        public Builder noradSatelliteID(Integer var1);

        public Builder satelliteArn(String var1);

        public Builder satelliteId(String var1);
    }
}

