/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.groundstation.model.EndpointStatus;
import software.amazon.awssdk.services.groundstation.model.SocketAddress;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataflowEndpoint
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataflowEndpoint> {
    private static final SdkField<SocketAddress> ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DataflowEndpoint.getter(DataflowEndpoint::address)).setter(DataflowEndpoint.setter(Builder::address)).constructor(SocketAddress::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("address").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DataflowEndpoint.getter(DataflowEndpoint::name)).setter(DataflowEndpoint.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DataflowEndpoint.getter(DataflowEndpoint::statusAsString)).setter(DataflowEndpoint.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDRESS_FIELD, NAME_FIELD, STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final SocketAddress address;
    private final String name;
    private final String status;

    private DataflowEndpoint(BuilderImpl builder) {
        this.address = builder.address;
        this.name = builder.name;
        this.status = builder.status;
    }

    public SocketAddress address() {
        return this.address;
    }

    public String name() {
        return this.name;
    }

    public EndpointStatus status() {
        return EndpointStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.address());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataflowEndpoint)) {
            return false;
        }
        DataflowEndpoint other = (DataflowEndpoint)obj;
        return Objects.equals(this.address(), other.address()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public String toString() {
        return ToString.builder((String)"DataflowEndpoint").add("Address", (Object)this.address()).add("Name", (Object)this.name()).add("Status", (Object)this.statusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "address": {
                return Optional.ofNullable(clazz.cast(this.address()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataflowEndpoint, T> g) {
        return obj -> g.apply((DataflowEndpoint)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private SocketAddress address;
        private String name;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(DataflowEndpoint model) {
            this.address(model.address);
            this.name(model.name);
            this.status(model.status);
        }

        public final SocketAddress.Builder getAddress() {
            return this.address != null ? this.address.toBuilder() : null;
        }

        @Override
        public final Builder address(SocketAddress address) {
            this.address = address;
            return this;
        }

        public final void setAddress(SocketAddress.BuilderImpl address) {
            this.address = address != null ? address.build() : null;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EndpointStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public DataflowEndpoint build() {
            return new DataflowEndpoint(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataflowEndpoint> {
        public Builder address(SocketAddress var1);

        default public Builder address(Consumer<SocketAddress.Builder> address) {
            return this.address((SocketAddress)((SocketAddress.Builder)SocketAddress.builder().applyMutation(address)).build());
        }

        public Builder name(String var1);

        public Builder status(String var1);

        public Builder status(EndpointStatus var1);
    }
}

