/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.groundstation.model.ConfigCapabilityType;
import software.amazon.awssdk.services.groundstation.model.ConfigDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Destination
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Destination> {
    private static final SdkField<ConfigDetails> CONFIG_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Destination.getter(Destination::configDetails)).setter(Destination.setter(Builder::configDetails)).constructor(ConfigDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configDetails").build()}).build();
    private static final SdkField<String> CONFIG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Destination.getter(Destination::configId)).setter(Destination.setter(Builder::configId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configId").build()}).build();
    private static final SdkField<String> CONFIG_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Destination.getter(Destination::configTypeAsString)).setter(Destination.setter(Builder::configType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configType").build()}).build();
    private static final SdkField<String> DATAFLOW_DESTINATION_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Destination.getter(Destination::dataflowDestinationRegion)).setter(Destination.setter(Builder::dataflowDestinationRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataflowDestinationRegion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIG_DETAILS_FIELD, CONFIG_ID_FIELD, CONFIG_TYPE_FIELD, DATAFLOW_DESTINATION_REGION_FIELD));
    private static final long serialVersionUID = 1L;
    private final ConfigDetails configDetails;
    private final String configId;
    private final String configType;
    private final String dataflowDestinationRegion;

    private Destination(BuilderImpl builder) {
        this.configDetails = builder.configDetails;
        this.configId = builder.configId;
        this.configType = builder.configType;
        this.dataflowDestinationRegion = builder.dataflowDestinationRegion;
    }

    public ConfigDetails configDetails() {
        return this.configDetails;
    }

    public String configId() {
        return this.configId;
    }

    public ConfigCapabilityType configType() {
        return ConfigCapabilityType.fromValue(this.configType);
    }

    public String configTypeAsString() {
        return this.configType;
    }

    public String dataflowDestinationRegion() {
        return this.dataflowDestinationRegion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.configDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.configId());
        hashCode = 31 * hashCode + Objects.hashCode(this.configTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataflowDestinationRegion());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Destination)) {
            return false;
        }
        Destination other = (Destination)obj;
        return Objects.equals(this.configDetails(), other.configDetails()) && Objects.equals(this.configId(), other.configId()) && Objects.equals(this.configTypeAsString(), other.configTypeAsString()) && Objects.equals(this.dataflowDestinationRegion(), other.dataflowDestinationRegion());
    }

    public String toString() {
        return ToString.builder((String)"Destination").add("ConfigDetails", (Object)this.configDetails()).add("ConfigId", (Object)this.configId()).add("ConfigType", (Object)this.configTypeAsString()).add("DataflowDestinationRegion", (Object)this.dataflowDestinationRegion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "configDetails": {
                return Optional.ofNullable(clazz.cast(this.configDetails()));
            }
            case "configId": {
                return Optional.ofNullable(clazz.cast(this.configId()));
            }
            case "configType": {
                return Optional.ofNullable(clazz.cast(this.configTypeAsString()));
            }
            case "dataflowDestinationRegion": {
                return Optional.ofNullable(clazz.cast(this.dataflowDestinationRegion()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Destination, T> g) {
        return obj -> g.apply((Destination)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ConfigDetails configDetails;
        private String configId;
        private String configType;
        private String dataflowDestinationRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(Destination model) {
            this.configDetails(model.configDetails);
            this.configId(model.configId);
            this.configType(model.configType);
            this.dataflowDestinationRegion(model.dataflowDestinationRegion);
        }

        public final ConfigDetails.Builder getConfigDetails() {
            return this.configDetails != null ? this.configDetails.toBuilder() : null;
        }

        @Override
        public final Builder configDetails(ConfigDetails configDetails) {
            this.configDetails = configDetails;
            return this;
        }

        public final void setConfigDetails(ConfigDetails.BuilderImpl configDetails) {
            this.configDetails = configDetails != null ? configDetails.build() : null;
        }

        public final String getConfigId() {
            return this.configId;
        }

        @Override
        public final Builder configId(String configId) {
            this.configId = configId;
            return this;
        }

        public final void setConfigId(String configId) {
            this.configId = configId;
        }

        public final String getConfigType() {
            return this.configType;
        }

        @Override
        public final Builder configType(String configType) {
            this.configType = configType;
            return this;
        }

        @Override
        public final Builder configType(ConfigCapabilityType configType) {
            this.configType(configType == null ? null : configType.toString());
            return this;
        }

        public final void setConfigType(String configType) {
            this.configType = configType;
        }

        public final String getDataflowDestinationRegion() {
            return this.dataflowDestinationRegion;
        }

        @Override
        public final Builder dataflowDestinationRegion(String dataflowDestinationRegion) {
            this.dataflowDestinationRegion = dataflowDestinationRegion;
            return this;
        }

        public final void setDataflowDestinationRegion(String dataflowDestinationRegion) {
            this.dataflowDestinationRegion = dataflowDestinationRegion;
        }

        public Destination build() {
            return new Destination(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Destination> {
        public Builder configDetails(ConfigDetails var1);

        default public Builder configDetails(Consumer<ConfigDetails.Builder> configDetails) {
            return this.configDetails((ConfigDetails)((ConfigDetails.Builder)ConfigDetails.builder().applyMutation(configDetails)).build());
        }

        public Builder configId(String var1);

        public Builder configType(String var1);

        public Builder configType(ConfigCapabilityType var1);

        public Builder dataflowDestinationRegion(String var1);
    }
}

