/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.groundstation.model.DecodeConfig;
import software.amazon.awssdk.services.groundstation.model.DemodulationConfig;
import software.amazon.awssdk.services.groundstation.model.SpectrumConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AntennaDownlinkDemodDecodeConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AntennaDownlinkDemodDecodeConfig> {
    private static final SdkField<DecodeConfig> DECODE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("decodeConfig").getter(AntennaDownlinkDemodDecodeConfig.getter(AntennaDownlinkDemodDecodeConfig::decodeConfig)).setter(AntennaDownlinkDemodDecodeConfig.setter(Builder::decodeConfig)).constructor(DecodeConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("decodeConfig").build()}).build();
    private static final SdkField<DemodulationConfig> DEMODULATION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("demodulationConfig").getter(AntennaDownlinkDemodDecodeConfig.getter(AntennaDownlinkDemodDecodeConfig::demodulationConfig)).setter(AntennaDownlinkDemodDecodeConfig.setter(Builder::demodulationConfig)).constructor(DemodulationConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("demodulationConfig").build()}).build();
    private static final SdkField<SpectrumConfig> SPECTRUM_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("spectrumConfig").getter(AntennaDownlinkDemodDecodeConfig.getter(AntennaDownlinkDemodDecodeConfig::spectrumConfig)).setter(AntennaDownlinkDemodDecodeConfig.setter(Builder::spectrumConfig)).constructor(SpectrumConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spectrumConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DECODE_CONFIG_FIELD, DEMODULATION_CONFIG_FIELD, SPECTRUM_CONFIG_FIELD));
    private static final long serialVersionUID = 1L;
    private final DecodeConfig decodeConfig;
    private final DemodulationConfig demodulationConfig;
    private final SpectrumConfig spectrumConfig;

    private AntennaDownlinkDemodDecodeConfig(BuilderImpl builder) {
        this.decodeConfig = builder.decodeConfig;
        this.demodulationConfig = builder.demodulationConfig;
        this.spectrumConfig = builder.spectrumConfig;
    }

    public DecodeConfig decodeConfig() {
        return this.decodeConfig;
    }

    public DemodulationConfig demodulationConfig() {
        return this.demodulationConfig;
    }

    public SpectrumConfig spectrumConfig() {
        return this.spectrumConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.decodeConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.demodulationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.spectrumConfig());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AntennaDownlinkDemodDecodeConfig)) {
            return false;
        }
        AntennaDownlinkDemodDecodeConfig other = (AntennaDownlinkDemodDecodeConfig)obj;
        return Objects.equals(this.decodeConfig(), other.decodeConfig()) && Objects.equals(this.demodulationConfig(), other.demodulationConfig()) && Objects.equals(this.spectrumConfig(), other.spectrumConfig());
    }

    public String toString() {
        return ToString.builder((String)"AntennaDownlinkDemodDecodeConfig").add("DecodeConfig", (Object)this.decodeConfig()).add("DemodulationConfig", (Object)this.demodulationConfig()).add("SpectrumConfig", (Object)this.spectrumConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "decodeConfig": {
                return Optional.ofNullable(clazz.cast(this.decodeConfig()));
            }
            case "demodulationConfig": {
                return Optional.ofNullable(clazz.cast(this.demodulationConfig()));
            }
            case "spectrumConfig": {
                return Optional.ofNullable(clazz.cast(this.spectrumConfig()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AntennaDownlinkDemodDecodeConfig, T> g) {
        return obj -> g.apply((AntennaDownlinkDemodDecodeConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private DecodeConfig decodeConfig;
        private DemodulationConfig demodulationConfig;
        private SpectrumConfig spectrumConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(AntennaDownlinkDemodDecodeConfig model) {
            this.decodeConfig(model.decodeConfig);
            this.demodulationConfig(model.demodulationConfig);
            this.spectrumConfig(model.spectrumConfig);
        }

        public final DecodeConfig.Builder getDecodeConfig() {
            return this.decodeConfig != null ? this.decodeConfig.toBuilder() : null;
        }

        @Override
        public final Builder decodeConfig(DecodeConfig decodeConfig) {
            this.decodeConfig = decodeConfig;
            return this;
        }

        public final void setDecodeConfig(DecodeConfig.BuilderImpl decodeConfig) {
            this.decodeConfig = decodeConfig != null ? decodeConfig.build() : null;
        }

        public final DemodulationConfig.Builder getDemodulationConfig() {
            return this.demodulationConfig != null ? this.demodulationConfig.toBuilder() : null;
        }

        @Override
        public final Builder demodulationConfig(DemodulationConfig demodulationConfig) {
            this.demodulationConfig = demodulationConfig;
            return this;
        }

        public final void setDemodulationConfig(DemodulationConfig.BuilderImpl demodulationConfig) {
            this.demodulationConfig = demodulationConfig != null ? demodulationConfig.build() : null;
        }

        public final SpectrumConfig.Builder getSpectrumConfig() {
            return this.spectrumConfig != null ? this.spectrumConfig.toBuilder() : null;
        }

        @Override
        public final Builder spectrumConfig(SpectrumConfig spectrumConfig) {
            this.spectrumConfig = spectrumConfig;
            return this;
        }

        public final void setSpectrumConfig(SpectrumConfig.BuilderImpl spectrumConfig) {
            this.spectrumConfig = spectrumConfig != null ? spectrumConfig.build() : null;
        }

        public AntennaDownlinkDemodDecodeConfig build() {
            return new AntennaDownlinkDemodDecodeConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AntennaDownlinkDemodDecodeConfig> {
        public Builder decodeConfig(DecodeConfig var1);

        default public Builder decodeConfig(Consumer<DecodeConfig.Builder> decodeConfig) {
            return this.decodeConfig((DecodeConfig)((DecodeConfig.Builder)DecodeConfig.builder().applyMutation(decodeConfig)).build());
        }

        public Builder demodulationConfig(DemodulationConfig var1);

        default public Builder demodulationConfig(Consumer<DemodulationConfig.Builder> demodulationConfig) {
            return this.demodulationConfig((DemodulationConfig)((DemodulationConfig.Builder)DemodulationConfig.builder().applyMutation(demodulationConfig)).build());
        }

        public Builder spectrumConfig(SpectrumConfig var1);

        default public Builder spectrumConfig(Consumer<SpectrumConfig.Builder> spectrumConfig) {
            return this.spectrumConfig((SpectrumConfig)((SpectrumConfig.Builder)SpectrumConfig.builder().applyMutation(spectrumConfig)).build());
        }
    }
}

