/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.groundstation.model.EndpointDetails;
import software.amazon.awssdk.services.groundstation.model.EndpointDetailsListCopier;
import software.amazon.awssdk.services.groundstation.model.GroundStationRequest;
import software.amazon.awssdk.services.groundstation.model.TagsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDataflowEndpointGroupRequest
extends GroundStationRequest
implements ToCopyableBuilder<Builder, CreateDataflowEndpointGroupRequest> {
    private static final SdkField<List<EndpointDetails>> ENDPOINT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("endpointDetails").getter(CreateDataflowEndpointGroupRequest.getter(CreateDataflowEndpointGroupRequest::endpointDetails)).setter(CreateDataflowEndpointGroupRequest.setter(Builder::endpointDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpointDetails").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EndpointDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateDataflowEndpointGroupRequest.getter(CreateDataflowEndpointGroupRequest::tags)).setter(CreateDataflowEndpointGroupRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_DETAILS_FIELD, TAGS_FIELD));
    private final List<EndpointDetails> endpointDetails;
    private final Map<String, String> tags;

    private CreateDataflowEndpointGroupRequest(BuilderImpl builder) {
        super(builder);
        this.endpointDetails = builder.endpointDetails;
        this.tags = builder.tags;
    }

    public boolean hasEndpointDetails() {
        return this.endpointDetails != null && !(this.endpointDetails instanceof SdkAutoConstructList);
    }

    public List<EndpointDetails> endpointDetails() {
        return this.endpointDetails;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEndpointDetails() ? this.endpointDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataflowEndpointGroupRequest)) {
            return false;
        }
        CreateDataflowEndpointGroupRequest other = (CreateDataflowEndpointGroupRequest)((Object)obj);
        return this.hasEndpointDetails() == other.hasEndpointDetails() && Objects.equals(this.endpointDetails(), other.endpointDetails()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"CreateDataflowEndpointGroupRequest").add("EndpointDetails", this.hasEndpointDetails() ? this.endpointDetails() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "endpointDetails": {
                return Optional.ofNullable(clazz.cast(this.endpointDetails()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDataflowEndpointGroupRequest, T> g) {
        return obj -> g.apply((CreateDataflowEndpointGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GroundStationRequest.BuilderImpl
    implements Builder {
        private List<EndpointDetails> endpointDetails = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDataflowEndpointGroupRequest model) {
            super(model);
            this.endpointDetails(model.endpointDetails);
            this.tags(model.tags);
        }

        public final Collection<EndpointDetails.Builder> getEndpointDetails() {
            if (this.endpointDetails instanceof SdkAutoConstructList) {
                return null;
            }
            return this.endpointDetails != null ? (Collection)this.endpointDetails.stream().map(EndpointDetails::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder endpointDetails(Collection<EndpointDetails> endpointDetails) {
            this.endpointDetails = EndpointDetailsListCopier.copy(endpointDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpointDetails(EndpointDetails ... endpointDetails) {
            this.endpointDetails(Arrays.asList(endpointDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpointDetails(Consumer<EndpointDetails.Builder> ... endpointDetails) {
            this.endpointDetails(Stream.of(endpointDetails).map(c -> (EndpointDetails)((EndpointDetails.Builder)EndpointDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEndpointDetails(Collection<EndpointDetails.BuilderImpl> endpointDetails) {
            this.endpointDetails = EndpointDetailsListCopier.copyFromBuilder(endpointDetails);
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDataflowEndpointGroupRequest build() {
            return new CreateDataflowEndpointGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GroundStationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDataflowEndpointGroupRequest> {
        public Builder endpointDetails(Collection<EndpointDetails> var1);

        public Builder endpointDetails(EndpointDetails ... var1);

        public Builder endpointDetails(Consumer<EndpointDetails.Builder> ... var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

