/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.groundstation.model.GroundStationRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetMinuteUsageRequest
extends GroundStationRequest
implements ToCopyableBuilder<Builder, GetMinuteUsageRequest> {
    private static final SdkField<Integer> MONTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("month").getter(GetMinuteUsageRequest.getter(GetMinuteUsageRequest::month)).setter(GetMinuteUsageRequest.setter(Builder::month)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("month").build()}).build();
    private static final SdkField<Integer> YEAR_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("year").getter(GetMinuteUsageRequest.getter(GetMinuteUsageRequest::year)).setter(GetMinuteUsageRequest.setter(Builder::year)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("year").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MONTH_FIELD, YEAR_FIELD));
    private final Integer month;
    private final Integer year;

    private GetMinuteUsageRequest(BuilderImpl builder) {
        super(builder);
        this.month = builder.month;
        this.year = builder.year;
    }

    public Integer month() {
        return this.month;
    }

    public Integer year() {
        return this.year;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.month());
        hashCode = 31 * hashCode + Objects.hashCode(this.year());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMinuteUsageRequest)) {
            return false;
        }
        GetMinuteUsageRequest other = (GetMinuteUsageRequest)((Object)obj);
        return Objects.equals(this.month(), other.month()) && Objects.equals(this.year(), other.year());
    }

    public String toString() {
        return ToString.builder((String)"GetMinuteUsageRequest").add("Month", (Object)this.month()).add("Year", (Object)this.year()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "month": {
                return Optional.ofNullable(clazz.cast(this.month()));
            }
            case "year": {
                return Optional.ofNullable(clazz.cast(this.year()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMinuteUsageRequest, T> g) {
        return obj -> g.apply((GetMinuteUsageRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GroundStationRequest.BuilderImpl
    implements Builder {
        private Integer month;
        private Integer year;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMinuteUsageRequest model) {
            super(model);
            this.month(model.month);
            this.year(model.year);
        }

        public final Integer getMonth() {
            return this.month;
        }

        @Override
        public final Builder month(Integer month) {
            this.month = month;
            return this;
        }

        public final void setMonth(Integer month) {
            this.month = month;
        }

        public final Integer getYear() {
            return this.year;
        }

        @Override
        public final Builder year(Integer year) {
            this.year = year;
            return this;
        }

        public final void setYear(Integer year) {
            this.year = year;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetMinuteUsageRequest build() {
            return new GetMinuteUsageRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GroundStationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetMinuteUsageRequest> {
        public Builder month(Integer var1);

        public Builder year(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

