/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GroundStationData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GroundStationData> {
    private static final SdkField<String> GROUND_STATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("groundStationId").getter(GroundStationData.getter(GroundStationData::groundStationId)).setter(GroundStationData.setter(Builder::groundStationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groundStationId").build()}).build();
    private static final SdkField<String> GROUND_STATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("groundStationName").getter(GroundStationData.getter(GroundStationData::groundStationName)).setter(GroundStationData.setter(Builder::groundStationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groundStationName").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("region").getter(GroundStationData.getter(GroundStationData::region)).setter(GroundStationData.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUND_STATION_ID_FIELD, GROUND_STATION_NAME_FIELD, REGION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String groundStationId;
    private final String groundStationName;
    private final String region;

    private GroundStationData(BuilderImpl builder) {
        this.groundStationId = builder.groundStationId;
        this.groundStationName = builder.groundStationName;
        this.region = builder.region;
    }

    public String groundStationId() {
        return this.groundStationId;
    }

    public String groundStationName() {
        return this.groundStationName;
    }

    public String region() {
        return this.region;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.groundStationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.groundStationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GroundStationData)) {
            return false;
        }
        GroundStationData other = (GroundStationData)obj;
        return Objects.equals(this.groundStationId(), other.groundStationId()) && Objects.equals(this.groundStationName(), other.groundStationName()) && Objects.equals(this.region(), other.region());
    }

    public String toString() {
        return ToString.builder((String)"GroundStationData").add("GroundStationId", (Object)this.groundStationId()).add("GroundStationName", (Object)this.groundStationName()).add("Region", (Object)this.region()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "groundStationId": {
                return Optional.ofNullable(clazz.cast(this.groundStationId()));
            }
            case "groundStationName": {
                return Optional.ofNullable(clazz.cast(this.groundStationName()));
            }
            case "region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GroundStationData, T> g) {
        return obj -> g.apply((GroundStationData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String groundStationId;
        private String groundStationName;
        private String region;

        private BuilderImpl() {
        }

        private BuilderImpl(GroundStationData model) {
            this.groundStationId(model.groundStationId);
            this.groundStationName(model.groundStationName);
            this.region(model.region);
        }

        public final String getGroundStationId() {
            return this.groundStationId;
        }

        @Override
        public final Builder groundStationId(String groundStationId) {
            this.groundStationId = groundStationId;
            return this;
        }

        public final void setGroundStationId(String groundStationId) {
            this.groundStationId = groundStationId;
        }

        public final String getGroundStationName() {
            return this.groundStationName;
        }

        @Override
        public final Builder groundStationName(String groundStationName) {
            this.groundStationName = groundStationName;
            return this;
        }

        public final void setGroundStationName(String groundStationName) {
            this.groundStationName = groundStationName;
        }

        public final String getRegion() {
            return this.region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public GroundStationData build() {
            return new GroundStationData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GroundStationData> {
        public Builder groundStationId(String var1);

        public Builder groundStationName(String var1);

        public Builder region(String var1);
    }
}

