/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.groundstation.model.ConfigListCopier;
import software.amazon.awssdk.services.groundstation.model.ConfigListItem;
import software.amazon.awssdk.services.groundstation.model.GroundStationResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListConfigsResponse
extends GroundStationResponse
implements ToCopyableBuilder<Builder, ListConfigsResponse> {
    private static final SdkField<List<ConfigListItem>> CONFIG_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("configList").getter(ListConfigsResponse.getter(ListConfigsResponse::configList)).setter(ListConfigsResponse.setter(Builder::configList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConfigListItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListConfigsResponse.getter(ListConfigsResponse::nextToken)).setter(ListConfigsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIG_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final List<ConfigListItem> configList;
    private final String nextToken;

    private ListConfigsResponse(BuilderImpl builder) {
        super(builder);
        this.configList = builder.configList;
        this.nextToken = builder.nextToken;
    }

    public boolean hasConfigList() {
        return this.configList != null && !(this.configList instanceof SdkAutoConstructList);
    }

    public List<ConfigListItem> configList() {
        return this.configList;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConfigList() ? this.configList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConfigsResponse)) {
            return false;
        }
        ListConfigsResponse other = (ListConfigsResponse)((Object)obj);
        return this.hasConfigList() == other.hasConfigList() && Objects.equals(this.configList(), other.configList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListConfigsResponse").add("ConfigList", this.hasConfigList() ? this.configList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "configList": {
                return Optional.ofNullable(clazz.cast(this.configList()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListConfigsResponse, T> g) {
        return obj -> g.apply((ListConfigsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GroundStationResponse.BuilderImpl
    implements Builder {
        private List<ConfigListItem> configList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListConfigsResponse model) {
            super(model);
            this.configList(model.configList);
            this.nextToken(model.nextToken);
        }

        public final Collection<ConfigListItem.Builder> getConfigList() {
            if (this.configList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.configList != null ? (Collection)this.configList.stream().map(ConfigListItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder configList(Collection<ConfigListItem> configList) {
            this.configList = ConfigListCopier.copy(configList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configList(ConfigListItem ... configList) {
            this.configList(Arrays.asList(configList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configList(Consumer<ConfigListItem.Builder> ... configList) {
            this.configList(Stream.of(configList).map(c -> (ConfigListItem)((ConfigListItem.Builder)ConfigListItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setConfigList(Collection<ConfigListItem.BuilderImpl> configList) {
            this.configList = ConfigListCopier.copyFromBuilder(configList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListConfigsResponse build() {
            return new ListConfigsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GroundStationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListConfigsResponse> {
        public Builder configList(Collection<ConfigListItem> var1);

        public Builder configList(ConfigListItem ... var1);

        public Builder configList(Consumer<ConfigListItem.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

