/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.groundstation.model.DataflowEndpointGroupListCopier;
import software.amazon.awssdk.services.groundstation.model.DataflowEndpointListItem;
import software.amazon.awssdk.services.groundstation.model.GroundStationResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDataflowEndpointGroupsResponse
extends GroundStationResponse
implements ToCopyableBuilder<Builder, ListDataflowEndpointGroupsResponse> {
    private static final SdkField<List<DataflowEndpointListItem>> DATAFLOW_ENDPOINT_GROUP_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("dataflowEndpointGroupList").getter(ListDataflowEndpointGroupsResponse.getter(ListDataflowEndpointGroupsResponse::dataflowEndpointGroupList)).setter(ListDataflowEndpointGroupsResponse.setter(Builder::dataflowEndpointGroupList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataflowEndpointGroupList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataflowEndpointListItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListDataflowEndpointGroupsResponse.getter(ListDataflowEndpointGroupsResponse::nextToken)).setter(ListDataflowEndpointGroupsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATAFLOW_ENDPOINT_GROUP_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final List<DataflowEndpointListItem> dataflowEndpointGroupList;
    private final String nextToken;

    private ListDataflowEndpointGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.dataflowEndpointGroupList = builder.dataflowEndpointGroupList;
        this.nextToken = builder.nextToken;
    }

    public boolean hasDataflowEndpointGroupList() {
        return this.dataflowEndpointGroupList != null && !(this.dataflowEndpointGroupList instanceof SdkAutoConstructList);
    }

    public List<DataflowEndpointListItem> dataflowEndpointGroupList() {
        return this.dataflowEndpointGroupList;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDataflowEndpointGroupList() ? this.dataflowEndpointGroupList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDataflowEndpointGroupsResponse)) {
            return false;
        }
        ListDataflowEndpointGroupsResponse other = (ListDataflowEndpointGroupsResponse)((Object)obj);
        return this.hasDataflowEndpointGroupList() == other.hasDataflowEndpointGroupList() && Objects.equals(this.dataflowEndpointGroupList(), other.dataflowEndpointGroupList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListDataflowEndpointGroupsResponse").add("DataflowEndpointGroupList", this.hasDataflowEndpointGroupList() ? this.dataflowEndpointGroupList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "dataflowEndpointGroupList": {
                return Optional.ofNullable(clazz.cast(this.dataflowEndpointGroupList()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDataflowEndpointGroupsResponse, T> g) {
        return obj -> g.apply((ListDataflowEndpointGroupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GroundStationResponse.BuilderImpl
    implements Builder {
        private List<DataflowEndpointListItem> dataflowEndpointGroupList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDataflowEndpointGroupsResponse model) {
            super(model);
            this.dataflowEndpointGroupList(model.dataflowEndpointGroupList);
            this.nextToken(model.nextToken);
        }

        public final Collection<DataflowEndpointListItem.Builder> getDataflowEndpointGroupList() {
            if (this.dataflowEndpointGroupList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dataflowEndpointGroupList != null ? (Collection)this.dataflowEndpointGroupList.stream().map(DataflowEndpointListItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dataflowEndpointGroupList(Collection<DataflowEndpointListItem> dataflowEndpointGroupList) {
            this.dataflowEndpointGroupList = DataflowEndpointGroupListCopier.copy(dataflowEndpointGroupList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataflowEndpointGroupList(DataflowEndpointListItem ... dataflowEndpointGroupList) {
            this.dataflowEndpointGroupList(Arrays.asList(dataflowEndpointGroupList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataflowEndpointGroupList(Consumer<DataflowEndpointListItem.Builder> ... dataflowEndpointGroupList) {
            this.dataflowEndpointGroupList(Stream.of(dataflowEndpointGroupList).map(c -> (DataflowEndpointListItem)((DataflowEndpointListItem.Builder)DataflowEndpointListItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDataflowEndpointGroupList(Collection<DataflowEndpointListItem.BuilderImpl> dataflowEndpointGroupList) {
            this.dataflowEndpointGroupList = DataflowEndpointGroupListCopier.copyFromBuilder(dataflowEndpointGroupList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListDataflowEndpointGroupsResponse build() {
            return new ListDataflowEndpointGroupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GroundStationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDataflowEndpointGroupsResponse> {
        public Builder dataflowEndpointGroupList(Collection<DataflowEndpointListItem> var1);

        public Builder dataflowEndpointGroupList(DataflowEndpointListItem ... var1);

        public Builder dataflowEndpointGroupList(Consumer<DataflowEndpointListItem.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

