/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.groundstation.model.GroundStationResponse;
import software.amazon.awssdk.services.groundstation.model.SatelliteListCopier;
import software.amazon.awssdk.services.groundstation.model.SatelliteListItem;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSatellitesResponse
extends GroundStationResponse
implements ToCopyableBuilder<Builder, ListSatellitesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListSatellitesResponse.getter(ListSatellitesResponse::nextToken)).setter(ListSatellitesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<SatelliteListItem>> SATELLITES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("satellites").getter(ListSatellitesResponse.getter(ListSatellitesResponse::satellites)).setter(ListSatellitesResponse.setter(Builder::satellites)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("satellites").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SatelliteListItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, SATELLITES_FIELD));
    private final String nextToken;
    private final List<SatelliteListItem> satellites;

    private ListSatellitesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.satellites = builder.satellites;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public boolean hasSatellites() {
        return this.satellites != null && !(this.satellites instanceof SdkAutoConstructList);
    }

    public List<SatelliteListItem> satellites() {
        return this.satellites;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSatellites() ? this.satellites() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSatellitesResponse)) {
            return false;
        }
        ListSatellitesResponse other = (ListSatellitesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasSatellites() == other.hasSatellites() && Objects.equals(this.satellites(), other.satellites());
    }

    public String toString() {
        return ToString.builder((String)"ListSatellitesResponse").add("NextToken", (Object)this.nextToken()).add("Satellites", this.hasSatellites() ? this.satellites() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "satellites": {
                return Optional.ofNullable(clazz.cast(this.satellites()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSatellitesResponse, T> g) {
        return obj -> g.apply((ListSatellitesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GroundStationResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<SatelliteListItem> satellites = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListSatellitesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.satellites(model.satellites);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<SatelliteListItem.Builder> getSatellites() {
            if (this.satellites instanceof SdkAutoConstructList) {
                return null;
            }
            return this.satellites != null ? (Collection)this.satellites.stream().map(SatelliteListItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder satellites(Collection<SatelliteListItem> satellites) {
            this.satellites = SatelliteListCopier.copy(satellites);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder satellites(SatelliteListItem ... satellites) {
            this.satellites(Arrays.asList(satellites));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder satellites(Consumer<SatelliteListItem.Builder> ... satellites) {
            this.satellites(Stream.of(satellites).map(c -> (SatelliteListItem)((SatelliteListItem.Builder)SatelliteListItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSatellites(Collection<SatelliteListItem.BuilderImpl> satellites) {
            this.satellites = SatelliteListCopier.copyFromBuilder(satellites);
        }

        @Override
        public ListSatellitesResponse build() {
            return new ListSatellitesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GroundStationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSatellitesResponse> {
        public Builder nextToken(String var1);

        public Builder satellites(Collection<SatelliteListItem> var1);

        public Builder satellites(SatelliteListItem ... var1);

        public Builder satellites(Consumer<SatelliteListItem.Builder> ... var1);
    }
}

