/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.groundstation.model.ConfigCapabilityType;
import software.amazon.awssdk.services.groundstation.model.GroundStationRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetConfigRequest
extends GroundStationRequest
implements ToCopyableBuilder<Builder, GetConfigRequest> {
    private static final SdkField<String> CONFIG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("configId").getter(GetConfigRequest.getter(GetConfigRequest::configId)).setter(GetConfigRequest.setter(Builder::configId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("configId").build()}).build();
    private static final SdkField<String> CONFIG_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("configType").getter(GetConfigRequest.getter(GetConfigRequest::configTypeAsString)).setter(GetConfigRequest.setter(Builder::configType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("configType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIG_ID_FIELD, CONFIG_TYPE_FIELD));
    private final String configId;
    private final String configType;

    private GetConfigRequest(BuilderImpl builder) {
        super(builder);
        this.configId = builder.configId;
        this.configType = builder.configType;
    }

    public final String configId() {
        return this.configId;
    }

    public final ConfigCapabilityType configType() {
        return ConfigCapabilityType.fromValue(this.configType);
    }

    public final String configTypeAsString() {
        return this.configType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.configId());
        hashCode = 31 * hashCode + Objects.hashCode(this.configTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConfigRequest)) {
            return false;
        }
        GetConfigRequest other = (GetConfigRequest)((Object)obj);
        return Objects.equals(this.configId(), other.configId()) && Objects.equals(this.configTypeAsString(), other.configTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetConfigRequest").add("ConfigId", (Object)this.configId()).add("ConfigType", (Object)this.configTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "configId": {
                return Optional.ofNullable(clazz.cast(this.configId()));
            }
            case "configType": {
                return Optional.ofNullable(clazz.cast(this.configTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetConfigRequest, T> g) {
        return obj -> g.apply((GetConfigRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GroundStationRequest.BuilderImpl
    implements Builder {
        private String configId;
        private String configType;

        private BuilderImpl() {
        }

        private BuilderImpl(GetConfigRequest model) {
            super(model);
            this.configId(model.configId);
            this.configType(model.configType);
        }

        public final String getConfigId() {
            return this.configId;
        }

        @Override
        public final Builder configId(String configId) {
            this.configId = configId;
            return this;
        }

        public final void setConfigId(String configId) {
            this.configId = configId;
        }

        public final String getConfigType() {
            return this.configType;
        }

        @Override
        public final Builder configType(String configType) {
            this.configType = configType;
            return this;
        }

        @Override
        public final Builder configType(ConfigCapabilityType configType) {
            this.configType(configType == null ? null : configType.toString());
            return this;
        }

        public final void setConfigType(String configType) {
            this.configType = configType;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetConfigRequest build() {
            return new GetConfigRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GroundStationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetConfigRequest> {
        public Builder configId(String var1);

        public Builder configType(String var1);

        public Builder configType(ConfigCapabilityType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

