/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.groundstation.GroundStationClient;
import software.amazon.awssdk.services.groundstation.model.ConfigListItem;
import software.amazon.awssdk.services.groundstation.model.ListConfigsRequest;
import software.amazon.awssdk.services.groundstation.model.ListConfigsResponse;

public class ListConfigsIterable
implements SdkIterable<ListConfigsResponse> {
    private final GroundStationClient client;
    private final ListConfigsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListConfigsIterable(GroundStationClient client, ListConfigsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListConfigsResponseFetcher();
    }

    public Iterator<ListConfigsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ConfigListItem> configList() {
        Function<ListConfigsResponse, Iterator> getIterator = response -> {
            if (response != null && response.configList() != null) {
                return response.configList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListConfigsResponseFetcher
    implements SyncPageFetcher<ListConfigsResponse> {
        private ListConfigsResponseFetcher() {
        }

        public boolean hasNextPage(ListConfigsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListConfigsResponse nextPage(ListConfigsResponse previousPage) {
            if (previousPage == null) {
                return ListConfigsIterable.this.client.listConfigs(ListConfigsIterable.this.firstRequest);
            }
            return ListConfigsIterable.this.client.listConfigs((ListConfigsRequest)((Object)ListConfigsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

