/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListContactsResponse extends GroundStationResponse implements
        ToCopyableBuilder<ListContactsResponse.Builder, ListContactsResponse> {
    private static final SdkField<List<ContactData>> CONTACT_LIST_FIELD = SdkField
            .<List<ContactData>> builder(MarshallingType.LIST)
            .memberName("contactList")
            .getter(getter(ListContactsResponse::contactList))
            .setter(setter(Builder::contactList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contactList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ContactData> builder(MarshallingType.SDK_POJO)
                                            .constructor(ContactData::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListContactsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_LIST_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ContactData> contactList;

    private final String nextToken;

    private ListContactsResponse(BuilderImpl builder) {
        super(builder);
        this.contactList = builder.contactList;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the ContactList property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasContactList() {
        return contactList != null && !(contactList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of contacts.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasContactList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List of contacts.
     */
    public final List<ContactData> contactList() {
        return contactList;
    }

    /**
     * <p>
     * Next token returned in the response of a previous <code>ListContacts</code> call. Used to get the next page of
     * results.
     * </p>
     * 
     * @return Next token returned in the response of a previous <code>ListContacts</code> call. Used to get the next
     *         page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasContactList() ? contactList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListContactsResponse)) {
            return false;
        }
        ListContactsResponse other = (ListContactsResponse) obj;
        return hasContactList() == other.hasContactList() && Objects.equals(contactList(), other.contactList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListContactsResponse").add("ContactList", hasContactList() ? contactList() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "contactList":
            return Optional.ofNullable(clazz.cast(contactList()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListContactsResponse, T> g) {
        return obj -> g.apply((ListContactsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GroundStationResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListContactsResponse> {
        /**
         * <p>
         * List of contacts.
         * </p>
         * 
         * @param contactList
         *        List of contacts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactList(Collection<ContactData> contactList);

        /**
         * <p>
         * List of contacts.
         * </p>
         * 
         * @param contactList
         *        List of contacts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactList(ContactData... contactList);

        /**
         * <p>
         * List of contacts.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ContactData>.Builder} avoiding the need to
         * create one manually via {@link List<ContactData>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ContactData>.Builder#build()} is called immediately and its
         * result is passed to {@link #contactList(List<ContactData>)}.
         * 
         * @param contactList
         *        a consumer that will call methods on {@link List<ContactData>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contactList(List<ContactData>)
         */
        Builder contactList(Consumer<ContactData.Builder>... contactList);

        /**
         * <p>
         * Next token returned in the response of a previous <code>ListContacts</code> call. Used to get the next page
         * of results.
         * </p>
         * 
         * @param nextToken
         *        Next token returned in the response of a previous <code>ListContacts</code> call. Used to get the next
         *        page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends GroundStationResponse.BuilderImpl implements Builder {
        private List<ContactData> contactList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListContactsResponse model) {
            super(model);
            contactList(model.contactList);
            nextToken(model.nextToken);
        }

        public final List<ContactData.Builder> getContactList() {
            List<ContactData.Builder> result = ContactListCopier.copyToBuilder(this.contactList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder contactList(Collection<ContactData> contactList) {
            this.contactList = ContactListCopier.copy(contactList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contactList(ContactData... contactList) {
            contactList(Arrays.asList(contactList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contactList(Consumer<ContactData.Builder>... contactList) {
            contactList(Stream.of(contactList).map(c -> ContactData.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setContactList(Collection<ContactData.BuilderImpl> contactList) {
            this.contactList = ContactListCopier.copyFromBuilder(contactList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListContactsResponse build() {
            return new ListContactsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
